/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;

public final class TokenReader {
    private BufferedReader reader = null;
    private boolean atEol = false;
    private boolean canClose = false;
    private ArrayList tokenStack = null;
    private String lastTokenRead = null;
    private boolean ignoreCommentLines = true;

    public TokenReader() {
        this.lastTokenRead = null;
    }

    public TokenReader(String string) {
        this.lastTokenRead = null;
        if (string.startsWith("http://") || string.startsWith("file://")) {
            this.openHttp(string);
        } else {
            this.open(string);
        }
    }

    public TokenReader(InputStream inputStream) {
        this.setInputStream(inputStream);
    }

    public TokenReader(Reader reader) {
        this.setReader(reader);
    }

    public static TokenReader makeStringTokenReader(String string) {
        TokenReader tokenReader = new TokenReader(new StringReader(string));
        tokenReader.canClose = true;
        return tokenReader;
    }

    public void setIgnoreCommentLines(boolean bl) {
        this.ignoreCommentLines = bl;
    }

    public void setInputStream(InputStream inputStream) {
        this.reader = new BufferedReader(new InputStreamReader(inputStream));
        this.lastTokenRead = null;
        this.clearTokenStack();
    }

    public void setReader(Reader reader) {
        this.reader = new BufferedReader(reader);
        this.lastTokenRead = null;
        this.clearTokenStack();
    }

    public void open(String string) {
        if (string.startsWith("http://") || string.startsWith("file://")) {
            this.openHttp(string);
            this.lastTokenRead = null;
            this.clearTokenStack();
            return;
        }
        try {
            this.reader = new BufferedReader(new FileReader(string));
            this.lastTokenRead = null;
            this.clearTokenStack();
            this.canClose = true;
        }
        catch (Exception exception) {
            System.out.println("TokenReader Caught exception opening file[" + string + "]. " + exception);
            exception.printStackTrace();
        }
    }

    public void openHttp(String string) {
        try {
            URL uRL = new URL(string);
            InputStream inputStream = uRL.openStream();
            this.setInputStream(inputStream);
            this.canClose = true;
        }
        catch (Exception exception) {
            System.out.println("TokenReader Caught exception opening url[" + string + "]. " + exception);
            exception.printStackTrace();
        }
    }

    public void close() {
        if (this.canClose) {
            try {
                this.reader.close();
            }
            catch (Exception exception) {
                System.out.println("TokenReader Caught exception trying to close().  " + exception);
                exception.printStackTrace();
            }
        }
    }

    public boolean atEol() {
        return this.atEol;
    }

    public String readToken() throws IOException {
        if (!this.tokenStackEmpty()) {
            this.lastTokenRead = this.tokenStackPop();
            return this.lastTokenRead;
        }
        StringBuffer stringBuffer = new StringBuffer();
        int n = this.reader.read();
        boolean bl = false;
        while (n == 32 || n == 10 || n == 9) {
            n = this.reader.read();
        }
        if (n == 0 || n == 10) {
            this.atEol = true;
        }
        while (n > 0 && n != 32 && n != 10 && n != 9) {
            stringBuffer.append((char)n);
            bl = true;
            this.atEol = false;
            n = this.reader.read();
        }
        if (n == 0 || n == 10) {
            this.atEol = true;
        }
        if (bl) {
            String string = stringBuffer.toString();
            if (this.ignoreCommentLines && string.startsWith("//")) {
                String string2 = this.readLine();
                return this.readToken();
            }
            this.lastTokenRead = string;
            return this.lastTokenRead;
        }
        return null;
    }

    public String readUntilToken(String string) throws IOException {
        String string2 = this.readToken();
        while (string2 != null && !string2.equalsIgnoreCase(string)) {
            string2 = this.readToken();
        }
        return string2;
    }

    public String gatherUntilToken(String string, boolean bl) throws IOException {
        StringBuffer stringBuffer = new StringBuffer();
        String string2 = this.readToken();
        boolean bl2 = true;
        while (string2 != null && !string2.equalsIgnoreCase(string)) {
            if (!bl2) {
                stringBuffer.append(' ');
            }
            bl2 = false;
            stringBuffer.append(string2);
            string2 = this.readToken();
        }
        if (bl && string2 != null) {
            if (!bl2) {
                stringBuffer.append(' ');
            }
            stringBuffer.append(string2);
        }
        return stringBuffer.toString();
    }

    public List gatherTokensUntilToken(String string, boolean bl) throws IOException {
        ArrayList<String> arrayList = new ArrayList<String>();
        String string2 = this.readToken();
        boolean bl2 = true;
        while (string2 != null && !string2.equalsIgnoreCase(string)) {
            arrayList.add(string2);
            string2 = this.readToken();
        }
        if (bl && string2 != null) {
            arrayList.add(string2);
        }
        return arrayList;
    }

    public void pushToken() {
        if (this.lastTokenRead != null) {
            this.pushToken(this.lastTokenRead);
            this.lastTokenRead = null;
        }
    }

    public void pushToken(String string) {
        if (this.tokenStack == null) {
            this.makeTokenStack();
        }
        this.tokenStackPush(string);
    }

    public String getLastTokenRead() {
        return this.lastTokenRead;
    }

    public String readTokenBeforeEol() throws IOException {
        if (this.atEol()) {
            return null;
        }
        return this.readToken();
    }

    public int readInt() throws IOException, NumberFormatException {
        String string = this.readToken();
        return Integer.parseInt(string);
    }

    public float readFloat() throws IOException, NumberFormatException {
        String string = this.readToken();
        return Float.parseFloat(string);
    }

    public double readDouble() throws IOException, NumberFormatException {
        String string = this.readToken();
        return Double.parseDouble(string);
    }

    public boolean readBoolean() throws IOException, NumberFormatException {
        String string = this.readToken();
        return string.equalsIgnoreCase("true");
    }

    public String readLine() throws IOException {
        String string = this.reader.readLine();
        this.atEol = true;
        return string;
    }

    private void clearTokenStack() {
        this.tokenStack = null;
    }

    private void makeTokenStack() {
        this.tokenStack = new ArrayList(10);
    }

    private String tokenStackTop() {
        if (this.tokenStack == null) {
            return null;
        }
        int n = this.tokenStack.size();
        if (n > 0) {
            return (String)this.tokenStack.get(n - 1);
        }
        return null;
    }

    private String tokenStackPop() {
        int n = this.tokenStack.size();
        if (n > 0) {
            String string = (String)this.tokenStack.remove(n - 1);
            return string;
        }
        return null;
    }

    private void tokenStackPush(String string) {
        if (this.tokenStack == null) {
            this.makeTokenStack();
        }
        this.tokenStack.add(string);
    }

    private boolean tokenStackEmpty() {
        return this.tokenStack == null || this.tokenStack.size() <= 0;
    }

    public String printTokenStack() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.tokenStackEmpty()) {
            stringBuffer.append("EMPTY");
        } else {
            for (int i = this.tokenStack.size() - 1; i >= 0; --i) {
                stringBuffer.append(this.tokenStack.get(i));
                stringBuffer.append(":");
            }
        }
        return stringBuffer.toString();
    }

    public static void main(String[] stringArray) {
        try {
            if (stringArray.length > 0) {
                String string = stringArray[0];
                TokenReader tokenReader = new TokenReader(string);
                boolean bl = false;
                while (!bl) {
                    String string2 = tokenReader.readToken();
                    if (string2 == null) {
                        bl = true;
                        continue;
                    }
                    System.out.println("token: [" + string2 + "]");
                }
            } else {
                System.out.println("Type a token: ");
                TokenReader tokenReader = new TokenReader(System.in);
                String string = tokenReader.readToken();
                System.out.println("Your token was: " + string);
                System.out.println();
                System.out.println("Type an int: ");
                int n = tokenReader.readInt();
                System.out.println("Your int was: " + n);
                System.out.println();
                System.out.println("Type a boolean: ");
                boolean bl = tokenReader.readBoolean();
                System.out.println("Your boolean was: " + bl);
                System.out.println();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

