/*
 * Decompiled with CFR 0.152.
 */
package util;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Composite;
import java.awt.Container;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.geom.Arc2D;
import java.awt.geom.Ellipse2D;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DirectColorModel;
import java.awt.image.RenderedImage;
import java.awt.image.WritableRaster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.swing.ImageIcon;
import javax.swing.JLabel;

public final class StdDraw
implements ActionListener,
MouseListener,
MouseMotionListener,
KeyListener {
    public static final Color BLACK = Color.BLACK;
    public static final Color BLUE = Color.BLUE;
    public static final Color CYAN = Color.CYAN;
    public static final Color DARK_GRAY = Color.DARK_GRAY;
    public static final Color GRAY = Color.GRAY;
    public static final Color GREEN = Color.GREEN;
    public static final Color LIGHT_GRAY = Color.LIGHT_GRAY;
    public static final Color MAGENTA = Color.MAGENTA;
    public static final Color ORANGE = Color.ORANGE;
    public static final Color PINK = Color.PINK;
    public static final Color RED = Color.RED;
    public static final Color WHITE = Color.WHITE;
    public static final Color YELLOW = Color.YELLOW;
    public static final Color DEFAULT_PEN_COLOR = BLACK;
    public static final Color DEFAULT_CLEAR_COLOR = WHITE;
    private static final int DEFAULT_SIZE = 480;
    private static final double DEFAULT_PEN_RADIUS = 0.002;
    private Color penColor;
    private int width = 480;
    private int height = 480;
    private double penRadius;
    private boolean defer = false;
    private static final double BORDER = 0.025;
    private static final double DEFAULT_XMIN = 0.0;
    private static final double DEFAULT_XMAX = 1.0;
    private static final double DEFAULT_YMIN = 0.0;
    private static final double DEFAULT_YMAX = 1.0;
    private double xmin;
    private double ymin;
    private double xmax;
    private double ymax;
    private double text_point_x;
    private double text_point_y;
    private static final Font DEFAULT_FONT = new Font("SansSerif", 0, 14);
    private Font font;
    private double line_height;
    private BufferedImage offscreenImage;
    private BufferedImage onscreenImage;
    private BufferedImage backgroundImage;
    private Graphics2D offscreen;
    private Graphics2D onscreen;
    private Graphics2D background;
    private Composite offscreenComposite;
    private int trails = 0;
    private AlphaComposite trailsAlphaComposite = null;
    JLabel draw;
    private boolean mousePressed = false;
    private double mouseX = 0.0;
    private double mouseY = 0.0;
    private char lastKeyTyped = (char)65535;
    private ArrayList actionListeners = new ArrayList();
    private double xscale;
    private double yscale;
    static /* synthetic */ Class class$util$StdDraw;

    public StdDraw(int n) {
        if (n != 0) {
            this.initCanvasSize(n);
        }
        this.init();
    }

    public void initCanvasSize(int n) {
        this.width = n;
        this.height = n;
    }

    public void setCanvasSize(int n, int n2) {
        boolean bl = false;
        if (n < 1 || n2 < 1) {
            throw new RuntimeException("width and height must be positive");
        }
        if (this.width != n) {
            this.width = n;
            bl = true;
        }
        if (this.height != n2) {
            this.height = n2;
            bl = true;
        }
        if (bl) {
            this.init();
        }
    }

    private void init() {
        this.backgroundImage = new BufferedImage(this.width, this.height, 2);
        this.offscreenImage = new BufferedImage(this.width, this.height, 2);
        this.onscreenImage = new BufferedImage(this.width, this.height, 2);
        this.background = this.backgroundImage.createGraphics();
        this.offscreen = this.offscreenImage.createGraphics();
        this.offscreenComposite = this.offscreen.getComposite();
        this.onscreen = this.onscreenImage.createGraphics();
        this.setXscale();
        this.setYscale();
        this.offscreen.setColor(DEFAULT_CLEAR_COLOR);
        this.offscreen.fillRect(0, 0, this.width, this.height);
        this.setPenColor();
        this.setPenRadius();
        this.setFont();
        this.clear();
        RenderingHints renderingHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
        this.offscreen.addRenderingHints(renderingHints);
        this.background.addRenderingHints(renderingHints);
        ImageIcon imageIcon = new ImageIcon(this.onscreenImage);
        this.draw = new JLabel(imageIcon);
        this.draw.addMouseListener(this);
        this.draw.addMouseMotionListener(this);
        this.postDisplayInit();
    }

    public void postDisplayInit() {
        this.setupFont(this.font, this.offscreen);
        this.setupFont(this.font, this.background);
    }

    public Container getDrawingPane() {
        return this.draw;
    }

    public void setTrails(int n) {
        System.out.println("STDDRAW: set trails (" + n + ")");
        this.trails = n;
        if (n == 0) {
            this.trailsAlphaComposite = null;
        } else {
            float f = 1.0f - 1.0f / (float)n;
            System.out.println("STDDRAW:  trails alpha: " + f);
            this.trailsAlphaComposite = AlphaComposite.getInstance(10, f);
        }
    }

    public static void fullscreen(Window window, boolean bl) {
        GraphicsDevice graphicsDevice = GraphicsEnvironment.getLocalGraphicsEnvironment().getDefaultScreenDevice();
        if (graphicsDevice.isFullScreenSupported()) {
            if (bl) {
                graphicsDevice.setFullScreenWindow(window);
                window.repaint();
            } else {
                graphicsDevice.setFullScreenWindow(null);
                window.repaint();
            }
        } else {
            System.err.println("Full screen not supported");
        }
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.draw.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.draw.addMouseMotionListener(mouseMotionListener);
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.add(actionListener);
    }

    public void setXscale() {
        this.setXscale(0.0, 1.0);
    }

    public void setYscale() {
        this.setYscale(0.0, 1.0);
    }

    public void setXscale(double d, double d2) {
        double d3 = d2 - d;
        this.xmin = d - 0.025 * d3;
        this.xmax = d2 + 0.025 * d3;
        this.xscale = (double)this.width / (this.xmax - this.xmin);
    }

    public void setYscale(double d, double d2) {
        double d3 = d2 - d;
        this.ymin = d - 0.025 * d3;
        this.ymax = d2 + 0.025 * d3;
        this.yscale = (double)this.height / (this.ymax - this.ymin);
    }

    public double scaleX(double d) {
        return (d - this.xmin) * this.xscale;
    }

    public double scaleY(double d) {
        return (this.ymax - d) * this.yscale;
    }

    public double factorX(double d) {
        return d * this.xscale;
    }

    public double factorY(double d) {
        return d * this.yscale;
    }

    public double userX(double d) {
        return this.xmin + d * (this.xmax - this.xmin) / (double)this.width;
    }

    public double userY(double d) {
        return this.ymax - d * (this.ymax - this.ymin) / (double)this.height;
    }

    public double unfactorX(double d) {
        return d * (this.xmax - this.xmin) / (double)this.width;
    }

    public double unfactorY(double d) {
        return d * (this.ymax - this.ymin) / (double)this.height;
    }

    public void clear() {
        this.clear(DEFAULT_CLEAR_COLOR);
    }

    public void clear(Color color) {
        this.offscreen.setColor(color);
        this.offscreen.fillRect(0, 0, this.width, this.height);
        this.offscreen.setColor(this.penColor);
        this.show();
    }

    public void initbg(Color color) {
        if (color != null) {
            this.offscreen.setColor(color);
            this.offscreen.fillRect(0, 0, this.width, this.height);
            this.offscreen.setColor(this.penColor);
        }
        this.offscreen.drawImage((Image)this.backgroundImage, 0, 0, null);
    }

    public void clearbg(Color color) {
        if (this.trails > 0) {
            if (color != null) {
                this.offscreen.setColor(color);
                this.offscreen.fillRect(0, 0, this.width, this.height);
                this.offscreen.setColor(this.penColor);
                this.offscreen.setComposite(this.trailsAlphaComposite);
                this.offscreen.drawImage((Image)this.onscreenImage, 0, 0, null);
                this.offscreen.setComposite(this.offscreenComposite);
            }
        } else {
            this.offscreen.drawImage((Image)this.backgroundImage, 0, 0, null);
        }
        this.show();
    }

    public void setPenRadius() {
        this.setPenRadius(0.002);
    }

    public void setPenRadius(double d) {
        if (d < 0.0) {
            throw new RuntimeException("pen radius must be positive");
        }
        this.penRadius = d * 480.0;
        BasicStroke basicStroke = new BasicStroke((float)this.penRadius);
        this.offscreen.setStroke(basicStroke);
    }

    public void setPenRadius_bg(double d) {
        if (d < 0.0) {
            throw new RuntimeException("pen radius must be positive");
        }
        double d2 = d * 480.0;
        BasicStroke basicStroke = new BasicStroke((float)d2);
        this.background.setStroke(basicStroke);
    }

    public void setPenColor() {
        this.setPenColor(DEFAULT_PEN_COLOR);
    }

    public void setPenColor(Color color) {
        this.penColor = color;
        this.offscreen.setColor(this.penColor);
    }

    public void setPenColor_bg(Color color) {
        this.background.setColor(color);
    }

    public void setFont() {
        this.setFont(DEFAULT_FONT);
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void line(double d, double d2, double d3, double d4) {
        this.offscreen.draw(new Line2D.Double(this.scaleX(d), this.scaleY(d2), this.scaleX(d3), this.scaleY(d4)));
        this.show();
    }

    public void line_bg(double d, double d2, double d3, double d4) {
        this.background.draw(new Line2D.Double(this.scaleX(d), this.scaleY(d2), this.scaleX(d3), this.scaleY(d4)));
    }

    private void pixel(double d, double d2) {
        this.offscreen.fillRect((int)Math.round(this.scaleX(d)), (int)Math.round(this.scaleY(d2)), 1, 1);
    }

    private void pixel_bg(double d, double d2) {
        this.background.fillRect((int)Math.round(this.scaleX(d)), (int)Math.round(this.scaleY(d2)), 1, 1);
    }

    public void point(double d, double d2) {
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        double d5 = this.penRadius;
        if (d5 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Ellipse2D.Double(d3 - d5 / 2.0, d4 - d5 / 2.0, d5, d5));
        }
        System.out.println("POINT: x: " + d + " xs: " + d3 + "y: " + d2 + " ys: " + d4 + "r: " + d5 + " xs-r/2: " + (d3 - d5 / 2.0));
        this.show();
    }

    public void point_bg(double d, double d2) {
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        double d5 = this.penRadius;
        if (d5 <= 1.0) {
            this.pixel_bg(d, d2);
        } else {
            this.background.fill(new Ellipse2D.Double(d3 - d5 / 2.0, d4 - d5 / 2.0, d5, d5));
        }
    }

    public void circle_bg(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel_bg(d, d2);
        } else {
            this.background.draw(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
    }

    public void circle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.show();
    }

    public void filledCircle(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        if (d6 <= 1.0) {
            if (this.trails > 0) {
                this.pixel(d, d2);
            } else {
                this.pixel_bg(d, d2);
            }
        } else {
            this.offscreen.fill(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d6 / 2.0, d6, d6));
        }
        this.show();
    }

    public void filledCircle_bg(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("circle radius can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.background.fill(new Ellipse2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
    }

    public void arc(double d, double d2, double d3, double d4, double d5) {
        if (d3 < 0.0) {
            throw new RuntimeException("arc radius can't be negative");
        }
        while (d5 < d4) {
            d5 += 360.0;
        }
        double d6 = this.scaleX(d);
        double d7 = this.scaleY(d2);
        double d8 = this.factorX(2.0 * d3);
        double d9 = this.factorY(2.0 * d3);
        if (d8 <= 1.0 && d9 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Arc2D.Double(d6 - d8 / 2.0, d7 - d9 / 2.0, d8, d9, d4, d5 - d4, 0));
        }
        this.show();
    }

    public void square(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.draw(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.show();
    }

    public void square_bg(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.background.draw(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
    }

    public void filledSquare(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.fill(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
        this.show();
    }

    public void filledSquare_bg(double d, double d2, double d3) {
        if (d3 < 0.0) {
            throw new RuntimeException("square side length can't be negative");
        }
        double d4 = this.scaleX(d);
        double d5 = this.scaleY(d2);
        double d6 = this.factorX(2.0 * d3);
        double d7 = this.factorY(2.0 * d3);
        if (d6 <= 1.0 && d7 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.background.fill(new Rectangle2D.Double(d4 - d6 / 2.0, d5 - d7 / 2.0, d6, d7));
        }
    }

    public void polygon(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.scaleX(dArray[0]), (float)this.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)this.scaleX(dArray[i]), (float)this.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        this.offscreen.draw(generalPath);
        this.show();
    }

    public void polygon_bg(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.scaleX(dArray[0]), (float)this.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)this.scaleX(dArray[i]), (float)this.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        this.background.draw(generalPath);
    }

    public void filledPolygon(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.scaleX(dArray[0]), (float)this.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)this.scaleX(dArray[i]), (float)this.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        this.offscreen.fill(generalPath);
        this.show();
    }

    public void filledPolygon_bg(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        GeneralPath generalPath = new GeneralPath();
        generalPath.moveTo((float)this.scaleX(dArray[0]), (float)this.scaleY(dArray2[0]));
        for (int i = 0; i < n; ++i) {
            generalPath.lineTo((float)this.scaleX(dArray[i]), (float)this.scaleY(dArray2[i]));
        }
        generalPath.closePath();
        this.background.fill(generalPath);
    }

    private Image getImage(String string) {
        URL uRL;
        ImageIcon imageIcon = new ImageIcon(string);
        if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
            try {
                uRL = new URL(string);
                imageIcon = new ImageIcon(uRL);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (imageIcon == null || imageIcon.getImageLoadStatus() != 8) {
            uRL = (class$util$StdDraw == null ? (class$util$StdDraw = StdDraw.class$("util.StdDraw")) : class$util$StdDraw).getResource(string);
            if (uRL == null) {
                throw new RuntimeException("image " + string + " not found");
            }
            imageIcon = new ImageIcon(uRL);
        }
        return imageIcon.getImage();
    }

    public void picture(double d, double d2, String string) {
        Image image = this.getImage(string);
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        if (n < 0 || n2 < 0) {
            throw new RuntimeException("image " + string + " is corrupt");
        }
        this.offscreen.drawImage(image, (int)Math.round(d3 - (double)n / 2.0), (int)Math.round(d4 - (double)n2 / 2.0), null);
        this.show();
    }

    public void picture(double d, double d2, String string, double d3, double d4) {
        Image image = this.getImage(string);
        double d5 = this.scaleX(d);
        double d6 = this.scaleY(d2);
        double d7 = this.factorX(d3);
        double d8 = this.factorY(d4);
        if (d7 <= 1.0 && d8 <= 1.0) {
            this.pixel(d, d2);
        } else {
            this.offscreen.drawImage(image, (int)Math.round(d5 - d7 / 2.0), (int)Math.round(d6 - d8 / 2.0), (int)Math.round(d7), (int)Math.round(d8), null);
        }
        this.show();
    }

    public void text_line(String string) {
        this.text(this.text_point_x, this.text_point_y, string);
    }

    public void setupFont(Font font, Graphics2D graphics2D) {
        graphics2D.setFont(font);
        FontMetrics fontMetrics = graphics2D.getFontMetrics();
        this.line_height = this.unfactorY(fontMetrics.getHeight());
    }

    public double getLineHeight() {
        return this.line_height;
    }

    public void next_line() {
        this.text_point_y -= this.line_height;
    }

    public void set_text_point(double d, double d2) {
        this.text_point_x = d;
        this.text_point_y = d2;
    }

    public void text(double d, double d2, String string) {
        FontMetrics fontMetrics = this.offscreen.getFontMetrics();
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = fontMetrics.getDescent();
        this.offscreen.drawString(string, (float)d3, (float)(d4 + (double)n));
        this.show();
    }

    public void text_center(double d, double d2, String string) {
        FontMetrics fontMetrics = this.offscreen.getFontMetrics();
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        this.offscreen.drawString(string, (float)(d3 - (double)n / 2.0), (float)(d4 + (double)n2));
        this.show();
    }

    public void text_bg_center(double d, double d2, String string) {
        System.out.println("Drawing text BG [" + string + "]");
        FontMetrics fontMetrics = this.offscreen.getFontMetrics();
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = fontMetrics.stringWidth(string);
        int n2 = fontMetrics.getDescent();
        this.background.drawString(string, (float)(d3 - (double)n / 2.0), (float)(d4 + (double)n2));
        this.show();
    }

    public void text_bg(double d, double d2, String string) {
        System.out.println("Drawing text BG [" + string + "]");
        FontMetrics fontMetrics = this.offscreen.getFontMetrics();
        double d3 = this.scaleX(d);
        double d4 = this.scaleY(d2);
        int n = fontMetrics.getDescent();
        this.background.drawString(string, (float)d3, (float)(d4 + (double)n));
        this.show();
    }

    public void show(int n) {
        this.defer = true;
        this.onscreen.drawImage((Image)this.offscreenImage, 0, 0, null);
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error sleeping");
        }
    }

    public void show(boolean bl) {
        this.defer = bl;
        this.onscreen.drawImage((Image)this.offscreenImage, 0, 0, null);
    }

    public void show() {
        if (!this.defer) {
            this.onscreen.drawImage((Image)this.offscreenImage, 0, 0, null);
        }
    }

    public void save(String string) {
        File file = new File(string);
        String string2 = string.substring(string.lastIndexOf(46) + 1);
        if (string2.toLowerCase().equals("png")) {
            try {
                ImageIO.write((RenderedImage)this.offscreenImage, string2, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else if (string2.toLowerCase().equals("jpg")) {
            WritableRaster writableRaster = this.offscreenImage.getRaster();
            WritableRaster writableRaster2 = writableRaster.createWritableChild(0, 0, this.width, this.height, 0, 0, new int[]{0, 1, 2});
            DirectColorModel directColorModel = (DirectColorModel)this.offscreenImage.getColorModel();
            DirectColorModel directColorModel2 = new DirectColorModel(directColorModel.getPixelSize(), directColorModel.getRedMask(), directColorModel.getGreenMask(), directColorModel.getBlueMask());
            BufferedImage bufferedImage = new BufferedImage(directColorModel2, writableRaster2, false, null);
            try {
                ImageIO.write((RenderedImage)bufferedImage, string2, file);
            }
            catch (IOException iOException) {
                iOException.printStackTrace();
            }
        } else {
            System.out.println("Invalid image file type: " + string2);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        Iterator iterator = this.actionListeners.iterator();
        while (iterator.hasNext()) {
            ActionListener actionListener = (ActionListener)iterator.next();
            actionListener.actionPerformed(actionEvent);
        }
    }

    public boolean mousePressed() {
        return this.mousePressed;
    }

    public double mouseX() {
        return this.mouseX;
    }

    public double mouseY() {
        return this.mouseY;
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.mouseX = this.userX(mouseEvent.getX());
        this.mouseY = this.userY(mouseEvent.getY());
        this.mousePressed = true;
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.mousePressed = false;
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        this.mouseX = this.userX(mouseEvent.getX());
        this.mouseY = this.userY(mouseEvent.getY());
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this.mouseX = this.userX(mouseEvent.getX());
        this.mouseY = this.userY(mouseEvent.getY());
    }

    public boolean hasNextKeyTyped() {
        return this.lastKeyTyped != '\uffff';
    }

    public char nextKeyTyped() {
        char c = this.lastKeyTyped;
        this.lastKeyTyped = (char)65535;
        return c;
    }

    public void keyTyped(KeyEvent keyEvent) {
        this.lastKeyTyped = keyEvent.getKeyChar();
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
    }

    public static void main(String[] stringArray) {
        StdDraw stdDraw = new StdDraw(0);
        stdDraw.square(0.2, 0.8, 0.1);
        stdDraw.filledSquare(0.8, 0.8, 0.2);
        stdDraw.circle(0.8, 0.2, 0.2);
        stdDraw.setPenColor(MAGENTA);
        stdDraw.setPenRadius(0.02);
        stdDraw.arc(0.8, 0.2, 0.1, 200.0, 45.0);
        stdDraw.setPenRadius();
        stdDraw.setPenColor(BLUE);
        double[] dArray = new double[]{0.1, 0.2, 0.3, 0.2};
        double[] dArray2 = new double[]{0.2, 0.3, 0.2, 0.1};
        stdDraw.filledPolygon(dArray, dArray2);
        stdDraw.text(0.8, 0.2, "centered");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }
}

