/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.Iterator;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.SwingUtilities;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kepler.Body;
import kepler.ControlPanel;
import kepler.Kepler;
import kepler.Note;
import kepler.NoteListener;
import kepler.Orrery;
import kepler.Playable;
import kepler.Rock;
import kepler.Vect;

public class WorldBuilder
extends ControlPanel
implements NoteListener {
    private static final int NONE = -1;
    private static final int BODY = 0;
    private static final int ROCK = 1;
    public String targetDirectory = "../../worlds/saved";
    private JPanel wbPanel;
    private JLabel massText_kiosk;
    private JTextField massText;
    private JSlider massSlider;
    private JTextField offsetXText;
    private JTextField offsetYText;
    private JTextField posCoord1Text;
    private JTextField posCoord2Text;
    private JLabel posCoord1Label;
    private JLabel posCoord2Label;
    private JLabel posCoord1TextLabel;
    private JLabel posCoord2TextLabel;
    private JTextField vCoord1Text;
    private JTextField vCoord2Text;
    private JLabel vCoord1Label;
    private JLabel vCoord2Label;
    private JToggleButton posCoordTypeToggle;
    private JToggleButton vCoordTypeToggle;
    private JComboBox playableTypeChooser;
    private JComboBox playableChooser;
    private boolean playableChooserUpdating = false;
    private JTextField noteChooser;
    private JComboBox instrumentChooser;
    private JTextArea playablePreviewText;
    private JComboBox mutatorTypeChooser;
    private JTextField mutatorChanceText;
    private JTextField mutatorAfterText;
    private JTextField mutatorLowText;
    private JTextField mutatorHighText;
    private JButton currentPreviewButton;
    private JButton currentStopButton;
    private JButton editedPreviewButton;
    private JButton editedStopButton;
    private JFileChooser fileChooser;
    private File fileChooserCurrentDirectory = null;
    private JComboBox melodySelector;
    private Body selected = null;
    private int selectedIndex = -1;
    private int selectedType = -1;
    private Color backgroundColor = Color.BLACK;
    private boolean showingPhysicsMode = true;
    double mass_slider_kiosk_low = 1.0E14;
    double mass_slider_kiosk_high = 1.0E16;
    JComboBox peSelectorName = null;
    JComboBox peSelectorType = null;
    JTextField peEditorName = null;
    JTextArea peEditorBody = null;
    JComboBox pePreviewInstrument = null;
    private JTextField[] channelNames;
    private JTextField[] channelBanks;
    private JTextField[] channelPrograms;
    long mousePressedTime = 0L;
    long dragWaitDelay = 200L;
    int ndrags = 0;
    protected PreviewThread previewThread = null;

    public WorldBuilder(Kepler kepler, Color color) {
        super(kepler);
        this.backgroundColor = color;
        this.wbPanel = this.makePanel(kepler);
        this.setPanel(this.wbPanel);
        if (!kepler.kioskMode()) {
            this.fileChooser = new JFileChooser();
        }
    }

    public boolean showingPhysicsMode() {
        return this.showingPhysicsMode;
    }

    public void setShowingPhysicsMode(boolean bl) {
        this.showingPhysicsMode = bl;
    }

    public Body getSelected() {
        return this.selected;
    }

    public void selectBody(Body body, int n) {
        if (this.selected != null && this.selected != body) {
            this.selected.unselect();
            this.orrery.selectBody(null);
        }
        boolean bl = this.selected != body;
        this.selected = body;
        this.orrery.selectBody(this.selected);
        this.selected.select(-1);
        this.selectedIndex = n;
        this.selectedType = 0;
        this.updateSelected(body, bl);
    }

    public void selectRock(Rock rock, int n) {
        if (this.selected != null) {
            this.selected.unselect();
            this.orrery.selectBody(null);
        }
        boolean bl = this.selected != rock;
        this.selected = rock;
        this.orrery.selectBody(this.selected);
        this.selected.select(-1);
        this.selectedType = 1;
        this.selectedIndex = n;
        this.updateSelected(rock, bl);
    }

    public void selectPrevBodyOrRock() {
        if (this.orrery.isInitialConditionsMode()) {
            int n = this.orrery.getInitialBodyCount();
            int n2 = this.orrery.getInitialRockCount();
            this.selectPrevBodyOrRock(this.orrery.getInitialBodies(), this.orrery.getInitialRocks(), n, n2);
            this.orrery.worldBuilderDraw();
        } else {
            int n = this.orrery.getBodyCount();
            int n3 = this.orrery.getRockCount();
            this.selectPrevBodyOrRock(this.orrery.getBodies(), this.orrery.getRocks(), n, n3);
            this.orrery.redraw();
        }
    }

    public void selectPrevBodyOrRock(Body[] bodyArray, Rock[] rockArray, int n, int n2) {
        boolean bl = this.selected != null && this.selected instanceof Rock;
        --this.selectedIndex;
        if (bl && this.selectedIndex < 0) {
            if (n > 0) {
                bl = false;
                this.selectedIndex = n - 1;
            } else {
                this.selectedIndex = n2 - 1;
            }
        } else if (!bl && this.selectedIndex < 0) {
            if (n2 > 0) {
                bl = true;
                this.selectedIndex = n2 - 1;
            } else {
                this.selectedIndex = n - 1;
            }
        }
        if (bl) {
            this.selectRock(rockArray[this.selectedIndex], this.selectedIndex);
        } else {
            this.selectBody(bodyArray[this.selectedIndex], this.selectedIndex);
        }
    }

    public void selectNextBodyOrRock() {
        if (this.orrery.isInitialConditionsMode()) {
            int n = this.orrery.getInitialBodyCount();
            int n2 = this.orrery.getInitialRockCount();
            this.selectNextBodyOrRock(this.orrery.getInitialBodies(), this.orrery.getInitialRocks(), n, n2);
            this.orrery.worldBuilderDraw();
        } else {
            int n = this.orrery.getBodyCount();
            int n3 = this.orrery.getRockCount();
            this.selectNextBodyOrRock(this.orrery.getBodies(), this.orrery.getRocks(), n, n3);
            this.orrery.redraw();
        }
    }

    public void selectNextBodyOrRock(Body[] bodyArray, Rock[] rockArray, int n, int n2) {
        boolean bl = this.selected != null && this.selected instanceof Rock;
        ++this.selectedIndex;
        if (bl && this.selectedIndex >= n2) {
            if (n > 0) {
                bl = false;
            }
            this.selectedIndex = 0;
        } else if (!bl && this.selectedIndex >= n) {
            if (n2 > 0) {
                bl = true;
            }
            this.selectedIndex = 0;
        }
        if (bl) {
            this.selectRock(rockArray[this.selectedIndex], this.selectedIndex);
        } else {
            this.selectBody(bodyArray[this.selectedIndex], this.selectedIndex);
        }
    }

    public void unselect() {
        if (this.selected != null) {
            this.selected.unselect();
        }
        this.selected = null;
        this.orrery.selectBody(null);
        this.selectedIndex = -1;
        this.selectedType = -1;
        this.updateSelected(null, true);
    }

    public JPanel makePanel(Kepler kepler) {
        if (kepler.kioskMode()) {
            return this.makePanel_kiosk(kepler);
        }
        return this.makePanel_std(kepler);
    }

    public JPanel makePanel_kiosk(Kepler kepler) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setBorder(new MatteBorder(0, 2, 2, 2, this.orrery.controlPanelBorder));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 7;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.makeImageLabel("vspacer400.gif", ""), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = this.makeImageLabel("spacer256.gif", "");
        jLabel.setBorder(new MatteBorder(1, 1, 1, 1, Color.RED));
        jLabel.setBackground(this.backgroundColor);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeBodyEditorPanel_kiosk(), gridBagConstraints);
        return jPanel;
    }

    public JPanel makePanel_std(Kepler kepler) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setSize(new Dimension(281, 293));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.makeImageLabel("KeplersWorldBuilder.gif", ""), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)WorldBuilder.makeModeTogglePanel(this, this.orrery), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeSqueegee("Melodies", this.makePlayableEditorPanel(), false), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 0, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeSqueegee("Instruments", this.makeInstrumentsEditorPanel(), false), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.insets = new Insets(4, 0, 4, 0);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeSqueegee("SelectedBody", this.makeBodyEditorPanel_std(), true), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.makeBottomControls_std(this.backgroundColor), gridBagConstraints);
        return jPanel;
    }

    public JPanel getMusicPanel_kiosk(Kepler kepler) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setBorder(new MatteBorder(0, 2, 2, 2, this.orrery.controlPanelBorder));
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 4;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel = this.makeImageLabel("vspacer400.gif", "");
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        JLabel jLabel2 = this.makeImageLabel("spacer256.gif", "");
        jPanel.add((Component)jLabel2, gridBagConstraints);
        int n = 0;
        int n2 = 0;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = n2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.makeMusicPanelContents_kiosk(), gridBagConstraints);
        gridBagConstraints.gridx = n;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 3;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.weightx = 0.0;
        JLabel jLabel3 = this.makeTextLabel("");
        jPanel.add((Component)jLabel3, gridBagConstraints);
        gridBagConstraints.gridx = n;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 15;
        JPanel jPanel2 = this.makeBottomControls_kiosk(this.backgroundColor);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    private JPanel makeMusicPanelContents_kiosk() {
        return this.makePlayableSelectionPanel(this.backgroundColor);
    }

    private JPanel makeMusicPanelContents_kiosk_old() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JPanel jPanel2 = this.makePlayableSelectionPanel(this.backgroundColor);
        jPanel.add((Component)jPanel2, gridBagConstraints);
        return jPanel;
    }

    public JPanel getBottomControls(Color color) {
        if (this.kepler.kioskMode()) {
            return this.makeBottomControls_kiosk(color);
        }
        return this.makeBottomControls_std(color);
    }

    private JPanel makeBottomControls_std(Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new MatteBorder(1, 0, 0, 0, this.orrery.controlPanelBorder));
        jPanel.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        gridBagConstraints.fill = 2;
        JButton jButton = this.makeImageButton("ApplyButton_up.gif", "ApplyButton_down.gif", "Apply");
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.applyWorldBuilderEdits();
            }
        });
        JButton jButton2 = this.makeImageButton("ApplySelectNextButton_up.gif", "ApplySelectNextButton_down.gif", "Apply, then select next");
        jPanel.add((Component)jButton2, gridBagConstraints);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.applyWorldBuilderEdits();
                WorldBuilder.this.selectNextBodyOrRock();
            }
        });
        JButton jButton3 = this.makeImageButton("NewBody_up.gif", "NewBody_down.gif", "Add Body");
        jPanel.add((Component)jButton3, gridBagConstraints);
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.addBody();
            }
        });
        JButton jButton4 = this.makeImageButton("NewRock_up.gif", "NewRock_down.gif", "Add Rock");
        jPanel.add((Component)jButton4, gridBagConstraints);
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.addRock();
            }
        });
        JButton jButton5 = this.makeImageButton("DeleteButton_up.gif", "DeleteButton_down.gif", "Delete Selected");
        jPanel.add((Component)jButton5, gridBagConstraints);
        jButton5.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WorldBuilder.this.selected != null) {
                    WorldBuilder.this.deleteSelected(WorldBuilder.this.selected);
                }
            }
        });
        JButton jButton6 = this.makeImageButton("SaveButton_up.gif", "SaveButton_down.gif", "Save the World");
        jPanel.add((Component)jButton6, gridBagConstraints);
        jButton6.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                File file;
                String string = WorldBuilder.this.orrery.getWorldFile();
                File file2 = new File(string);
                String string2 = file2.getName();
                if (WorldBuilder.this.fileChooserCurrentDirectory == null) {
                    file = new File(WorldBuilder.this.targetDirectory);
                    WorldBuilder.this.fileChooserCurrentDirectory = file;
                }
                file = new File(WorldBuilder.this.fileChooserCurrentDirectory, string2);
                WorldBuilder.this.fileChooser.setCurrentDirectory(WorldBuilder.this.fileChooserCurrentDirectory);
                WorldBuilder.this.fileChooser.setSelectedFile(file);
                int n = WorldBuilder.this.fileChooser.showSaveDialog(WorldBuilder.this.wbPanel);
                if (n == 0) {
                    String string3;
                    File file3 = WorldBuilder.this.fileChooser.getSelectedFile();
                    WorldBuilder.this.fileChooserCurrentDirectory = WorldBuilder.this.fileChooser.getCurrentDirectory();
                    try {
                        string3 = file3.getCanonicalPath();
                    }
                    catch (IOException iOException) {
                        string3 = file3.getAbsolutePath();
                    }
                    boolean bl = true;
                    if (file3.exists()) {
                        Object[] objectArray = new Object[]{"Overwrite", "Cancel"};
                        String string4 = "Overwrite world file?";
                        String string5 = "World file " + string3 + " already exists. \nDo you want to overwrite it?";
                        ImageIcon imageIcon = Kepler.createImageIcon("Question32.gif", "");
                        int n2 = JOptionPane.showOptionDialog(WorldBuilder.this.wbPanel, string5, string4, 0, 3, imageIcon, objectArray, objectArray[1]);
                        boolean bl2 = bl = n2 == 0;
                    }
                    if (bl) {
                        WorldBuilder.this.orrery.writeWorld(file3.getAbsolutePath());
                    }
                } else {
                    System.out.println("Save command cancelled by user.");
                }
            }
        });
        return jPanel;
    }

    private JPanel makeBottomControls_kiosk(Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.insets = new Insets(8, 8, 0, 8);
        JButton jButton = this.makeImageButton("SelectPrevButton_up.gif", "SelectPrevButton_down.gif", "Select Prev");
        jPanel.add((Component)jButton, gridBagConstraints);
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.orrery.resetPlayTimer();
                WorldBuilder.this.selectPrevBodyOrRock();
            }
        });
        JButton jButton2 = this.makeImageButton("SelectNextButton_up.gif", "SelectNextButton_down.gif", "Select Next");
        jPanel.add((Component)jButton2, gridBagConstraints);
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.orrery.resetPlayTimer();
                WorldBuilder.this.selectNextBodyOrRock();
            }
        });
        return jPanel;
    }

    public static JPanel makeModeTogglePanel(ControlPanel controlPanel, final Orrery orrery) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        final JToggleButton jToggleButton = controlPanel.makeImageToggleButton("PlayButton_up.gif", "PlayButton_down.gif", "Play mode");
        jToggleButton.setSelected(true);
        final JToggleButton jToggleButton2 = controlPanel.makeImageToggleButton("BuildButton_up.gif", "BuildButton_down.gif", "World Builder mode");
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("PLAYER toggle plressed.");
                jToggleButton2.setSelected(false);
                orrery.playingMode();
                System.out.println("Entering playing mode [B4 copyinitialbodies]. maxMass: " + orrery.maxMass + " Body.maxMass: " + Body.maxMass + " minMass: " + orrery.minMass + " Body.minMass: " + Body.minMass);
                orrery.copyInitialBodies();
                System.out.println("Entering playing mode [after copyinitialbodies]. maxMass: " + orrery.maxMass + " Body.maxMass: " + Body.maxMass + " minMass: " + orrery.minMass + " Body.minMass: " + Body.minMass);
                orrery.resume();
            }
        });
        jPanel.add((Component)jToggleButton, gridBagConstraints);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 1;
        jToggleButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("WORLD BUILDER toggle pressed.");
                jToggleButton.setSelected(false);
                orrery.initialConditionsMode();
                WorldBuilder worldBuilder = orrery.getWorldBuilder();
                if (worldBuilder.selected == null) {
                    worldBuilder.selectNextBodyOrRock();
                }
            }
        });
        jPanel.add((Component)jToggleButton2, gridBagConstraints);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(jToggleButton);
        buttonGroup.add(jToggleButton2);
        return jPanel;
    }

    public void setInitialConditionsMode(boolean bl) {
        if (bl) {
            this.orrery.initialConditionsMode();
            this.kepler.setMode("initialconditions", bl);
            this.unselect();
            this.selectNextBodyOrRock();
        } else {
            this.kepler.setMode("initialconditions", bl);
            this.orrery.resetPlayTimer();
            System.out.println("Entering playing mode [B4 copyinitialbodies]. maxMass: " + this.orrery.maxMass + " Body.maxMass: " + Body.maxMass + " minMass: " + this.orrery.minMass + " Body.minMass: " + Body.minMass);
            this.orrery.redrawBackground();
            this.orrery.drawer.show(false);
            this.orrery.copyInitialBodies();
            System.out.println("Entering playing mode [after copyinitialbodies]. maxMass: " + this.orrery.maxMass + " Body.maxMass: " + Body.maxMass + " minMass: " + this.orrery.minMass + " Body.minMass: " + Body.minMass);
            this.unselect();
            System.out.println("resuming.");
            this.orrery.drawer.show(true);
            this.orrery.repaint();
            this.orrery.resume();
            this.orrery.playingMode();
            System.out.println("resumED.");
        }
    }

    public void addBody() {
        this.addBody(0.0, 0.0);
    }

    private void addBody(double d, double d2) {
        Body[] bodyArray;
        Rock[] rockArray;
        Vect vect = new Vect(d, d2);
        Vect vect2 = new Vect(0.0, 0.0);
        double d3 = this.orrery.findAverageMass(this.orrery.getInitialBodies());
        if (d3 == 0.0) {
            d3 = Math.max(this.orrery.minMass, 1.9E14);
        }
        Body body = new Body(vect, vect2, d3, this.orrery.maxBodies);
        if (this.orrery.isInitialConditionsMode()) {
            rockArray = this.orrery.getInitialRocks();
            bodyArray = this.orrery.getInitialBodies();
        } else {
            rockArray = this.orrery.getRocks();
            bodyArray = this.orrery.getBodies();
        }
        this.ensureBodyDoesntIntersectExisting(body, rockArray, bodyArray);
        this.addBody(body);
    }

    public void addRock() {
        this.addRock(0.0, 0.0);
    }

    private void addRock(double d, double d2) {
        Body[] bodyArray;
        Rock[] rockArray;
        System.out.println("Add Rock(" + d + ", " + d2 + ")");
        Vect vect = new Vect(d, d2);
        double d3 = this.orrery.findAverageMass(this.orrery.getInitialRocks());
        if (d3 == 0.0) {
            d3 = this.orrery.findAverageMass(this.orrery.getInitialBodies());
        }
        Rock rock = new Rock(vect, d3, this.orrery.maxRocks);
        if (this.orrery.isInitialConditionsMode()) {
            rockArray = this.orrery.getInitialRocks();
            bodyArray = this.orrery.getInitialBodies();
        } else {
            rockArray = this.orrery.getRocks();
            bodyArray = this.orrery.getBodies();
        }
        this.ensureBodyDoesntIntersectExisting(rock, rockArray, bodyArray);
        this.addRock(rock);
    }

    private void addBody(Body body) {
        if (this.orrery.isInitialConditionsMode()) {
            this.orrery.addInitialBody(body);
            this.orrery.worldBuilderDraw();
        } else {
            this.orrery.addBody(body);
            this.orrery.redraw();
        }
    }

    private void addRock(Rock rock) {
        if (this.orrery.isInitialConditionsMode()) {
            this.orrery.addInitialRock(rock);
            this.orrery.worldBuilderDraw();
        } else {
            this.orrery.addRock(rock);
            this.orrery.redraw();
        }
    }

    private void ensureBodyDoesntIntersectExisting(Body body, Rock[] rockArray, Body[] bodyArray) {
        double d = this.orrery.radius / 13.0;
        double d2 = 32.72727272727273;
        boolean bl = this.bodyIntersectsExisting(body, rockArray, bodyArray);
        while (bl) {
            Vect vect = body.pos;
            double d3 = vect.r() + d;
            if (d3 > this.orrery.radius) {
                d3 = 2.0 * Math.random() * d;
            }
            vect.setR(d3);
            double d4 = vect.thetaDegrees() + d2;
            if (d4 > 360.0) {
                d4 = -360.0;
            }
            vect.setThetaDegrees(d4);
            bl = this.bodyIntersectsExisting(body, rockArray, bodyArray);
        }
    }

    private boolean bodyIntersectsExisting(Body body, Rock[] rockArray, Body[] bodyArray) {
        int n;
        boolean bl = false;
        for (n = 0; n < rockArray.length; ++n) {
            if (rockArray[n] == null || !rockArray[n].alive || !this.collides(body, rockArray[n], 1.5)) continue;
            bl = true;
            return bl;
        }
        for (n = 0; n < bodyArray.length; ++n) {
            if (bodyArray[n] == null || !bodyArray[n].alive || !this.collides(body, bodyArray[n], 1.5)) continue;
            bl = true;
            return bl;
        }
        return bl;
    }

    private boolean collides(Body body, Body body2, double d) {
        Vect vect = body.pos.minus(body2.pos);
        double d2 = vect.magnitude();
        return d2 < body.radius * d || d2 < body2.radius * d;
    }

    private void addClone(Body body, double d, double d2) {
        if (body instanceof Rock) {
            Rock rock = (Rock)body;
            Rock rock2 = (Rock)rock.duplicate();
            rock2.pos = new Vect(d, d2);
            this.addRock(rock2);
        } else {
            System.out.println("WB: addClone(body: " + body + ") @ (" + d + ", " + d2 + ")");
            Body body2 = body.duplicate();
            body2.pos = new Vect(d, d2);
            this.addBody(body2);
        }
    }

    public void deleteSelected() {
        System.out.println("WB: deleteSelected. selected: " + this.selected);
        if (this.selected != null) {
            this.deleteSelected(this.selected);
        }
    }

    private void deleteSelected(Body body) {
        if (body instanceof Rock) {
            this.deleteRock((Rock)body);
        } else {
            this.deleteBody(body);
        }
        this.orrery.worldBuilderDraw();
    }

    private void deleteBody(Body body) {
        if (this.orrery.isInitialConditionsMode()) {
            this.orrery.deleteInitialBody(body);
        } else {
            this.orrery.deleteBody(body);
        }
    }

    private void deleteRock(Rock rock) {
        if (this.orrery.isInitialConditionsMode()) {
            this.orrery.deleteInitialRock(rock);
        } else {
            this.orrery.deleteRock(rock);
        }
    }

    public void updateSelected() {
        this.updateSelected(this.selected, true);
    }

    private void updateSelected(Body body, boolean bl) {
        if (body == null) {
            this.clearRockBodyEditor();
        } else {
            this.updateBody(body, bl);
        }
    }

    private void updateSelected(Rock rock, boolean bl) {
        if (rock == null) {
            this.clearRockBodyEditor();
        } else {
            this.updateRock(rock, bl);
        }
    }

    private void updateBody(Body body, boolean bl) {
        this.updateCommon(body, bl);
    }

    private void updateRock(Rock rock, boolean bl) {
        this.updateCommon(rock, bl);
    }

    private void updateCommon(Body body, boolean bl) {
        if (this.kepler.kioskMode()) {
            this.updateCommon_kiosk(body, bl);
        } else {
            this.updateCommon_std(body, bl);
        }
    }

    private void updateCommon_std(Body body, boolean bl) {
        double d;
        double d2;
        this.displayText(this.massText, body.mass);
        Vect vect = body.pos;
        if (body.posSpecifiedPolar) {
            this.posCoordTypeToggle.setSelected(true);
            d2 = vect.r();
            d = vect.thetaDegrees();
            this.posCoord1Label.setText("r");
            this.posCoord2Label.setText("theta");
            this.displayText(this.posCoord1Text, d2);
            this.displayText(this.posCoord2Text, d);
        } else {
            this.posCoordTypeToggle.setSelected(false);
            d2 = vect.x();
            d = vect.y();
            this.posCoord1Label.setText("X");
            this.posCoord2Label.setText("Y");
            this.displayText(this.posCoord1Text, d2);
            this.displayText(this.posCoord2Text, d);
        }
        if (body.posOffset != null) {
            this.displayText(this.offsetXText, body.posOffset.x());
            this.displayText(this.offsetYText, body.posOffset.y());
        } else {
            this.displayText(this.offsetXText, "");
            this.displayText(this.offsetYText, "");
        }
        if (!(body instanceof Rock)) {
            if (body.vSpecifiedPolar) {
                this.vCoordTypeToggle.setSelected(true);
                d2 = body.v.r();
                d = body.v.thetaDegrees();
                this.posCoord1Label.setText("r");
                this.posCoord2Label.setText("theta");
                this.displayText(this.vCoord1Text, d2);
                this.displayText(this.vCoord2Text, d);
            } else {
                this.vCoordTypeToggle.setSelected(false);
                d2 = body.v.x();
                d = body.v.y();
                this.posCoord1Label.setText("X");
                this.posCoord2Label.setText("Y");
                this.displayText(this.vCoord1Text, d2);
                this.displayText(this.vCoord2Text, d);
            }
        }
        this.updatePlayableChooser(body, bl);
        this.updateMutatorPanel(this.selected);
    }

    private void updateCommon_kiosk(Body body, boolean bl) {
        if (!this.showingPhysicsMode) {
            this.updatePlayableChooser(body, bl);
        }
    }

    private void updatePlayableChooser(Body body, boolean bl) {
        Object object;
        System.out.println("UPC: body=" + body + " @ " + body.pos + " body.playable: " + body.getPlayable());
        if (body.getPlayable() == null) {
            this.playableTypeChooser.setSelectedItem("");
            System.out.println("Calling ppulate plbl chooser on playableChooser (from update common) BODY HAS NULL PLAYABLE");
            this.populatePlayableChooser("", "");
        } else {
            object = body.getPlayable();
            String string = ((Playable)object).getType();
            this.populatePlayableChooser(string, ((Playable)object).getName());
            System.out.println(" calling selectplayable: ptype=" + string + " name: " + ((Playable)object).getName());
            this.selectPlayable(string, ((Playable)object).getName());
            this.showPlayableCurrentState((Playable)object);
        }
        object = (String)this.orrery.channelMap.get("" + body.channel);
        this.populateInstrumentChooser();
        if (object == null) {
            this.instrumentChooser.setSelectedItem("");
        } else {
            this.instrumentChooser.setSelectedItem(object);
        }
    }

    public void showPlayableCurrentState(final Playable playable) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (WorldBuilder.this.playablePreviewText != null && playable != null) {
                    StringBuffer stringBuffer = new StringBuffer();
                    playable.writeCurrentState(stringBuffer);
                    WorldBuilder.this.playablePreviewText.setText(stringBuffer.toString());
                }
            }
        };
        SwingUtilities.invokeLater(runnable);
    }

    private void populateInstrumentChooser() {
        this.instrumentChooser.removeAllItems();
        this.instrumentChooser.addItem("");
        int n = 16;
        for (int i = 0; i < n; ++i) {
            String string = this.orrery.getChannelName(i);
            this.instrumentChooser.addItem(string);
        }
    }

    private void clearRockBodyEditor() {
        if (this.kepler.kioskMode()) {
            this.clearRockBodyEditor_kiosk();
        } else {
            this.clearRockBodyEditor_std();
        }
    }

    private void clearRockBodyEditor_std() {
        this.massText.setText("");
        this.posCoord1Text.setText("");
        this.posCoord2Text.setText("");
        this.vCoord1Text.setText("");
        this.vCoord2Text.setText("");
        this.offsetXText.setText("");
        this.offsetYText.setText("");
        this.playableTypeChooser.setSelectedItem("");
        this.selectPlayable("", "");
        this.instrumentChooser.setSelectedItem("");
    }

    private void clearRockBodyEditor_kiosk() {
        this.massText_kiosk.setText("");
        this.posCoord1TextLabel.setText("");
        this.posCoord2TextLabel.setText("");
    }

    private JPanel makeBodyEditorPanel_std() {
        return this.makeBodyEditorPanel_std(0);
    }

    private JPanel makeBodyEditorPanel_std(int n) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeTextLabel("Mass"), gridBagConstraints);
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.insets = new Insets(0, 1, 2, 0);
        this.massText = this.makeNumberField();
        jPanel.add((Component)this.massText, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeLocationPanel(), gridBagConstraints);
        if (n == 0) {
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridwidth = 3;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.makeVelocityPanel(), gridBagConstraints);
        }
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makePlayableSelectionPanel(this.backgroundColor), gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeMutatorPanel(), gridBagConstraints);
        return jPanel;
    }

    private JPanel makeBodyEditorPanel_kiosk() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.addMass_kiosk(jPanel);
        this.addLocations_kiosk(jPanel);
        return jPanel;
    }

    JPanel addMass_kiosk(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(10, 1, 0, 0);
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)this.makeTextLabel("Mass"), gridBagConstraints);
        ++gridBagConstraints.gridy;
        this.massSlider = this.makeSliderV();
        this.massSlider.setBackground(this.backgroundColor);
        gridBagConstraints.anchor = 10;
        gridBagConstraints.gridheight = 2;
        jPanel.add((Component)this.massSlider, gridBagConstraints);
        gridBagConstraints.gridy += 2;
        gridBagConstraints.gridheight = 1;
        this.massText_kiosk = this.makeValueLabel("");
        jPanel.add((Component)this.massText_kiosk, gridBagConstraints);
        this.massSlider.addChangeListener(new ChangeListener(){

            public void stateChanged(ChangeEvent changeEvent) {
                WorldBuilder.this.orrery.resetPlayTimer();
                JSlider jSlider = (JSlider)changeEvent.getSource();
                int n = jSlider.getValue() + 1;
                double d = WorldBuilder.this.cookLinearValue(n, WorldBuilder.this.mass_slider_kiosk_low, WorldBuilder.this.mass_slider_kiosk_high);
                System.out.println("MassSlider. stateChanged() raw: " + n + " cooked: " + d);
                if (WorldBuilder.this.selected != null) {
                    String string = "" + d;
                    WorldBuilder.this.massText_kiosk.setText(string);
                    double d2 = d;
                    WorldBuilder.this.selected.setMass(d2);
                    WorldBuilder.this.orrery.worldBuilderDraw();
                }
            }
        });
        return jPanel;
    }

    JPanel addLocations_kiosk(JPanel jPanel) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.anchor = 14;
        gridBagConstraints.insets = new Insets(50, 0, 2, 5);
        this.posCoord1Label = this.makeTextLabel("X");
        jPanel.add((Component)this.posCoord1Label, gridBagConstraints);
        this.posCoord1TextLabel = this.makeValueLabel("");
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 16;
        gridBagConstraints.insets = new Insets(0, 0, 5, 0);
        jPanel.add((Component)this.posCoord1TextLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.anchor = 12;
        gridBagConstraints.insets = new Insets(0, 0, 0, 5);
        this.posCoord2Label = this.makeTextLabel("");
        jPanel.add((Component)this.posCoord2Label, gridBagConstraints);
        this.posCoord2TextLabel = this.makeValueLabel("");
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.posCoord2TextLabel, gridBagConstraints);
        return jPanel;
    }

    private JPanel makePlayableEditorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.peSelectorType = this.makeDropDown();
        this.peSelectorType.addItem("melody");
        this.peSelectorType.addItem("scale");
        this.peSelectorType.addItem("sequence");
        this.peSelectorType.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.orrery.resetPlayTimer();
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                System.out.println("Calling ppulate plbl chooser on peSelectorName");
                WorldBuilder.this.populatePlayableChooser(WorldBuilder.this.peSelectorType, WorldBuilder.this.peSelectorName, string, "__first__");
            }
        });
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.peSelectorType, gridBagConstraints);
        this.peSelectorName = this.makeDropDown();
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.peSelectorName, gridBagConstraints);
        this.peSelectorName.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.orrery.resetPlayTimer();
                JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                String string = (String)jComboBox.getSelectedItem();
                WorldBuilder.this.fillPlayableEditor((String)WorldBuilder.this.peSelectorType.getSelectedItem(), string);
            }
        });
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.makeTextLabel("name"), gridBagConstraints);
        this.peEditorName = this.makeTextField(15);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.peEditorName, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        this.peEditorBody = this.makeTextArea();
        jPanel.add((Component)this.peEditorBody, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 2;
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new MatteBorder(0, 0, 0, 0, this.orrery.controlPanelBorder));
        jPanel2.setBackground(this.orrery.controlPanelBG);
        jPanel2.setLayout(new GridBagLayout());
        jPanel.add((Component)jPanel2, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.insets = new Insets(6, 4, 4, 0);
        JButton jButton = this.makeImageButton("UpdateButton_small_up.gif", "UpdateButton_small_down.gif", "Update named melody/sequence/etc.");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)WorldBuilder.this.peSelectorType.getSelectedItem();
                String string2 = (String)WorldBuilder.this.peSelectorName.getSelectedItem();
                String string3 = WorldBuilder.this.peEditorName.getText();
                String string4 = WorldBuilder.this.peEditorBody.getText();
                WorldBuilder.this.updatePlayable(string, string2, string3, string4);
            }
        });
        jPanel2.add((Component)jButton, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        JButton jButton2 = this.makeImageButton("AddButton_small_up.gif", "AddButton_small_down.gif", "Add new melody/sequence/etc.");
        jButton2.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)WorldBuilder.this.peSelectorType.getSelectedItem();
                String string2 = WorldBuilder.this.peEditorName.getText();
                String string3 = WorldBuilder.this.peEditorBody.getText();
                WorldBuilder.this.addPlayable(string, string2, string3);
            }
        });
        jPanel2.add((Component)jButton2, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        JButton jButton3 = this.makeImageButton("DeleteButton_small_up.gif", "DeleteButton_small_down.gif", "Delete melody/sequence/etc.");
        jButton3.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)WorldBuilder.this.peSelectorType.getSelectedItem();
                String string2 = (String)WorldBuilder.this.peSelectorName.getSelectedItem();
                WorldBuilder.this.deletePlayable(string, string2);
            }
        });
        jPanel2.add((Component)jButton3, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        JButton jButton4 = this.makeImageButton("ResetButton_small_up.gif", "ResetButton_small_down.gif", "Reset melody editor.");
        jButton4.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)WorldBuilder.this.peSelectorType.getSelectedItem();
                String string2 = (String)WorldBuilder.this.peSelectorName.getSelectedItem();
                WorldBuilder.this.fillPlayableEditor(string, string2);
            }
        });
        jPanel2.add((Component)jButton4, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 1.0;
        jPanel2.add((Component)new JLabel(""), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(6, 12, 4, 0);
        this.editedPreviewButton = this.makeImageButton("PreviewButton_small_up.gif", "PreviewButton_small_down.gif", "Preview on this instrument");
        this.editedPreviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = (String)WorldBuilder.this.peSelectorType.getSelectedItem();
                String string2 = WorldBuilder.this.peEditorName.getText();
                String string3 = WorldBuilder.this.peEditorBody.getText();
                String string4 = (String)WorldBuilder.this.pePreviewInstrument.getSelectedItem();
                WorldBuilder.this.previewEditedPlayable(string, string2, string3, string4);
            }
        });
        jPanel2.add((Component)this.editedPreviewButton, gridBagConstraints2);
        this.editedStopButton = this.makeImageButton("StopButton_small_up.gif", "StopButton_small_down.gif", "Stop preview in progress");
        this.editedStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.stopPreviewThread();
            }
        });
        this.editedStopButton.setVisible(false);
        jPanel2.add((Component)this.editedStopButton, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(6, 0, 4, 0);
        jPanel2.add((Component)this.makeTextLabel(" on "), gridBagConstraints2);
        this.pePreviewInstrument = this.makeDropDown();
        ++gridBagConstraints2.gridx;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.weighty = 0.0;
        gridBagConstraints2.insets = new Insets(6, 0, 4, 8);
        jPanel2.add((Component)this.pePreviewInstrument, gridBagConstraints2);
        return jPanel;
    }

    private void updatePlayable(String string, String string2, String string3, String string4) {
        Playable playable;
        Body body;
        int n;
        Playable playable2 = this.findPlayable(string, string3);
        if (playable2 == null) {
            this.addPlayable(string, string3, string4);
            return;
        }
        Playable playable3 = this.orrery.parsePlayable(string, string3, string4);
        this.orrery.storePlayable(playable3);
        int n2 = this.orrery.getInitialBodyCount();
        int n3 = this.orrery.getInitialRockCount();
        Body[] bodyArray = this.orrery.getInitialBodies();
        Rock[] rockArray = this.orrery.getInitialRocks();
        for (n = 0; n < n2; ++n) {
            body = bodyArray[n];
            if (body == null || (playable = body.getPlayable()) == null || !playable.getType().equals(string) || !playable.getName().equals(string3)) continue;
            this.orrery.setPlayable(body, string, string3, playable.isShared());
        }
        for (n = 0; n < n3; ++n) {
            body = rockArray[n];
            if (body == null || (playable = body.getPlayable()) == null || !playable.getType().equals(string) || !playable.getName().equals(string3)) continue;
            this.orrery.setPlayable(body, string, string3, playable.isShared());
        }
    }

    private void addPlayable(String string, String string2, String string3) {
        Playable playable = this.findPlayable(string, string2);
        if (playable != null) {
            System.out.println("ERROR: " + string + " " + string2 + " already exists.");
            return;
        }
        Playable playable2 = this.orrery.parsePlayable(string, string2, string3);
        this.orrery.storePlayable(playable2);
    }

    private void deletePlayable(String string, String string2) {
        Playable playable;
        Body body;
        int n;
        this.orrery.removePlayable(string, string2);
        int n2 = this.orrery.getInitialBodyCount();
        int n3 = this.orrery.getInitialRockCount();
        Body[] bodyArray = this.orrery.getInitialBodies();
        Rock[] rockArray = this.orrery.getInitialRocks();
        for (n = 0; n < n2; ++n) {
            body = bodyArray[n];
            if (body == null || (playable = body.getPlayable()) == null || !playable.getType().equals(string) || !playable.getName().equals(string2)) continue;
            body.setPlayable(null);
        }
        for (n = 0; n < n3; ++n) {
            body = rockArray[n];
            if (body == null || (playable = body.getPlayable()) == null || !playable.getType().equals(string) || !playable.getName().equals(string2)) continue;
            body.setPlayable(null);
        }
    }

    private void previewEditedPlayable(String string, String string2, String string3, String string4) {
        Playable playable = this.orrery.parsePlayable(string, string2, string3);
        int n = this.orrery.getInstrumentChannel(string4);
        if (playable != null && n != -1) {
            this.startPreviewThread(playable, n, this.editedPreviewButton, this.editedStopButton);
        }
    }

    private void fillPlayableEditor(String string, String string2) {
        Playable playable = this.findPlayable(string, string2);
        if (playable == null) {
            this.peEditorName.setText("");
            this.peEditorBody.setText("");
        } else {
            this.peEditorName.setText(string2);
            StringBuffer stringBuffer = new StringBuffer();
            playable.writeBody(stringBuffer);
            this.peEditorBody.setText(stringBuffer.toString());
        }
    }

    private Playable findPlayable(String string, String string2) {
        if (string.equals("note")) {
            return new Note(string2);
        }
        if (string.equals("melody")) {
            return this.orrery.getMelody(string2);
        }
        if (string.equals("scale")) {
            return this.orrery.getScale(string2);
        }
        if (string.equals("sequence")) {
            return this.orrery.getSequence(string2);
        }
        return null;
    }

    private JPanel makeInstrumentsEditorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 16;
        this.channelNames = new JTextField[n];
        this.channelBanks = new JTextField[n];
        this.channelPrograms = new JTextField[n];
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("channel"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        jPanel.add((Component)this.makeTextLabel(" name"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.makeTextLabel("bank"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.makeTextLabel("program"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.fill = 2;
        jPanel.add((Component)this.makeTextLabel(""), gridBagConstraints);
        for (int i = 0; i < n; ++i) {
            gridBagConstraints.gridy = i + 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 13;
            jPanel.add((Component)this.makeTextLabel("" + i), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.anchor = 17;
            this.channelNames[i] = this.makeTextField();
            this.channelNames[i].setColumns(15);
            jPanel.add((Component)this.channelNames[i], gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.channelBanks[i] = this.makeTextField();
            this.channelBanks[i].setColumns(4);
            jPanel.add((Component)this.channelBanks[i], gridBagConstraints);
            ++gridBagConstraints.gridx;
            this.channelPrograms[i] = this.makeTextField();
            this.channelPrograms[i].setColumns(4);
            jPanel.add((Component)this.channelPrograms[i], gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.makeTextLabel(""), gridBagConstraints);
        }
        return jPanel;
    }

    private void fillInstrumentsPanel() {
        if (this.kepler.kioskMode()) {
            return;
        }
        int n = 16;
        System.out.println("Fill instruments panel");
        this.pePreviewInstrument.removeAllItems();
        for (int i = 0; i < n; ++i) {
            String string = this.orrery.getChannelName(i);
            int n2 = this.orrery.getChannelBank(i);
            int n3 = this.orrery.getChannelProgram(i);
            System.out.println("   ch: " + i + " " + string + " " + n2 + " " + n3);
            if (string == null || string.trim().equals("")) {
                string = "inst" + i;
            }
            this.channelNames[i].setText(string);
            this.channelBanks[i].setText("" + n2);
            this.channelPrograms[i].setText("" + n3);
            this.pePreviewInstrument.addItem(string);
        }
    }

    private JPanel makeSqueegee(String string, JPanel jPanel, boolean bl) {
        JPanel jPanel2 = new JPanel();
        jPanel2.setBackground(this.orrery.controlPanelBG);
        jPanel2.setLayout(new GridBagLayout());
        jPanel2.setBorder(new MatteBorder(0, 0, 1, 0, this.orrery.squeegeeTabBG));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        ImageIcon imageIcon = Kepler.createImageIcon("expand" + string + ".gif", "");
        ImageIcon imageIcon2 = Kepler.createImageIcon("collapse" + string + ".gif", "");
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.setBorder(new MatteBorder(0, 0, 0, 0, Color.RED));
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setBackground(this.orrery.bgColor);
        jToggleButton.setSelectedIcon(imageIcon2);
        jToggleButton.setPressedIcon(imageIcon2);
        jToggleButton.setSelected(bl);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel2.add((Component)jToggleButton, gridBagConstraints);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        jPanel2.add((Component)new JLabel(""), gridBagConstraints);
        jPanel.setBorder(new MatteBorder(2, 1, 0, 1, this.orrery.squeegeeTabBG));
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints.anchor = 18;
        gridBagConstraints.fill = 1;
        jPanel2.add((Component)jPanel, gridBagConstraints);
        jPanel.setVisible(bl);
        jToggleButton.addActionListener(new SqueegeeTabListener(jToggleButton, jPanel));
        return jPanel2;
    }

    private JComboBox makePlayableTypeChooser() {
        JComboBox jComboBox = this.makeDropDown();
        jComboBox.addItem("");
        jComboBox.addItem("note");
        jComboBox.addItem("melody");
        jComboBox.addItem("sequence");
        jComboBox.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!WorldBuilder.this.playableChooserUpdating) {
                    WorldBuilder.this.orrery.resetPlayTimer();
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    String string = (String)jComboBox.getSelectedItem();
                    System.out.println("Calling ppulate plbl chooser on playableChooser (from ptype drop)");
                    WorldBuilder.this.populatePlayableChooser(string, "");
                }
            }
        });
        return jComboBox;
    }

    private void selectPlayable(String string, String string2) {
        this.selectPlayable(this.playableTypeChooser, this.playableChooser, string, string2);
    }

    private void selectPlayable(JComboBox jComboBox, JComboBox jComboBox2, String string, String string2) {
        jComboBox.setSelectedItem(string);
        System.out.println("selectPlayable(" + string + ", " + string2 + ")");
        if (string.equals("")) {
            jComboBox2.setSelectedItem("");
            this.noteChooser.setText("");
        } else if (string.equals("note")) {
            jComboBox2.setSelectedItem("");
            this.noteChooser.setText(string2);
        } else if (string.equals("melody")) {
            jComboBox2.setSelectedItem(string2);
            this.noteChooser.setText("");
        } else if (string.equals("sequence")) {
            jComboBox2.setSelectedItem(string2);
            this.noteChooser.setText("");
        } else {
            jComboBox2.setSelectedItem(string2);
            this.noteChooser.setText("");
        }
    }

    private void populatePlayableChooser(String string, String string2) {
        this.populatePlayableChooser(this.playableTypeChooser, this.playableChooser, string, string2);
    }

    private void populatePlayableChooser(JComboBox jComboBox, JComboBox jComboBox2, String string, String string2) {
        if (jComboBox == null || jComboBox2 == null) {
            return;
        }
        this.playableChooserUpdating = true;
        System.out.println("PopulatePlayableChooser(drop=" + jComboBox2 + " type=" + string + ", selection: " + string2 + ")");
        if (string.equals("note")) {
            jComboBox2.setVisible(false);
            if (this.noteChooser != null) {
                this.noteChooser.setVisible(true);
            }
        } else {
            String string3 = null;
            jComboBox2.removeAllItems();
            jComboBox2.addItem("");
            if (string.equals("melody")) {
                Iterator iterator = this.orrery.getMelodyNames();
                while (iterator.hasNext()) {
                    String string4 = (String)iterator.next();
                    if (string3 == null) {
                        string3 = string4;
                    }
                    System.out.println("Adding melody: " + string4);
                    jComboBox2.addItem(string4);
                }
            } else if (string.equals("scale")) {
                Iterator iterator = this.orrery.getScaleNames();
                while (iterator.hasNext()) {
                    String string5 = (String)iterator.next();
                    if (string3 == null) {
                        string3 = string5;
                    }
                    System.out.println("Adding scale: " + string5);
                    jComboBox2.addItem(string5);
                }
            } else if (string.equals("sequence")) {
                Iterator iterator = this.orrery.getSequenceNames();
                while (iterator.hasNext()) {
                    String string6 = (String)iterator.next();
                    if (string3 == null) {
                        string3 = string6;
                    }
                    jComboBox2.addItem(string6);
                }
            }
            if (this.noteChooser != null) {
                this.noteChooser.setVisible(false);
            }
            jComboBox2.setVisible(true);
            System.out.println("PPC: playableSelection: " + string2 + " first: " + string3);
            if (string2 == "__first__") {
                string2 = string3;
            }
        }
        this.selectPlayable(jComboBox, jComboBox2, string, string2);
        this.playableChooserUpdating = false;
    }

    private JPanel makeRockEditorPanel() {
        return this.makeBodyEditorPanel_std(1);
    }

    private JPanel makeLocationPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.orrery.controlPanelSubBorder, 1), "Location"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.posCoordTypeToggle = this.makeImageToggleButton("CartesianPolarToggle_cart.gif", "CartesianPolarToggle_polar.gif", "Select cartesian or polar coordinate system.");
        this.posCoordTypeToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WorldBuilder.this.posCoordTypeToggle.isSelected()) {
                    WorldBuilder.this.posCoord1Label.setText("r");
                    WorldBuilder.this.posCoord2Label.setText("theta");
                    try {
                        double d = WorldBuilder.this.extractDouble(WorldBuilder.this.posCoord1Text, "posX");
                        double d2 = WorldBuilder.this.extractDouble(WorldBuilder.this.posCoord2Text, "posY");
                        Vect vect = new Vect(d, d2);
                        WorldBuilder.this.displayText(WorldBuilder.this.posCoord1Text, vect.r());
                        WorldBuilder.this.displayText(WorldBuilder.this.posCoord2Text, vect.thetaDegrees());
                    }
                    catch (Exception exception) {}
                } else {
                    WorldBuilder.this.posCoord1Label.setText("X");
                    WorldBuilder.this.posCoord2Label.setText("Y");
                    try {
                        double d = WorldBuilder.this.extractDouble(WorldBuilder.this.posCoord1Text, "posR");
                        double d3 = WorldBuilder.this.extractDouble(WorldBuilder.this.posCoord2Text, "posTheta");
                        Vect vect = Vect.createPolarDegrees(d, d3);
                        WorldBuilder.this.displayText(WorldBuilder.this.posCoord1Text, vect.x());
                        WorldBuilder.this.displayText(WorldBuilder.this.posCoord2Text, vect.y());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        jPanel.add((Component)this.posCoordTypeToggle, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        this.posCoord1Label = this.makeTextLabel("X");
        jPanel.add((Component)this.posCoord1Label, gridBagConstraints);
        this.posCoord1Text = this.makeNumberField();
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.posCoord1Text, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        this.posCoord2Label = this.makeTextLabel("Y");
        jPanel.add((Component)this.posCoord2Label, gridBagConstraints);
        this.posCoord2Text = this.makeNumberField();
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.posCoord2Text, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        jPanel.add((Component)this.makeTextLabel("Offset"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 5, 0, 0);
        jPanel.add((Component)this.makeTextLabel("X"), gridBagConstraints);
        this.offsetXText = this.makeNumberField();
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.offsetXText, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 15, 0, 0);
        jPanel.add((Component)this.makeTextLabel("Y"), gridBagConstraints);
        this.offsetYText = this.makeNumberField();
        ++gridBagConstraints.gridx;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.offsetYText, gridBagConstraints);
        return jPanel;
    }

    private JPanel makeVelocityPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.orrery.controlPanelSubBorder, 1), "Velocity"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        this.vCoordTypeToggle = this.makeImageToggleButton("CartesianPolarToggle_cart.gif", "CartesianPolarToggle_polar.gif", "Select cartesian or polar coordinate system.");
        this.vCoordTypeToggle.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (WorldBuilder.this.vCoordTypeToggle.isSelected()) {
                    WorldBuilder.this.vCoord1Label.setText("r");
                    WorldBuilder.this.vCoord2Label.setText("theta");
                    try {
                        double d = WorldBuilder.this.extractDouble(WorldBuilder.this.vCoord1Text, "vX");
                        double d2 = WorldBuilder.this.extractDouble(WorldBuilder.this.vCoord2Text, "vY");
                        Vect vect = new Vect(d, d2);
                        WorldBuilder.this.displayText(WorldBuilder.this.vCoord1Text, vect.r());
                        WorldBuilder.this.displayText(WorldBuilder.this.vCoord2Text, vect.thetaDegrees());
                    }
                    catch (Exception exception) {}
                } else {
                    WorldBuilder.this.vCoord1Label.setText("X");
                    WorldBuilder.this.vCoord2Label.setText("Y");
                    try {
                        double d = WorldBuilder.this.extractDouble(WorldBuilder.this.vCoord1Text, "vR");
                        double d3 = WorldBuilder.this.extractDouble(WorldBuilder.this.vCoord2Text, "vTheta");
                        Vect vect = Vect.createPolarDegrees(d, d3);
                        WorldBuilder.this.displayText(WorldBuilder.this.vCoord1Text, vect.x());
                        WorldBuilder.this.displayText(WorldBuilder.this.vCoord2Text, vect.y());
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        });
        jPanel.add((Component)this.vCoordTypeToggle, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.vCoord1Label = this.makeTextLabel("X");
        jPanel.add((Component)this.vCoord1Label, gridBagConstraints);
        this.vCoord1Text = this.makeNumberField();
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.vCoord1Text, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.vCoord2Label = this.makeTextLabel("Y");
        jPanel.add((Component)this.vCoord2Label, gridBagConstraints);
        this.vCoord2Text = this.makeNumberField();
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.vCoord2Text, gridBagConstraints);
        return jPanel;
    }

    JPanel makePlayableSelectionPanel(Color color) {
        if (this.kepler.kioskMode()) {
            return this.makePlayableSelectionPanel_kiosk(color);
        }
        return this.makePlayableSelectionPanel_std(color);
    }

    JPanel makePlayableSelectionPanel_std(Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.orrery.controlPanelSubBorder, 1), "Play"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("Type"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.playableTypeChooser = this.makePlayableTypeChooser();
        jPanel.add((Component)this.playableTypeChooser, gridBagConstraints);
        ++gridBagConstraints.gridx;
        this.noteChooser = this.makeTextField();
        this.playableChooser = this.makeDropDown();
        this.playableChooser.setVisible(false);
        jPanel.add((Component)this.noteChooser, gridBagConstraints);
        jPanel.add((Component)this.playableChooser, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("Instrument"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 2;
        this.instrumentChooser = this.makeDropDown();
        jPanel.add((Component)this.instrumentChooser, gridBagConstraints);
        gridBagConstraints.gridx = 3;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.currentPreviewButton = this.makeImageButton("PreviewButton_small_up.gif", "PreviewButton_small_down.gif", "Preview");
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.currentPreviewButton, gridBagConstraints);
        this.currentPreviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.previewCurrentPlayableInstrumentSelection();
            }
        });
        this.currentStopButton = this.makeImageButton("StopButton_small_up.gif", "StopButton_small_down.gif", "Stop preview in progress");
        this.currentStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.stopPreviewThread();
            }
        });
        this.currentStopButton.setVisible(false);
        jPanel.add((Component)this.currentStopButton, gridBagConstraints);
        return jPanel;
    }

    JPanel makePlayableSelectionPanel_kiosk(Color color) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(color);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        int n2 = 8;
        int n3 = 6;
        gridBagConstraints.gridx = n;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(22, n2, 0, n3);
        jPanel.add((Component)this.makeTextLabel("Play"), gridBagConstraints);
        gridBagConstraints.gridx = n;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(3, n2, 0, 0);
        this.playableTypeChooser = this.makePlayableTypeChooser();
        jPanel.add((Component)this.playableTypeChooser, gridBagConstraints);
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(3, 0, 0, n3);
        this.noteChooser = this.makeTextField();
        this.playableChooser = this.makeDropDown();
        this.playableChooser.setVisible(true);
        this.noteChooser.setVisible(false);
        jPanel.add((Component)this.noteChooser, gridBagConstraints);
        jPanel.add((Component)this.playableChooser, gridBagConstraints);
        this.playableChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (!WorldBuilder.this.playableChooserUpdating && WorldBuilder.this.selected != null) {
                    Playable playable = WorldBuilder.this.getCurrentPlayableSelection();
                    WorldBuilder.this.selected.setPlayable(playable);
                    WorldBuilder.this.updateSelected(WorldBuilder.this.selected, true);
                }
            }
        });
        gridBagConstraints.gridx = n;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(8, n2, 0, n3);
        jPanel.add((Component)this.makeTextLabel("Instrument"), gridBagConstraints);
        gridBagConstraints.gridx = n;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.insets = new Insets(3, n2, 0, n3);
        this.instrumentChooser = this.makeDropDown();
        jPanel.add((Component)this.instrumentChooser, gridBagConstraints);
        this.instrumentChooser.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                String string = WorldBuilder.this.getCurrentInstrumentSelection();
                WorldBuilder.this.selected.setInstrument(string);
                int n = WorldBuilder.this.orrery.getInstrumentChannel(string);
                WorldBuilder.this.selected.setChannel(n);
                WorldBuilder.this.updateSelected(WorldBuilder.this.selected, true);
            }
        });
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = n + 1;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.gridwidth = 1;
        this.currentPreviewButton = this.makeImageButton("PreviewButton_small_up.gif", "PreviewButton_small_down.gif", "Preview");
        gridBagConstraints.anchor = 13;
        gridBagConstraints.insets = new Insets(8, n2, n3, 0);
        jPanel.add((Component)this.currentPreviewButton, gridBagConstraints);
        this.currentPreviewButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.previewCurrentPlayableInstrumentSelection();
            }
        });
        this.currentStopButton = this.makeImageButton("StopButton_small_up.gif", "StopButton_small_down.gif", "Stop preview in progress");
        this.currentStopButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                WorldBuilder.this.stopPreviewThread();
            }
        });
        this.currentStopButton.setVisible(false);
        jPanel.add((Component)this.currentStopButton, gridBagConstraints);
        gridBagConstraints.gridx = n;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(8, n2, 0, n3);
        this.playablePreviewText = this.makeTextArea(5, 10, color, this.orrery.controlPanelValueBG);
        jPanel.add((Component)this.playablePreviewText, gridBagConstraints);
        return jPanel;
    }

    JPanel makeMutatorPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(BorderFactory.createTitledBorder(BorderFactory.createLineBorder(this.orrery.controlPanelSubBorder, 1), "Mutator"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("Type"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.mutatorTypeChooser = this.makeMutatorTypeChooser();
        jPanel.add((Component)this.mutatorTypeChooser, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("Chance"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.mutatorChanceText = this.makeTextField();
        jPanel.add((Component)this.mutatorChanceText, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("After"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.mutatorAfterText = this.makeTextField();
        jPanel.add((Component)this.mutatorAfterText, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("Low"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.mutatorLowText = this.makeTextField();
        jPanel.add((Component)this.mutatorLowText, gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 13;
        jPanel.add((Component)this.makeTextLabel("High"), gridBagConstraints);
        ++gridBagConstraints.gridx;
        gridBagConstraints.anchor = 17;
        this.mutatorHighText = this.makeTextField();
        jPanel.add((Component)this.mutatorHighText, gridBagConstraints);
        return jPanel;
    }

    private void updateMutatorPanel(Body body) {
        if (!body.is_mutator) {
            this.mutatorTypeChooser.setSelectedItem("");
            this.displayText(this.mutatorChanceText, "");
            this.displayText(this.mutatorAfterText, "");
            this.displayText(this.mutatorLowText, "");
            this.displayText(this.mutatorHighText, "");
            return;
        }
        int n = 0;
        int n2 = body.mutate_after;
        String string = "";
        double d = -1.0;
        double d2 = -1.0;
        if (body.mutate_mass_type != 0 && (double)body.mutate_mass_chance > 0.0) {
            if (body.mutate_mass_type == 2) {
                string = "mass%";
            } else if (body.mutate_mass_type == 1) {
                string = "mass";
            }
            n = body.mutate_mass_chance;
            d = body.mutate_mass_lo;
            d2 = body.mutate_mass_hi;
        } else if (body.mutate_velocity_type != 0 && (double)body.mutate_velocity_chance > 0.0) {
            string = "velocity%";
            n = body.mutate_velocity_chance;
            d = body.mutate_velocity_lo;
            d2 = body.mutate_velocity_hi;
        } else if (body.mutate_clone && (double)body.mutate_clone_chance > 0.0) {
            string = "clone";
            n = body.mutate_clone_chance;
            d = body.mutate_clone_lo;
            d2 = body.mutate_clone_hi;
        } else if (body.mutate_killa && (double)body.mutate_killa_chance > 0.0) {
            string = "killa";
            n = body.mutate_killa_chance;
        } else if (body.mutate_blackhole && (double)body.mutate_blackhole_chance > 0.0) {
            string = "blackhole";
            n = body.mutate_blackhole_chance;
        }
        this.mutatorTypeChooser.setSelectedItem(string);
        this.displayText(this.mutatorChanceText, n);
        if (n2 > 0) {
            this.displayText(this.mutatorAfterText, n2);
        }
        if (d >= 0.0) {
            this.displayText(this.mutatorLowText, d);
        } else {
            this.displayText(this.mutatorLowText, "");
        }
        if (d2 >= 0.0) {
            this.displayText(this.mutatorHighText, d2);
        } else {
            this.displayText(this.mutatorHighText, "");
        }
    }

    private void applySelectedMutatorEdits(Body body) {
        String string = (String)this.mutatorTypeChooser.getSelectedItem();
        int n = this.extractInt(this.mutatorChanceText, "Mutator Chance", 0);
        int n2 = this.extractInt(this.mutatorAfterText, "Mutate After", -1);
        double d = this.extractDouble(this.mutatorLowText, "Mutator Low value", 0.0);
        double d2 = this.extractDouble(this.mutatorHighText, "Mutator High value", 0.0);
        System.out.println(" APPLY MUTATOR. type: " + string + " chance: " + n + " after: " + n2 + " low: " + d + " high: " + d2);
        body.mutate_mass_type = 0;
        body.mutate_velocity_type = 0;
        body.mutate_clone = false;
        body.mutate_killa = false;
        body.mutate_blackhole = false;
        if (string.equals("")) {
            body.is_mutator = false;
            return;
        }
        body.mutate_after = n2;
        body.is_mutator = true;
        if (string.equals("mass%")) {
            body.mutate_mass_chance = n;
            body.mutate_mass_type = 2;
            body.mutate_mass_lo = d;
            body.mutate_mass_hi = d2;
        } else if (string.equals("mass")) {
            body.mutate_mass_chance = n;
            body.mutate_mass_type = 1;
            body.mutate_mass_lo = d;
            body.mutate_mass_hi = d2;
        } else if (string.equals("velocity%")) {
            body.mutate_velocity_chance = n;
            body.mutate_velocity_type = 3;
            body.mutate_velocity_lo = d;
            body.mutate_velocity_hi = d2;
        } else if (string.equals("clone")) {
            body.mutate_clone = true;
            body.mutate_clone_chance = n;
            body.mutate_clone_lo = d;
            body.mutate_clone_hi = d2;
            System.out.println("Applied a clone. chance: " + n + " lo: " + d + " hi: " + d2);
        } else if (string.equals("killa")) {
            body.mutate_killa = true;
            body.mutate_killa_chance = n;
        } else if (string.equals("blackhole")) {
            body.mutate_blackhole = true;
            body.mutate_blackhole_chance = n;
        }
    }

    private JComboBox makeMutatorTypeChooser() {
        JComboBox jComboBox = this.makeDropDown();
        jComboBox.addItem("");
        jComboBox.addItem("mass");
        jComboBox.addItem("mass%");
        jComboBox.addItem("velocity%");
        jComboBox.addItem("clone");
        jComboBox.addItem("killa");
        jComboBox.addItem("blackhole");
        return jComboBox;
    }

    public void worldRead() {
        this.fillInstrumentsPanel();
        this.populatePlayableChooser(this.peSelectorType, this.peSelectorName, "melody", "__first__");
    }

    public void dawnOfCreation() {
    }

    public void endOfTheWorld() {
    }

    public void applyWorldBuilderEdits() {
        System.out.println("APPLY!!!11!!!11Eleven!");
        try {
            this.applyWorldMetadataEdits();
            this.applySelectedBodyEdits(this.selected);
            this.applyMelodyEdits();
            this.applyInstrumentEdits();
            this.updateSelected(this.selected, true);
        }
        catch (ControlPanel.DataException dataException) {
            this.displayError(dataException);
        }
        this.orrery.worldBuilderDraw();
    }

    public void applySelectedBodyEdits(Body body) throws ControlPanel.DataException {
        if (body == null) {
            return;
        }
        double d = this.extractDouble(this.massText, "mass");
        body.setMass(d);
        this.applySelectedPosEdits(body);
        if (!(body instanceof Rock)) {
            this.applySelectedVEdits(body);
        }
        this.applySelectedPlayableEdits(body);
        this.applySelectedMutatorEdits(body);
    }

    public void applySelectedPosEdits(Body body) throws ControlPanel.DataException {
        Vect vect;
        Vect vect2 = body.posOffset;
        if (vect2 != null) {
            vect = body.pos.minus(vect2);
        }
        if (!this.emptyText(this.offsetXText) && !this.emptyText(this.offsetYText)) {
            double d = this.extractDouble(this.offsetXText, "offsetX");
            double d2 = this.extractDouble(this.offsetYText, "offsetY");
            body.posOffset = vect2 = new Vect(d, d2);
        }
        vect = null;
        if (this.posCoordTypeToggle.isSelected()) {
            double d = this.extractDouble(this.posCoord1Text, "posX");
            double d3 = this.extractDouble(this.posCoord2Text, "posY");
            vect = new Vect(d, d3);
            body.posSpecifiedPolar = false;
        } else {
            double d = this.extractDouble(this.posCoord1Text, "posR");
            double d4 = this.extractDouble(this.posCoord2Text, "posY");
            vect = Vect.createPolarDegrees(d, d4);
            body.posSpecifiedPolar = true;
        }
        if (vect2 != null && vect != null) {
            vect.plusEquals(vect2);
        }
        body.moveto(vect);
    }

    public void applySelectedVEdits(Body body) throws ControlPanel.DataException {
        Vect vect = body.v;
        if (this.vCoordTypeToggle.isSelected()) {
            double d = this.extractDouble(this.vCoord1Text, "vR");
            double d2 = this.extractDouble(this.vCoord2Text, "vTheta");
            vect = Vect.createPolarDegrees(d, d2);
            body.vSpecifiedPolar = true;
        } else {
            double d = this.extractDouble(this.vCoord1Text, "vX");
            double d3 = this.extractDouble(this.vCoord1Text, "vY");
            vect = new Vect(d, d3);
            body.vSpecifiedPolar = false;
        }
        System.out.println("apply v. newV: " + vect);
        body.setV(vect);
    }

    public void applySelectedPlayableEdits(Body body) throws ControlPanel.DataException {
        Playable playable = this.getCurrentPlayableSelection();
        body.setPlayable(playable);
        String string = this.getCurrentInstrumentSelection();
        body.setInstrument(string);
        int n = this.orrery.getInstrumentChannel(string);
        body.setChannel(n);
    }

    private void displayError(ControlPanel.DataException dataException) {
        System.out.println("WorldBuilder caught exception extracting data field " + dataException.getField());
    }

    public void applyMelodyEdits() throws ControlPanel.DataException {
    }

    public void applyInstrumentEdits() throws ControlPanel.DataException {
        int n = 16;
        System.out.println("Apply Instrument Edits!");
        for (int i = 0; i < n; ++i) {
            String string = this.channelNames[i].getText();
            if (string == null || string.equals("")) continue;
            String string2 = this.channelBanks[i].getText();
            String string3 = this.channelPrograms[i].getText();
            try {
                int n2 = Integer.parseInt(string2);
                int n3 = Integer.parseInt(string3);
                this.orrery.setChannelInfo(i, string, n2, n3);
                System.out.println("  ch: " + i + " " + string + " " + n2 + " " + n3);
                continue;
            }
            catch (NumberFormatException numberFormatException) {
                System.out.println("Exception parsing instrument " + i + ": " + numberFormatException);
            }
        }
        this.orrery.reloadPatches();
    }

    public void applyWorldMetadataEdits() throws ControlPanel.DataException {
    }

    public void setMousePressedTime(long l) {
        this.mousePressedTime = l;
        this.ndrags = 0;
    }

    public void mouseDragged(double d, double d2) {
        long l;
        long l2 = System.currentTimeMillis();
        long l3 = l = this.mousePressedTime == 0L ? 0L : l2 - this.mousePressedTime;
        if (this.selected != null && l > this.dragWaitDelay) {
            ++this.ndrags;
            this.selected.moveto(d, d2);
            if (this.ndrags % 10 == 0) {
                // empty if block
            }
            this.orrery.worldBuilderDraw();
        }
    }

    public void altMousePressed(double d, double d2) {
    }

    public void metaMousePressed(double d, double d2) {
    }

    public void controlAltMousePressed(double d, double d2) {
        if (this.selected != null) {
            this.addClone(this.selected, d, d2);
            this.orrery.worldBuilderDraw();
        }
    }

    public void controlMousePressed(double d, double d2) {
    }

    public void shiftMousePressed(double d, double d2) {
    }

    private void previewCurrentPlayableInstrumentSelection() {
        int n;
        String string;
        Playable playable = this.getCurrentPlayableSelection();
        if (playable != null && (string = this.getCurrentInstrumentSelection()) != null && (n = this.orrery.getInstrumentChannel(string)) != -1) {
            this.startPreviewThread(playable, n, this.currentPreviewButton, this.currentStopButton);
        }
    }

    private void startPreviewThread(Playable playable, int n, JButton jButton, JButton jButton2) {
        this.previewThread = new PreviewThread(this.orrery);
        this.previewThread.setPlayable(playable, n);
        this.previewThread.setButtons(jButton, jButton2);
        this.previewThread.start();
        Thread.yield();
    }

    private void stopPreviewThread() {
        if (this.previewThread != null) {
            this.previewThread.halt();
            this.previewThread = null;
        }
    }

    public void notePlayed(Body body, Playable playable, Note note) {
        if (this.showingPhysicsMode) {
            return;
        }
        if (body != null && body == this.selected) {
            this.showPlayableCurrentState(playable);
        }
    }

    private Playable getCurrentPlayableSelection() {
        String string = (String)this.playableTypeChooser.getSelectedItem();
        if (string == null || string.equals("")) {
            return null;
        }
        if (string.equals("note")) {
            String string2 = this.noteChooser.getText();
            if (string2 == null || string2.trim().equals("")) {
                return null;
            }
            return new Note(string2);
        }
        if (string.equals("melody")) {
            String string3 = (String)this.playableChooser.getSelectedItem();
            if (string3 == null || string3.equals("")) {
                return null;
            }
            return this.orrery.getMelody(string3);
        }
        if (string.equals("sequence")) {
            String string4 = (String)this.playableChooser.getSelectedItem();
            if (string4 == null || string4.equals("")) {
                return null;
            }
            return this.orrery.getSequence(string4);
        }
        return null;
    }

    private String getCurrentInstrumentSelection() {
        return (String)this.instrumentChooser.getSelectedItem();
    }

    public void setMode(String string, boolean bl) {
    }

    class PreviewThread
    extends Thread {
        private JButton previewButton = null;
        private JButton stopButton = null;
        private Orrery orrery;
        private Playable playable = null;
        private int channel = 0;
        public boolean previewing = false;

        public PreviewThread(Orrery orrery) {
            this.orrery = orrery;
        }

        public void setButtons(JButton jButton, JButton jButton2) {
            this.previewButton = jButton;
            this.stopButton = jButton2;
        }

        public void setPlayable(Playable playable, int n) {
            System.out.println("WB: PreviewThread.setPlayable: " + playable + " playable.getName(): " + playable.getName());
            this.playable = playable;
            this.channel = n;
        }

        public synchronized void run() {
            this.stopButton.setVisible(true);
            this.previewButton.setVisible(false);
            this.preview(this.playable, this.channel);
            this.previewButton.setVisible(true);
            this.stopButton.setVisible(false);
        }

        public void halt() {
            this.stopPreview();
        }

        public void preview(Playable playable, int n) {
            this.preview(playable, n, 200, 700);
        }

        public void preview(Playable playable, int n, int n2, int n3) {
            if (playable instanceof Note) {
                this.orrery.playNote((Note)playable, n, 500);
            } else {
                this.previewing = true;
                playable.reset();
                while (this.previewing && !playable.atEnd()) {
                    int n4 = Orrery.randomRange(n2, n3);
                    Note note = playable.nextNote(null, this.orrery);
                    WorldBuilder.this.showPlayableCurrentState(playable);
                    Thread.yield();
                    System.out.println("    playing note: " + note + " dur: " + n4);
                    this.orrery.playNote(note, n, n4);
                    System.out.println("      played note. previewing=" + this.previewing);
                }
                this.previewing = false;
                this.orrery.midiAllOff();
            }
        }

        public void stopPreview() {
            this.previewing = false;
        }
    }

    class SqueegeeTabListener
    implements ActionListener {
        private JToggleButton button;
        private JPanel contentPanel;

        public SqueegeeTabListener(JToggleButton jToggleButton, JPanel jPanel) {
            this.button = jToggleButton;
            this.contentPanel = jPanel;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            boolean bl = this.button.isSelected();
            this.contentPanel.setVisible(bl);
        }
    }
}

