/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import util.StdDraw;

public class Vect {
    protected double x;
    protected double y;
    public static final Vect ZERO = new Vect();

    public Vect(double d, double d2) {
        this.x = d;
        this.y = d2;
    }

    public Vect(double[] dArray) {
        this.x = dArray[0];
        this.y = dArray[1];
    }

    public Vect() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public Vect duplicate() {
        Vect vect = new Vect(this.x, this.y);
        return vect;
    }

    public static Vect createPolar(double d, double d2) {
        return new Vect(d * Math.cos(d2), d * Math.sin(d2));
    }

    public static Vect createPolarDegrees(double d, double d2) {
        double d3 = Math.toRadians(d2);
        return new Vect(d * Math.cos(d3), d * Math.sin(d3));
    }

    public void zero() {
        this.x = 0.0;
        this.y = 0.0;
    }

    public double x() {
        return this.x;
    }

    public double y() {
        return this.y;
    }

    public double r() {
        return this.magnitude();
    }

    public double thetaDegrees() {
        double d = Math.atan2(this.y, this.x);
        double d2 = Math.toDegrees(d);
        return d2;
    }

    public double theta() {
        double d = Math.atan2(this.y, this.x);
        return d;
    }

    public Vect moveTheta(double d) {
        double d2 = this.r();
        Vect vect = Vect.createPolar(d2, d);
        return vect;
    }

    public void thetaPlusEqualsDegrees(double d) {
        double d2 = this.theta();
        double d3 = Math.toRadians(d);
        this.setTheta(d2 + d3);
    }

    public void setTheta(double d) {
        double d2 = this.r();
        this.x = d2 * Math.cos(d);
        this.y = d2 * Math.sin(d);
    }

    public void setThetaDegrees(double d) {
        this.setTheta(Math.toRadians(d));
    }

    public void setR(double d) {
        if (this.r() == 0.0) {
            this.x = d;
            this.y = 0.0;
        } else {
            this.unitEquals();
            this.timesEquals(d);
        }
    }

    public void setX(double d) {
        this.x = d;
    }

    public void setY(double d) {
        this.y = d;
    }

    public double dot(Vect vect) {
        return this.x * vect.x + this.y * vect.y;
    }

    public double magnitude() {
        return Math.sqrt(this.x * this.x + this.y * this.y);
    }

    public Vect unit() {
        if (this.x == 0.0 && this.y == 0.0) {
            return new Vect(0.0, 0.0);
        }
        Vect vect = this;
        return vect.times(1.0 / vect.magnitude());
    }

    public Vect unitEquals() {
        if (this.x == 0.0 && this.y == 0.0) {
            return this;
        }
        return this.timesEquals(1.0 / this.magnitude());
    }

    public Vect plus(Vect vect) {
        Vect vect2 = new Vect(this.x + vect.x, this.y + vect.y);
        return vect2;
    }

    public Vect plusEquals(Vect vect) {
        this.x += vect.x;
        this.y += vect.y;
        return this;
    }

    public Vect minus(Vect vect) {
        Vect vect2 = new Vect(this.x - vect.x, this.y - vect.y);
        return vect2;
    }

    public Vect minusEquals(Vect vect) {
        this.x -= vect.x;
        this.y -= vect.y;
        return this;
    }

    public Vect times(double d) {
        Vect vect = new Vect(this.x * d, this.y * d);
        return vect;
    }

    public Vect timesEquals(double d) {
        this.x *= d;
        this.y *= d;
        return this;
    }

    public Vect reflect(Vect vect) {
        double d = -2.0 * this.dot(vect);
        Vect vect2 = vect.times(d);
        vect2.plusEquals(this);
        return vect2;
    }

    public void draw(StdDraw stdDraw) {
        this.draw(stdDraw, 0.0, 0.0);
    }

    public void draw(StdDraw stdDraw, double d, double d2) {
        stdDraw.line(d, this.x, d2, this.y);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append("( ");
        stringBuffer.append(this.x);
        stringBuffer.append(", ");
        stringBuffer.append(this.y);
        stringBuffer.append(")");
    }

    public static void main(String[] stringArray) {
        Vect vect = new Vect(1.0, 2.0);
        Vect vect2 = new Vect(5.0, 2.0);
        System.out.println("x        = " + vect);
        System.out.println("y        = " + vect2);
        System.out.println("x + y    = " + vect.plus(vect2));
        System.out.println("10x      = " + vect.times(10.0));
        System.out.println("|x|      = " + vect.magnitude());
        System.out.println("<x, y>   = " + vect.dot(vect2));
        System.out.println("|x - y|  = " + vect.minus(vect2).magnitude());
    }
}

