/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.util.ArrayList;
import java.util.Iterator;
import kepler.Body;
import kepler.Note;
import kepler.Orrery;
import kepler.Playable;

public class Sequence
extends Playable {
    public static final int TIME_TYPE_CYCLES = 0;
    public static final int TIME_TYPE_SECONDS = 1;
    public static final int TIME_TYPE_ROUNDS = 2;
    public static final int TIME_TYPE_NOTES = 3;
    public static final int TIME_CONTINUE = -1;
    public static final int WRAP_NONE = 0;
    public static final int WRAP_WRAP = 1;
    public static final int WRAP_CONTINUE_LAST = 2;
    protected ArrayList sequences = null;
    protected String name;
    protected int cursor = -1;
    protected int timeType = 1;
    protected int numNotes = 0;
    protected int sequenceRounds = 0;
    protected int cycleOffset = 0;
    protected int wrapType = 1;
    protected SubSequence currentSubSequence = null;

    public Sequence(String string) {
        this.name = string;
        this.sequences = new ArrayList();
    }

    public Playable duplicate() {
        Sequence sequence = new Sequence(this.name);
        sequence.setTimeType(this.timeType);
        Iterator iterator = this.sequences.iterator();
        while (iterator.hasNext()) {
            SubSequence subSequence = (SubSequence)iterator.next();
            Playable playable = subSequence.sequence;
            sequence.add(playable.duplicate(), subSequence.time);
        }
        return sequence;
    }

    public void setTimeType(int n) {
        this.timeType = n;
    }

    public void setTimeType(String string) {
        if (string.equalsIgnoreCase("seconds")) {
            this.timeType = 1;
        } else if (string.equalsIgnoreCase("cycles")) {
            this.timeType = 0;
        } else if (string.equalsIgnoreCase("rounds")) {
            this.timeType = 2;
        } else if (string.equalsIgnoreCase("notes")) {
            this.timeType = 3;
        }
    }

    public String timeTypeString(int n) {
        switch (n) {
            case 1: {
                return "seconds";
            }
            case 0: {
                return "cycles";
            }
            case 2: {
                return "rounds";
            }
            case 3: {
                return "notes";
            }
        }
        return "unknown";
    }

    public void add(Playable playable, int n) {
        this.sequences.add(new SubSequence(playable, n));
    }

    public SubSequence getSequence(int n) {
        return (SubSequence)this.sequences.get(n);
    }

    public String getName() {
        return this.name;
    }

    public String getType() {
        return "sequence";
    }

    public Note nextNote(Body body, Orrery orrery) {
        if (this.cursor == -1) {
            this.cursor = 0;
            this.currentSubSequence = this.getSequence(this.cursor);
            this.cycleOffset = 0;
            this.sequenceRounds = 0;
            this.numNotes = 0;
        }
        boolean bl = false;
        if (this.currentSubSequence.time == -1) {
            bl = false;
        } else {
            switch (this.timeType) {
                case 1: {
                    int n = orrery.secondsToCycles(this.currentSubSequence.time);
                    bl = n <= orrery.numCycles - this.cycleOffset;
                    break;
                }
                case 0: {
                    bl = this.currentSubSequence.time <= orrery.numCycles - this.cycleOffset;
                    break;
                }
                case 2: {
                    bl = this.currentSubSequence.time <= this.sequenceRounds;
                    break;
                }
                case 3: {
                    boolean bl2 = bl = this.currentSubSequence.time <= this.numNotes;
                }
            }
        }
        if (bl) {
            this.cycleOffset = orrery.numCycles;
            this.sequenceRounds = 0;
            this.numNotes = 0;
            ++this.cursor;
            if (this.cursor >= this.sequences.size()) {
                if (this.wrapType == 1) {
                    this.cursor = 0;
                } else if (this.wrapType == 2) {
                    --this.cursor;
                }
            }
            this.currentSubSequence = this.getSequence(this.cursor);
        }
        ++this.numNotes;
        if (this.currentSubSequence.sequence.atEnd()) {
            ++this.sequenceRounds;
        }
        Note note = this.currentSubSequence.sequence.nextNote(body, orrery);
        return note;
    }

    public void reset() {
        this.reset(0);
    }

    public void writeBody(StringBuffer stringBuffer) {
        this.writeSequenceMods(stringBuffer);
        stringBuffer.append("\n");
        stringBuffer.append("  start\n");
        this.writeContents(stringBuffer, false);
        stringBuffer.append("  end");
    }

    public void writeCurrentState(StringBuffer stringBuffer) {
        this.writeSequenceMods(stringBuffer);
        stringBuffer.append("\n");
        stringBuffer.append("  start\n");
        this.writeContents(stringBuffer, true);
        stringBuffer.append("  end");
    }

    public void writeContents(StringBuffer stringBuffer, boolean bl) {
        boolean bl2 = false;
        Iterator iterator = this.sequences.iterator();
        while (iterator.hasNext()) {
            SubSequence subSequence = (SubSequence)iterator.next();
            Playable playable = subSequence.sequence;
            stringBuffer.append("    ");
            stringBuffer.append(playable.getType());
            stringBuffer.append(" ");
            stringBuffer.append(playable.getName());
            stringBuffer.append(" ");
            stringBuffer.append(subSequence.time);
            stringBuffer.append("\n");
            if (!bl || this.cursor != 1) continue;
            playable.writeCurrentState(stringBuffer);
        }
    }

    public void reset(int n) {
        this.cursor = n;
        this.currentSubSequence = this.getSequence(this.cursor);
    }

    public void writeSequenceMods(StringBuffer stringBuffer) {
        if (this.timeType != 1) {
            stringBuffer.append("timetype ");
            stringBuffer.append(this.timeTypeString(this.timeType));
            stringBuffer.append("\n");
        }
    }

    public boolean atEnd() {
        if (this.cursor >= this.sequences.size()) {
            if (this.currentSubSequence.time == -1) {
                return false;
            }
            return this.currentSubSequence.sequence.atEnd();
        }
        return false;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("SEQ(" + this.name + "){");
        Iterator iterator = this.sequences.iterator();
        while (iterator.hasNext()) {
            stringBuffer.append(iterator.next().toString());
            if (!iterator.hasNext()) continue;
            stringBuffer.append(", ");
        }
        return stringBuffer.toString();
    }

    class SubSequence {
        public Playable sequence;
        public int time;

        public SubSequence(Playable playable, int n) {
            this.sequence = playable;
            this.time = n;
        }

        public String toString() {
            return "{" + this.sequence + ", " + this.time + "}";
        }
    }
}

