/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.util.ArrayList;
import java.util.Iterator;
import kepler.Body;
import kepler.Note;
import kepler.Orrery;
import kepler.Playable;

public class Scale
extends Playable {
    protected ArrayList notes;
    protected String name;

    public Scale(String string) {
        this.name = string;
        this.notes = new ArrayList();
    }

    public String getType() {
        return "scale";
    }

    public Note nextNote(Body body, Orrery orrery) {
        int n = (int)Math.min(100.0, body.getPos().magnitude() / orrery.radius * 100.0);
        return this.getPercentNote(n);
    }

    public boolean atEnd() {
        return false;
    }

    public Playable duplicate() {
        Scale scale = new Scale(this.getName());
        Iterator iterator = this.notes.iterator();
        while (iterator.hasNext()) {
            scale.addNote((Note)iterator.next());
        }
        return scale;
    }

    public void reset() {
    }

    public void writeBody(StringBuffer stringBuffer) {
        Iterator iterator = this.notes.iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            note.writeBody(stringBuffer);
            stringBuffer.append(" ");
        }
        stringBuffer.append("end");
    }

    public void writeCurrentState(StringBuffer stringBuffer) {
        this.writeBody(stringBuffer);
    }

    public int length() {
        return this.notes.size();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String string) {
        this.name = string;
    }

    public Note getNote(int n) {
        return (Note)this.notes.get(n);
    }

    public Note getPercentNote(int n) {
        return this.getNote(n * (this.length() - 1) / 100);
    }

    public Iterator iterator() {
        return this.notes.iterator();
    }

    public void addNote(Note note) {
        this.notes.add(note);
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, n);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        this.toString(stringBuffer, -1);
    }

    public void toString(StringBuffer stringBuffer, int n) {
        stringBuffer.append("Scale[");
        stringBuffer.append(this.name);
        stringBuffer.append("] {");
        int n2 = 0;
        Iterator iterator = this.notes.iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            if (n == n2) {
                stringBuffer.append("<");
            }
            note.toString(stringBuffer);
            if (n == n2) {
                stringBuffer.append(">");
            }
            if (iterator.hasNext()) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        stringBuffer.append("}");
    }
}

