/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import kepler.Body;
import kepler.Vect;
import util.StdDraw;

public class Rock
extends Body {
    private static int next_nthrock = 0;
    private int nthrock = 0;
    public double move_theta = 0.0;

    public Rock() {
    }

    public Rock(Vect vect, double d, int n) {
        this.penRadius = 0.05;
        this.pos = vect;
        this.mass = d;
        this.init(n);
    }

    public void init(int n) {
        this.setMinMaxMasses(this.mass);
        this.nthrock = next_nthrock++;
        float f = (float)(1.0 / (double)n * (double)this.nthrock);
        this.color = Color.getHSBColor(f, 0.4f, 0.4f);
        this.highlightColor = Color.getHSBColor(f, 0.4f, 0.6f);
        this.playingColor = Color.getHSBColor(f, 0.65f, 1.0f);
        this.selectColor = Color.getHSBColor(f, 1.0f, 0.5f);
    }

    public Body duplicate() {
        Vect vect = this.pos.duplicate();
        Rock rock = new Rock(vect, this.mass, Rock.orrery.maxRocks);
        rock.cloneMutatorData(this);
        rock.clonePlayable(this);
        rock.move_theta = this.move_theta;
        return rock;
    }

    public static void resetDefaults() {
        next_nthrock = 0;
    }

    public static void resetNth() {
        next_nthrock = 0;
    }

    public void maybeMove() {
        if (this.move_theta != 0.0) {
            this.pos.thetaPlusEqualsDegrees(this.move_theta);
        }
    }

    public void draw(StdDraw stdDraw) {
        double d = this.pos.x();
        double d2 = this.pos.y();
        this.setDrawColor(stdDraw);
        stdDraw.filledSquare(d, d2, this.radius);
        if (this.is_mutator) {
            stdDraw.setPenColor(this.selectColor);
            stdDraw.square(d, d2, this.radius * 0.75);
        }
        if (this.select == -1) {
            if (orrery.paused()) {
                this.drawSelectedControls(stdDraw, d, d2);
            } else {
                double d3 = Math.max(this.radius * 1.5, baseRadius * 2.0);
                stdDraw.square(this.pos.x(), this.pos.y(), d3);
            }
        }
    }
}

