/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.util.ArrayList;
import java.util.Iterator;
import kepler.Playlist;

public class PlaylistManager {
    private String title = "";
    private boolean shuffle = false;
    private boolean loop = false;
    private ArrayList playlists = new ArrayList();
    private ArrayList shuffled = null;
    private int cursor = -1;
    private Playlist.Item onDeckItem = null;
    private Playlist.Item currentItem = null;
    private Playlist currentPlaylist = null;

    public void reset() {
        this.cursor = -1;
        this.placeNextOnDeck();
    }

    public void addPlaylist(Playlist playlist) {
        this.playlists.add(playlist);
        playlist.setShuffle(this.shuffle);
        playlist.reset();
    }

    public int numPlaylists() {
        return this.playlists.size();
    }

    public ArrayList getPlaylists() {
        return this.playlists;
    }

    public void compactPlaylists() {
        ArrayList<Playlist> arrayList = new ArrayList<Playlist>();
        Iterator iterator = this.playlists.iterator();
        while (iterator.hasNext()) {
            Playlist playlist = (Playlist)iterator.next();
            if (playlist.size() <= 0) continue;
            arrayList.add(playlist);
        }
        this.playlists = arrayList;
    }

    public Playlist getOnDeckPlaylist() {
        Playlist playlist;
        this.currentPlaylist = playlist = this.getNthPlaylist(this.cursor);
        return playlist;
    }

    public Playlist peekOnDeckPlaylist() {
        return this.getNthPlaylist(this.cursor);
    }

    public Playlist getCurrentPlaylist() {
        return this.currentPlaylist;
    }

    public Playlist getNthPlaylist(int n) {
        if (n >= 0 && n < this.playlists.size()) {
            return (Playlist)this.playlists.get(n);
        }
        return null;
    }

    public Playlist getPlaylistByTitle(String string) {
        int n = this.findPlaylistByTitle(string);
        return this.getNthPlaylist(n);
    }

    public int findPlaylistByTitle(String string) {
        if (string == null) {
            string = "";
        }
        int n = 0;
        Iterator iterator = this.playlists.iterator();
        while (iterator.hasNext()) {
            Playlist playlist = (Playlist)iterator.next();
            String string2 = playlist.getTitle();
            if (string2 == null) {
                string2 = "";
            }
            if (string.equals(string2)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findPlaylist(Playlist playlist) {
        int n = 0;
        Iterator iterator = this.playlists.iterator();
        while (iterator.hasNext()) {
            Playlist playlist2 = (Playlist)iterator.next();
            if (playlist == playlist2) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setShuffle(boolean bl) {
        this.shuffle = bl;
        Iterator iterator = this.playlists.iterator();
        while (iterator.hasNext()) {
            Playlist playlist = (Playlist)iterator.next();
            playlist.setShuffle(bl);
        }
    }

    public void setLoop(boolean bl) {
        this.loop = bl;
    }

    public boolean hasOnDeckItem() {
        return this.onDeckItem != null;
    }

    public Playlist.Item getOnDeckItem() {
        this.currentItem = this.onDeckItem;
        return this.onDeckItem;
    }

    public Playlist.Item peekOnDeckItem() {
        return this.onDeckItem;
    }

    public Playlist.Item getCurrentItem() {
        return this.currentItem;
    }

    public Playlist.Item getNextItem() {
        Playlist.Item item = this.onDeckItem;
        this.placeNextOnDeck();
        return item;
    }

    public void placeNextOnDeck() {
        Playlist playlist = this.getOnDeckPlaylist();
        Playlist.Item item = null;
        if (playlist != null && playlist.hasNext()) {
            item = playlist.next();
        } else {
            ++this.cursor;
            playlist = this.getOnDeckPlaylist();
            if (playlist == null && this.loop) {
                this.cursor = 0;
                playlist = this.getOnDeckPlaylist();
            }
            if (playlist != null) {
                playlist.reset();
                item = playlist.next();
            }
        }
        this.onDeckItem = item;
    }

    public void placePrevOnDeck() {
        Playlist playlist = this.getOnDeckPlaylist();
        Playlist.Item item = null;
        if (playlist != null && playlist.hasPrev()) {
            item = playlist.prev();
        } else {
            --this.cursor;
            playlist = this.getOnDeckPlaylist();
            if (playlist == null && this.loop) {
                this.cursor = this.playlists.size() - 1;
                playlist = this.getOnDeckPlaylist();
            }
            if (playlist != null) {
                playlist.resetToEnd();
                item = playlist.prev();
            }
        }
        this.onDeckItem = item;
    }

    public void placePlaylistOnDeck(Playlist playlist) {
        int n = this.findPlaylist(playlist);
        playlist.reset();
        this.cursor = n;
        this.placeNextOnDeck();
    }

    public void placeItemOnDeck(Playlist.Item item) {
        String string = this.getOnDeckPlaylist().getTitle();
        this.placeItemOnDeck(string, item);
    }

    public void placeItemOnDeck(String string, Playlist.Item item) {
        int n = this.findPlaylistByTitle(string);
        Playlist playlist = this.getNthPlaylist(n);
        playlist.setItem(item);
        this.onDeckItem = item;
        this.cursor = n;
    }

    public void placeItemOnDeckByName(String string, String string2) {
        int n = this.findPlaylistByTitle(string);
        Playlist playlist = this.getNthPlaylist(n);
        playlist.setItemByName(string2);
        this.onDeckItem = playlist.current();
        this.cursor = n;
    }

    public void placeItemOnDeckByFull(String string) {
        Playlist playlist = this.getCurrentPlaylist();
        playlist.setItemByFull(string);
        this.onDeckItem = playlist.current();
    }

    public void print(StringBuffer stringBuffer, boolean bl) {
        Playlist playlist = this.getOnDeckPlaylist();
        String string = playlist == null ? "nullPL" : playlist.getTitle();
        stringBuffer.append("PlaylistManager. ondeck=(" + string + " : " + this.onDeckItem + ")\n");
        Iterator iterator = this.playlists.iterator();
        while (iterator.hasNext()) {
            Playlist playlist2 = (Playlist)iterator.next();
            stringBuffer.append(playlist2.getTitle() + "\n");
            String string2 = "    ";
            playlist2.print(stringBuffer, string2, bl);
        }
    }

    public String print(boolean bl) {
        StringBuffer stringBuffer = new StringBuffer();
        this.print(stringBuffer, bl);
        return stringBuffer.toString();
    }

    public static void test1() {
        PlaylistManager playlistManager = new PlaylistManager();
        Playlist playlist = new Playlist();
        playlist.setTitle("one");
        playlistManager.addPlaylist(playlist);
        playlist.add("Fiorst");
        playlist.add("Second");
        playlist.add("Third");
        playlist.add("Fourth");
        playlist.add("Fifth");
        Playlist playlist2 = new Playlist();
        playlist2.setTitle("two");
        playlistManager.addPlaylist(playlist2);
        playlist2.add("2.1");
        playlist2.add("2.2");
        playlist2.add("2.3");
        playlist2.add("2.4");
        playlistManager.reset();
        System.out.println(playlistManager.print(true));
    }

    public static void test2() {
        String string;
        Playlist playlist;
        Playlist.Item item;
        int n;
        PlaylistManager playlistManager = new PlaylistManager();
        Playlist playlist2 = new Playlist();
        playlist2.setTitle("one");
        playlistManager.addPlaylist(playlist2);
        playlist2.add("Fiorst");
        playlist2.add("Second");
        playlist2.add("Third");
        playlist2.add("Fourth");
        playlist2.add("Fifth");
        Playlist playlist3 = new Playlist();
        playlist3.setTitle("two");
        playlistManager.addPlaylist(playlist3);
        playlist3.add("2.1");
        playlist3.add("2.2");
        playlist3.add("2.3");
        playlist3.add("2.4");
        playlistManager.reset();
        System.out.println(playlistManager.print(true));
        System.out.println("not looping...");
        for (n = 0; n < 15; ++n) {
            item = playlistManager.getOnDeckItem();
            playlist = playlistManager.getOnDeckPlaylist();
            String string2 = string = playlist == null ? " nullPL " : playlist.getTitle();
            if (item != null) {
                playlistManager.placeNextOnDeck();
            }
            System.out.println(n + ": " + string + ": " + item);
        }
        playlistManager.reset();
        playlistManager.setLoop(true);
        System.out.println("looping...");
        for (n = 0; n < 15; ++n) {
            item = playlistManager.getOnDeckItem();
            playlist = playlistManager.getOnDeckPlaylist();
            String string3 = string = playlist == null ? " nullPL " : playlist.getTitle();
            if (item != null) {
                playlistManager.placeNextOnDeck();
            }
            System.out.println(n + ": " + string + ": " + item);
        }
        System.out.println("\n\n going prev...");
        for (n = 0; n < 9; ++n) {
            playlistManager.placePrevOnDeck();
            item = playlistManager.getOnDeckItem();
            playlist = playlistManager.getOnDeckPlaylist();
            string = playlist == null ? " nullPL " : playlist.getTitle();
            System.out.println(n + ": " + string + ": " + item);
        }
        System.out.println("\n\n place item by name ...");
        playlistManager.placeItemOnDeckByName("two", "2.3");
        for (n = 0; n < 9; ++n) {
            item = playlistManager.getOnDeckItem();
            playlist = playlistManager.getOnDeckPlaylist();
            string = playlist == null ? " nullPL " : playlist.getTitle();
            System.out.println(n + ": " + string + ": " + item);
            playlistManager.placeNextOnDeck();
        }
    }

    public static void main(String[] stringArray) {
        PlaylistManager.test2();
    }
}

