/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.io.File;
import java.util.ArrayList;
import java.util.Iterator;

public class Playlist {
    private String prefix = "";
    private String title = "";
    private boolean shuffle = false;
    private ArrayList items = new ArrayList();
    private ArrayList shuffled = null;
    private int cursor;

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String string) {
        this.title = string;
    }

    public String getPrefix() {
        return this.prefix;
    }

    public void setPrefix(String string) {
        this.prefix = string;
    }

    public void setShuffle(boolean bl) {
        this.shuffle = bl;
        if (bl) {
            this.reshuffle();
        }
    }

    public void add(String string) {
        String string2 = this.prefix + string;
        this.items.add(new Item(this.prefix, string, string2));
        if (this.shuffle) {
            this.reshuffle();
        }
    }

    public void add(String string, String string2) {
        this.items.add(new Item(this.prefix, string, string2));
        if (this.shuffle) {
            this.reshuffle();
        }
    }

    public void add(Item item) {
        this.items.add(item);
        if (this.shuffle) {
            this.reshuffle();
        }
    }

    public ArrayList getItems() {
        ArrayList arrayList = this.shuffle ? this.shuffled : this.items;
        return arrayList;
    }

    public ArrayList getShuffledItems() {
        return this.shuffled;
    }

    public ArrayList getUnshuffledItems() {
        return this.items;
    }

    public void reset() {
        this.cursor = -1;
        if (this.shuffle) {
            this.reshuffle();
        }
    }

    public void resetToEnd() {
        this.cursor = this.items.size();
    }

    public int size() {
        return this.items.size();
    }

    public boolean hasNext() {
        return this.items.size() > 0 && this.cursor + 1 < this.items.size();
    }

    public boolean hasPrev() {
        return this.items.size() > 0 && this.cursor > 0;
    }

    public Item next() {
        Item item = null;
        if (this.hasNext()) {
            ++this.cursor;
            if (this.cursor < this.items.size()) {
                item = this.getNth(this.cursor);
            }
        }
        return item;
    }

    public Item prev() {
        Item item = null;
        if (this.hasPrev()) {
            --this.cursor;
            if (this.cursor >= 0) {
                item = this.getNth(this.cursor);
            }
        }
        return item;
    }

    public Item current() {
        return this.getNth(this.cursor);
    }

    public Item getNth(int n) {
        Item item = null;
        if (n >= 0 && n < this.items.size()) {
            item = this.shuffle ? (Item)this.shuffled.get(this.cursor) : (Item)this.items.get(this.cursor);
        }
        return item;
    }

    public Item setNth(int n) {
        Item item = null;
        if (n >= 0 && n < this.items.size()) {
            this.cursor = n;
            item = this.getNth(n);
        }
        return item;
    }

    public void setItem(Item item) {
        int n = this.findItem(item);
        if (n >= 0) {
            this.cursor = n;
        }
    }

    public void setItemByName(String string) {
        int n = this.findItemByName(string);
        if (n >= 0) {
            this.cursor = n;
        }
    }

    public void setItemByFull(String string) {
        int n = this.findItemByFull(string);
        if (n >= 0) {
            this.cursor = n;
        }
    }

    public int findItemByName(String string) {
        int n = 0;
        ArrayList arrayList = this.shuffle ? this.shuffled : this.items;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (item.getName().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findItemByFull(String string) {
        int n = 0;
        ArrayList arrayList = this.shuffle ? this.shuffled : this.items;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            if (item.getFull().equals(string)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public int findItem(Item item) {
        int n = 0;
        ArrayList arrayList = this.shuffle ? this.shuffled : this.items;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Item item2 = (Item)iterator.next();
            if (item2.equals(item)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    private void reshuffle() {
        this.shuffled = this.scramble(this.items);
    }

    private ArrayList scramble(ArrayList arrayList) {
        ArrayList arrayList2 = new ArrayList();
        Object object = arrayList.iterator();
        while (object.hasNext()) {
            arrayList2.add(object.next());
        }
        object = new ArrayList();
        int n = arrayList2.size();
        for (int i = 0; i < n; ++i) {
            int n2 = (int)((double)n * Math.random());
            Item item = (Item)arrayList2.get(n2);
            while (item == null) {
                if (++n2 >= n) {
                    n2 = 0;
                }
                item = (Item)arrayList2.get(n2);
            }
            ((ArrayList)object).add(item);
            arrayList2.set(n2, null);
        }
        return object;
    }

    public void print(StringBuffer stringBuffer, String string, boolean bl) {
        int n = 0;
        ArrayList arrayList = this.shuffle ? this.shuffled : this.items;
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            Item item = (Item)iterator.next();
            stringBuffer.append(string);
            if (bl && n == this.cursor) {
                stringBuffer.append("[");
                stringBuffer.append(item.getName());
                stringBuffer.append("]");
            } else {
                stringBuffer.append(item.getName());
            }
            stringBuffer.append("\n");
            ++n;
        }
    }

    public static String limitChars(String string, int n) {
        if (string.length() > n) {
            return string.substring(0, n);
        }
        return string;
    }

    public static String extractName(String string) {
        File file = new File(string);
        return file.getName();
    }

    class Item {
        private String prefix;
        private String name;
        private String full;
        private int lengthLimit = 12;

        public Item(String string, String string2, String string3) {
            this.prefix = string;
            this.name = string2;
            this.full = string3;
        }

        public String getName() {
            return this.name;
        }

        public String getFull() {
            return this.full;
        }

        public String getShortName() {
            return Playlist.limitChars(this.name, this.lengthLimit);
        }

        public String getShortName(int n) {
            return Playlist.limitChars(this.name, n);
        }

        public String toString() {
            return this.getShortName();
        }
    }
}

