/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import kepler.Action;
import kepler.Body;
import kepler.ChannelQueue;
import kepler.Kepler;
import kepler.Melody;
import kepler.MidiStuff;
import kepler.Note;
import kepler.NoteListener;
import kepler.Playable;
import kepler.Rock;
import kepler.Scale;
import kepler.Sequence;
import kepler.Vect;
import kepler.WorldBuilder;
import util.StdDraw;
import util.TokenReader;

public class Orrery
implements MouseListener,
MouseMotionListener {
    public static final int PLAYING_MODE = 0;
    public static final int INITIAL_CONDITIONS_MODE = 1;
    private int mode = 0;
    private WorldBuilder worldBuilder = null;
    private Kepler kepler = null;
    public double radius;
    public double bodyBaseRadius = 512.0;
    public int maxBodies = 25;
    public double maxMass = 0.0;
    public double minMass = -1.0;
    private String title = null;
    private int nbodies;
    private int nbodies_initial = 0;
    public int maxRocks = 10;
    private int nrocks;
    private int nrocks_initial = 0;
    private double friction = 0.99;
    private double minDistance;
    private List backgrounds;
    private double gravFactorBody = 1.0;
    private double repelFactorBody = 1.0;
    private double gravFactorRock = 1.0;
    private double repelFactorRock = 1.0;
    private int gridCircles = 0;
    private int gridRadii = 0;
    private boolean winkingOut = false;
    private String[][] doomsayersLaments = null;
    private String[] doomsayersLament;
    public static final long BEAT_TIME_NOW = -1L;
    private boolean beatLocked = false;
    private int bpm = 120;
    private int quantize = 8;
    private int signatureBeatNote = 4;
    private int signatureBeatsPerMeasure = 4;
    private int measureQuants;
    private int halfMeasureQuants;
    private int beatQuants;
    private long quantMs;
    private long beatMs;
    private long measureMs;
    private long t0_songStart;
    private float measureBump = 1.4f;
    private float halfMeasureBump = 1.2f;
    private float beatBump = 1.1f;
    private Body[] initialBodies;
    private Body[] bodies;
    private Rock[] initialRocks;
    private Rock[] rocks;
    private HashMap scales;
    private HashMap melodies;
    private HashMap sequences;
    private HashMap infos;
    private String[] infosArray;
    Vect[] forces;
    private int cycleTime = 60;
    public int creationDelay = 200;
    private int playTimeLo = 0;
    private int playTimeHi = 0;
    private int playCycles = -1;
    private int playCycles_keep = 0;
    public int numCycles = 0;
    public int debugLevel = 0;
    private boolean paused = false;
    private int displayInfo = 0;
    private float initialInfoDisplaySeconds = 0.0f;
    private boolean showHelpInfo = false;
    private List helpInfo = null;
    private boolean showBodyForces = false;
    private boolean showBodyForces_keep = false;
    private boolean showForceField = false;
    private boolean showForceField_keep = false;
    private int forceFieldGridVectors = 30;
    private boolean showVelocities = false;
    private boolean showVelocities_keep = false;
    public double velocityFactor = 3.141592;
    public double ctlVelocityFactor = 10.0;
    private MidiStuff midiStuff = null;
    public int defaultMidiVelocity_min = 25;
    public int defaultMidiVelocity_max = 100;
    public int numChannels = 16;
    public int[] midiVelocity_min = new int[this.numChannels];
    public int[] midiVelocity_max = new int[this.numChannels];
    public HashMap channelMap;
    public ChannelQueue[] channelQueues;
    public Color bgColor;
    public Color circleColor;
    public Color circleBorderColor;
    public Color gridColor;
    public Color gridColor2;
    public Color dbColor;
    public Color titleColor;
    public Color infoColor;
    public Color countdownColor;
    public Color forceColor;
    public Color squeegeeTabBG;
    public Color squeegeeTabFG;
    public Color controlPanelTitle;
    public Color controlPanelBG;
    public Color controlPanelBG2;
    public Color controlPanelBG3;
    public Color controlPanelFG;
    public Color buildBG;
    public Color playBG;
    public Color physicsBG;
    public Color musicBG;
    public Color controlPanelBorder;
    public Color controlPanelSubBorder;
    public Color controlPanelBorderHighlight;
    public Color controlPanelValueFG;
    public Color controlPanelValueBG;
    public Color controlPanelSelectedBG;
    public Color velocityColor;
    public Color highlightVelocityColor;
    protected TokenReader reader;
    public StdDraw drawer;
    protected double dt = 75.0;
    protected double local_dt = -1.0;
    protected int trails = 0;
    protected int trails_keep = 0;
    protected boolean muted = false;
    protected Component repaintComponent;
    private String worldFileName;
    private ArrayList noteListeners = null;
    public HashMap actions = new HashMap();
    double minForce = 0.0;
    double maxForce = 27.0;
    double normalizedVectorLength;
    double gridSize;
    Vect[][] forceVs;
    protected NumberFormat doublesFormat;
    protected NumberFormat eFormat;
    Rock dragRock = null;
    Body dragBody = null;
    Body selectedBody = null;
    boolean dragChangesMassOnSelectedBody = false;
    public boolean dragChangesVelocityOnSelectedBody = false;
    double selectedBodyOriginalMass = 0.0;
    double selectedBodyOriginalControlBoxDiagonal = 0.0;
    private int numDragPoints = 5;
    private Vect[] dragPoints = new Vect[this.numDragPoints];
    private double velocityDragFactor = 1.5;
    public boolean previewing = false;
    protected DrawingThread drawingThread = null;

    public Orrery(TokenReader tokenReader, StdDraw stdDraw) {
        this.init();
        this.reader = tokenReader;
        this.drawer = stdDraw;
        Body.drawer = stdDraw;
        Body.orrery = this;
        stdDraw.addMouseListener(this);
        stdDraw.addMouseMotionListener(this);
    }

    public Orrery() {
    }

    private void init() {
        this.initColors();
        this.setupMidiStuff();
        this.setupNumberFormats();
        this.setupDoomsayersLaments();
        this.scales = new HashMap();
        this.clearMelodies();
        this.clearInfos();
        this.channelQueues = new ChannelQueue[this.numChannels];
        this.channelMap = new HashMap();
        for (int i = 0; i < this.channelQueues.length; ++i) {
            this.channelQueues[i] = new ChannelQueue(3);
        }
        this.setForceFieldGridVectors(this.forceFieldGridVectors);
    }

    public void initColors() {
        this.bgColor = new Color(20, 18, 22);
        this.circleBorderColor = Color.getHSBColor(0.7f, 0.35f, 0.2f);
        this.circleColor = Color.getHSBColor(0.01234f, 0.2f, 0.08f);
        this.gridColor = Color.getHSBColor(0.74f, 0.4f, 0.5f);
        this.gridColor2 = Color.getHSBColor(0.95f, 0.5f, 0.3f);
        this.titleColor = new Color(72, 72, 159);
        this.infoColor = new Color(72, 72, 99);
        this.countdownColor = new Color(255, 200, 30);
        this.forceColor = Color.getHSBColor(0.74f, 0.5f, 0.3f);
        this.velocityColor = new Color(50, 50, 250);
        this.highlightVelocityColor = new Color(250, 50, 50);
        this.dbColor = Color.getHSBColor(0.0f, 0.8f, 1.0f);
        this.controlPanelTitle = new Color(102, 0, 0);
        this.controlPanelBG = this.bgColor;
        this.controlPanelBG2 = Color.getHSBColor(0.8f, 0.3f, 0.1f);
        this.controlPanelBG3 = new Color(26, 20, 19);
        this.physicsBG = this.playBG = new Color(15, 15, 35);
        this.musicBG = this.buildBG = new Color(15, 25, 12);
        this.controlPanelFG = new Color(72, 72, 109);
        this.controlPanelBorder = new Color(51, 51, 102);
        this.controlPanelSubBorder = new Color(35, 35, 72);
        this.controlPanelBorderHighlight = new Color(71, 71, 112);
        this.squeegeeTabFG = this.bgColor;
        this.squeegeeTabBG = this.controlPanelBorder;
        this.controlPanelValueFG = new Color(155, 60, 65);
        this.controlPanelValueBG = Color.getHSBColor(0.8f, 0.27f, 0.14f);
        this.controlPanelSelectedBG = Color.getHSBColor(0.8f, 0.27f, 0.25f);
    }

    public void initColors_tshirt() {
        this.bgColor = new Color(220, 220, 220);
        this.circleBorderColor = Color.getHSBColor(0.7f, 0.35f, 0.2f);
        this.circleColor = new Color(200, 200, 190);
        this.gridColor = Color.getHSBColor(0.74f, 0.4f, 0.5f);
        this.gridColor2 = Color.getHSBColor(0.95f, 0.5f, 0.3f);
        this.titleColor = new Color(72, 72, 159);
        this.infoColor = new Color(72, 72, 99);
        this.countdownColor = new Color(255, 200, 30);
        this.forceColor = Color.getHSBColor(0.74f, 0.5f, 0.3f);
        this.velocityColor = new Color(50, 50, 250);
        this.highlightVelocityColor = new Color(250, 50, 50);
        this.dbColor = Color.getHSBColor(0.0f, 0.8f, 1.0f);
        this.controlPanelTitle = new Color(102, 0, 0);
        this.controlPanelBG = this.bgColor;
        this.controlPanelBG2 = this.circleColor;
        this.controlPanelBG3 = this.circleColor;
        this.physicsBG = this.playBG = this.circleColor;
        this.musicBG = this.buildBG = this.circleColor;
        this.controlPanelFG = new Color(72, 72, 109);
        this.controlPanelBorder = new Color(51, 51, 102);
        this.controlPanelSubBorder = new Color(35, 35, 72);
        this.controlPanelBorderHighlight = new Color(71, 71, 112);
        this.squeegeeTabFG = this.bgColor;
        this.squeegeeTabBG = this.controlPanelBorder;
        this.controlPanelValueFG = new Color(155, 60, 65);
        this.controlPanelValueBG = this.circleColor;
        this.controlPanelSelectedBG = this.circleColor;
        this.initColors_bizcard();
    }

    public void initColors_bizcard() {
        Color color = new Color(20, 18, 22);
        Color color2 = new Color(55, 45, 62);
        Color color3 = new Color(250, 240, 255);
        this.bgColor = color;
        this.circleBorderColor = Color.getHSBColor(0.7f, 0.35f, 0.2f);
        this.circleColor = color2;
        this.gridColor = Color.getHSBColor(0.74f, 0.4f, 0.5f);
        this.gridColor2 = Color.getHSBColor(0.95f, 0.5f, 0.3f);
        this.titleColor = new Color(72, 72, 159);
        this.infoColor = new Color(72, 72, 99);
        this.countdownColor = new Color(255, 200, 30);
        this.forceColor = Color.getHSBColor(0.74f, 0.5f, 0.3f);
        this.velocityColor = new Color(50, 50, 250);
        this.highlightVelocityColor = new Color(250, 50, 50);
        this.dbColor = Color.getHSBColor(0.0f, 0.8f, 1.0f);
        this.controlPanelTitle = new Color(102, 0, 0);
        this.controlPanelBG = this.bgColor;
        this.controlPanelBG2 = color3;
        this.controlPanelBG3 = color3;
        this.physicsBG = this.playBG = color3;
        this.musicBG = this.buildBG = color3;
        this.controlPanelFG = new Color(72, 72, 109);
        this.controlPanelBorder = new Color(51, 51, 102);
        this.controlPanelSubBorder = new Color(35, 35, 72);
        this.controlPanelBorderHighlight = new Color(71, 71, 112);
        this.squeegeeTabFG = this.bgColor;
        this.squeegeeTabBG = this.controlPanelBorder;
        this.controlPanelValueFG = new Color(155, 60, 65);
        this.controlPanelValueBG = color3;
        this.controlPanelSelectedBG = color3;
    }

    public boolean isInitialConditionsMode() {
        return this.mode == 1;
    }

    public void playingMode() {
        if (this.mode == 0) {
            return;
        }
        this.playCycles = this.playCycles_keep;
        System.out.println("########################");
        System.out.println("  playing mode");
        this.mode = 0;
        this.selectedBody = null;
        this.setTrails(this.trails_keep);
        this.setShowForceField(this.showForceField_keep);
        this.setShowBodyForces(this.showBodyForces_keep);
        this.setShowVelocities(this.showVelocities_keep);
    }

    public void initialConditionsMode() {
        System.out.println("Orrery: entering initial conditions mode. mode: " + this.mode);
        if (this.mode == 1) {
            return;
        }
        this.mode = 1;
        this.selectedBody = null;
        this.playCycles_keep = this.playCycles;
        this.playCycles = 0;
        this.pause();
        this.trails_keep = this.trails;
        this.showBodyForces_keep = this.showBodyForces;
        this.showForceField_keep = this.showForceField;
        this.showVelocities_keep = this.showVelocities;
        this.setTrails(0);
        this.setShowBodyForces(false);
        this.setShowForceField(false);
        this.setShowVelocities(false);
        System.out.println("==============================");
        System.out.println("Entering initial conditions mode. maxMass: " + this.maxMass + " Body.maxMass: " + Body.maxMass + " minMass: " + this.minMass + " Body.minMass: " + Body.minMass);
        this.resetInitialMasses();
        this.redrawBackground();
        this.worldBuilderDraw();
    }

    public void resetInitialMasses() {
        int n;
        Body.setMaxMass(this.maxMass);
        Body.setMinMass(this.minMass);
        System.out.println("resetInitialMasses. nbodies_initial: " + this.nbodies_initial + " len(ib): " + this.initialBodies.length);
        for (n = 0; n < this.nbodies_initial; ++n) {
            this.initialBodies[n].setMinMaxMasses(this.initialBodies[n].mass);
        }
        for (n = 0; n < this.nrocks_initial; ++n) {
            this.initialRocks[n].setMinMaxMasses(this.initialRocks[n].mass);
        }
        for (n = 0; n < this.nrocks_initial; ++n) {
            this.initialRocks[n].massToSize(this.drawer);
        }
        for (n = 0; n < this.nbodies_initial; ++n) {
            this.initialBodies[n].massToSize(this.drawer);
        }
    }

    private void setupQuantization() {
        float f = this.signatureBeatsPerMeasure / this.signatureBeatNote;
        this.beatQuants = this.quantize / this.signatureBeatNote;
        this.measureQuants = this.beatQuants * this.signatureBeatsPerMeasure;
        this.beatMs = 1000000 * this.bpm / 60;
        this.quantMs = this.beatMs * (long)this.beatQuants;
        this.measureMs = this.beatMs * (long)this.signatureBeatsPerMeasure;
    }

    public void worldBuilderDraw() {
        this.drawer.clearbg(this.bgColor);
        if (this.mode == 1) {
            this.draw(this.initialBodies, this.initialRocks, this.nbodies_initial, this.nrocks_initial);
        } else {
            this.draw(this.bodies, this.rocks, this.nbodies, this.nrocks);
        }
        this.drawer.show(true);
        this.repaint();
    }

    public WorldBuilder getWorldBuilder() {
        return this.worldBuilder;
    }

    public void setWorldBuilder(WorldBuilder worldBuilder) {
        this.worldBuilder = worldBuilder;
    }

    public void setKepler(Kepler kepler) {
        this.kepler = kepler;
    }

    public void setupDrawing() {
        this.setDisplayInfoSeconds(this.initialInfoDisplaySeconds);
        this.drawer.show(true);
        this.repaint();
        if (this.debugLevel > 0) {
            System.out.println("Orrery.setUpDrawing -- complete. ");
        }
    }

    public void setupMidiStuff() {
        this.midiStuff = new MidiStuff(this);
    }

    public void setReboundMethod(int n) {
        Body.setReboundMethod(n);
    }

    public void setDt(double d) {
        this.dt = d;
    }

    public double getDt() {
        return this.dt;
    }

    public void setCycleTime(int n) {
        this.cycleTime = n;
    }

    public int getCycleTime() {
        return this.cycleTime;
    }

    public void setPlayTimes(int n, int n2) {
        this.playTimeLo = n;
        this.playTimeHi = n2;
    }

    public double getFriction() {
        return this.friction;
    }

    public void setFriction(double d) {
        this.friction = d;
        System.out.println("ORRERY.setFriction: " + d);
        Body.setFriction(d);
    }

    public double getGravityFactorBody() {
        return this.gravFactorBody;
    }

    public void setGravityFactorBody(double d) {
        System.out.println("Orrery.setGRAV BODY: " + d);
        this.gravFactorBody = d;
    }

    public double getGravityFactorRock() {
        return this.gravFactorRock;
    }

    public void setGravityFactorRock(double d) {
        System.out.println("Orrery.setGRAV ROCK: " + d);
        this.gravFactorRock = d;
    }

    public double getRepelFactorBody() {
        return this.repelFactorBody;
    }

    public void setRepelFactorBody(double d) {
        System.out.println("Orrery.setREPEL BODY: " + d);
        this.repelFactorBody = d;
    }

    public double getRepelFactorRock() {
        return this.repelFactorRock;
    }

    public void setRepelFactorRock(double d) {
        System.out.println("Orrery.setREPEL ROCK: " + d);
        this.repelFactorRock = d;
    }

    public double findAverageMass(Body[] bodyArray) {
        double d = 0.0;
        int n = 0;
        for (int i = 0; i < bodyArray.length; ++i) {
            if (bodyArray[i] == null) continue;
            d += bodyArray[i].mass;
            ++n;
        }
        if (n == 0) {
            return 0.0;
        }
        return d / (double)n;
    }

    public void possiblyResetPlayCycles() {
        if (this.playCycles_keep > 0) {
            this.playCycles = this.playCycles_keep;
        }
    }

    public void randomizePlayCycles() {
        if (this.playCycles != 0) {
            int n = Orrery.randomRange(this.playTimeLo, this.playTimeHi);
            this.playCycles_keep = this.playCycles = this.secondsToCycles(n);
        }
    }

    public int secondsToCycles(float f) {
        if (this.cycleTime > 0) {
            return (int)(1000.0 / (double)this.cycleTime * (double)f);
        }
        return (int)(100.0f * f);
    }

    public double cyclesToSeconds(int n) {
        if (this.cycleTime > 0) {
            return (double)this.cycleTime / 1000.0 * (double)n;
        }
        return (double)n / 100.0;
    }

    public int getDebugLevel() {
        return this.debugLevel;
    }

    public void setDebugLevel(int n) {
        this.debugLevel = n;
    }

    public int getTrails() {
        return this.trails;
    }

    public void setTrails(int n) {
        if (this.isInitialConditionsMode()) {
            this.trails_keep = n;
        } else {
            this.trails = n;
            this.drawer.setTrails(n);
        }
    }

    public void resetDefaults() {
        this.friction = 0.99;
        this.gravFactorBody = 1.0;
        this.repelFactorBody = 1.0;
        this.gravFactorRock = 1.0;
        this.repelFactorRock = 1.0;
        Body.resetDefaults();
        Rock.resetDefaults();
        this.title = "";
        this.backgrounds = new ArrayList();
        this.channelMap = new HashMap();
        this.local_dt = -1.0;
        this.minForce = 20.0;
        this.maxForce = 27.0;
        this.nrocks = 0;
        this.nrocks_initial = 0;
        this.nbodies = 0;
        this.nbodies_initial = 0;
        for (int i = 0; i < this.numChannels; ++i) {
            this.midiVelocity_min[i] = this.defaultMidiVelocity_min;
            this.midiVelocity_max[i] = this.defaultMidiVelocity_max;
        }
        this.setupQuantization();
    }

    public String getWorldFile() {
        return this.worldFileName;
    }

    public void setWorldFile(String string) {
        this.worldFileName = string;
    }

    public void clearWorld() {
        this.resetDefaults();
        Body.setFriction(this.friction);
    }

    public void readWorld() {
        this.readWorld(this.reader);
    }

    public Body[] getBodies() {
        return this.bodies;
    }

    public int getBodyCount() {
        return this.nbodies;
    }

    public Rock[] getRocks() {
        return this.rocks;
    }

    public int getRockCount() {
        return this.nrocks;
    }

    public Body[] getInitialBodies() {
        return this.initialBodies;
    }

    public int getInitialBodyCount() {
        return this.nbodies_initial;
    }

    public Rock[] getInitialRocks() {
        return this.initialRocks;
    }

    public int getInitialRockCount() {
        return this.nrocks_initial;
    }

    public void copyInitialBodies() {
        int n;
        Body.resetNth();
        Rock.resetNth();
        if (this.debugLevel > 0) {
            System.out.println("copyInitialBodies. nbodies_initial: " + this.nbodies_initial + " len(ib): " + this.initialBodies.length);
        }
        for (n = 0; n < this.nbodies_initial; ++n) {
            this.bodies[n] = this.initialBodies[n].duplicate();
            this.bodies[n].resetPlayable();
            this.bodies[n].setMinMaxMasses(this.bodies[n].mass);
        }
        this.nbodies = this.nbodies_initial;
        if (this.debugLevel > 0) {
            System.out.println("copying Initial rocks. nrocks_initial: " + this.nrocks_initial + " len(ir): " + this.initialRocks.length);
        }
        for (n = 0; n < this.nrocks_initial; ++n) {
            this.rocks[n] = (Rock)this.initialRocks[n].duplicate();
            this.rocks[n].resetPlayable();
        }
        this.nrocks = this.nrocks_initial;
        for (n = 0; n < this.nrocks; ++n) {
            this.rocks[n].massToSize(this.drawer);
        }
        for (n = 0; n < this.nbodies; ++n) {
            this.bodies[n].massToSize(this.drawer);
        }
    }

    public void setPlayable(Body body, String string, String string2, boolean bl) {
        if (string.equalsIgnoreCase("note")) {
            body.setPlayable(new Note(string2));
        } else if (string.equalsIgnoreCase("scale")) {
            body.setPlayable(this.getScale(string2));
        } else if (string.equals("melody")) {
            Melody melody;
            if (bl) {
                melody = this.getOrCreateMelody(string2);
                melody.setShared(true);
            } else {
                melody = this.cloneMelody(string2);
            }
            body.setPlayable(melody);
        } else if (string.equalsIgnoreCase("sequence")) {
            Playable playable;
            if (bl) {
                playable = this.getSequence(string2);
                playable.setShared(true);
            } else {
                playable = this.getSequence(string2).duplicate();
            }
            if (this.debugLevel > 0) {
                System.out.println("Setting sequence: " + string2);
            }
            body.setPlayable(playable);
        }
    }

    public void readWorld(TokenReader tokenReader) {
        this.clearMelodies();
        this.clearInfos();
        try {
            int n;
            this.readThings(tokenReader);
            if (this.debugLevel > 0) {
                System.out.println("MaxBodies:" + this.maxBodies);
            }
            this.forces = new Vect[this.maxBodies];
            for (n = 0; n < this.maxBodies; ++n) {
                this.forces[n] = new Vect();
            }
            for (n = 0; n < this.nrocks; ++n) {
                this.initialRocks[n].massToSize(this.drawer);
            }
            for (n = 0; n < this.nbodies; ++n) {
                this.initialBodies[n].massToSize(this.drawer);
            }
        }
        catch (Exception exception) {
            System.out.println("Caught exception: " + exception);
            exception.printStackTrace();
        }
    }

    public void readThings(TokenReader tokenReader) throws IOException {
        boolean bl = false;
        while (!bl) {
            String string = tokenReader.readToken();
            if (string == null) {
                bl = true;
                continue;
            }
            if (string.startsWith("@")) {
                String string2 = string.substring(1);
                String string3 = tokenReader.readLine();
                this.addInfo(string2, string3);
                continue;
            }
            if (string.equalsIgnoreCase("stop")) {
                bl = true;
                continue;
            }
            if (string.equalsIgnoreCase("background")) {
                String string4 = tokenReader.readToken();
                this.backgrounds.add(string4);
                this.drawBG(string4);
                this.drawer.initbg(this.bgColor);
                this.drawer.show(true);
                this.repaint();
                continue;
            }
            if (string.equalsIgnoreCase("drawbg")) {
                this.drawer.initbg(this.bgColor);
                this.drawer.show(true);
                this.repaint();
                continue;
            }
            if (string.equalsIgnoreCase("title")) {
                this.title = tokenReader.readLine().trim();
                continue;
            }
            if (string.equalsIgnoreCase("dt")) {
                this.local_dt = tokenReader.readDouble();
                continue;
            }
            if (string.equalsIgnoreCase("maxbodies")) {
                this.maxBodies = tokenReader.readInt();
                this.nbodies = 0;
                this.initialBodies = new Body[this.maxBodies + 1];
                this.bodies = new Body[this.maxBodies + 1];
                Body.setupCollisions(this.maxBodies * 4);
                continue;
            }
            if (string.equalsIgnoreCase("maxmass")) {
                double d = tokenReader.readDouble();
                if (this.debugLevel > 0) {
                    System.out.println("maxMass: " + d);
                }
                this.maxMass = d;
                Body.setMaxMass(d);
                continue;
            }
            if (string.equalsIgnoreCase("minmass")) {
                double d = tokenReader.readDouble();
                if (this.debugLevel > 0) {
                    System.out.println("minMass: " + d);
                }
                this.minMass = d;
                Body.setMinMass(d);
                continue;
            }
            if (string.equalsIgnoreCase("midi_velocity_min")) {
                int n = tokenReader.readInt();
                if (this.debugLevel > 0) {
                    System.out.println("midi velocity min: " + n);
                }
                for (int i = 0; i < this.numChannels; ++i) {
                    this.midiVelocity_min[i] = n;
                }
                continue;
            }
            if (string.equalsIgnoreCase("midi_velocity_max")) {
                int n = tokenReader.readInt();
                if (this.debugLevel > 0) {
                    System.out.println("midi velocity max: " + n);
                }
                for (int i = 0; i < this.numChannels; ++i) {
                    this.midiVelocity_max[i] = n;
                }
                continue;
            }
            if (string.equalsIgnoreCase("maxrocks")) {
                this.maxRocks = tokenReader.readInt();
                this.nrocks = 0;
                this.initialRocks = new Rock[this.maxRocks + 1];
                this.rocks = new Rock[this.maxRocks + 1];
                continue;
            }
            if (string.equalsIgnoreCase("radius")) {
                this.radius = tokenReader.readDouble();
                Body.setOrreryRadius(this.radius);
                this.drawer.setXscale(-this.radius, this.radius);
                this.drawer.setYscale(-this.radius, this.radius);
                this.drawer.postDisplayInit();
                this.minDistance = this.radius * 0.01;
                Body.setMinDistance(this.minDistance);
                this.resetForceFieldGridVectors();
                continue;
            }
            if (string.equalsIgnoreCase("baseradius")) {
                this.bodyBaseRadius = tokenReader.readDouble();
                Body.setBaseRadius(this.bodyBaseRadius);
                continue;
            }
            if (string.equalsIgnoreCase("friction")) {
                this.friction = tokenReader.readDouble();
                Body.setFriction(this.friction);
                continue;
            }
            if (string.equalsIgnoreCase("gridcircles")) {
                this.gridCircles = tokenReader.readInt();
                if (this.debugLevel <= 0) continue;
                System.out.println("  gridCircles: " + this.gridCircles);
                continue;
            }
            if (string.equalsIgnoreCase("gridradii")) {
                this.gridRadii = tokenReader.readInt();
                if (this.debugLevel <= 0) continue;
                System.out.println("  gridRadii: " + this.gridRadii);
                continue;
            }
            if (string.equalsIgnoreCase("channel")) {
                this.readChannel(tokenReader);
                continue;
            }
            if (string.equalsIgnoreCase("channel_queue")) {
                int n = tokenReader.readInt();
                int n2 = tokenReader.readInt();
                if (this.debugLevel > 0) {
                    System.out.println("Setting channel q(" + n + ").size() to " + n2);
                }
                this.channelQueues[n] = new ChannelQueue(n2);
                continue;
            }
            if (string.equalsIgnoreCase("end_channels")) {
                this.midiStuff.reloadPatchSet();
                continue;
            }
            if (string.equalsIgnoreCase("reboundmethod")) {
                String string5 = tokenReader.readToken();
                if (string5.equalsIgnoreCase("square")) {
                    this.setReboundMethod(1);
                } else if (string5.equalsIgnoreCase("none")) {
                    this.setReboundMethod(0);
                } else if (string5.equalsIgnoreCase("circle")) {
                    this.setReboundMethod(2);
                } else if (string5.equalsIgnoreCase("circlefake")) {
                    this.setReboundMethod(3);
                } else if (string5.equalsIgnoreCase("circlenotrap")) {
                    this.setReboundMethod(4);
                } else if (string5.equalsIgnoreCase("torus") || string5.equalsIgnoreCase("wrap")) {
                    this.setReboundMethod(5);
                }
                if (this.debugLevel <= 0) continue;
                System.out.println("  Rebound Method: " + string5);
                continue;
            }
            if (string.equalsIgnoreCase("gravFactor") || string.equalsIgnoreCase("gravityFactor")) {
                String string6 = tokenReader.readToken();
                if (string6.equalsIgnoreCase("body")) {
                    this.gravFactorBody = tokenReader.readDouble();
                    continue;
                }
                if (string6.equalsIgnoreCase("rock")) {
                    this.gravFactorRock = tokenReader.readDouble();
                    continue;
                }
                try {
                    double d;
                    this.gravFactorBody = d = Double.parseDouble(string6);
                    this.gravFactorRock = d;
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equalsIgnoreCase("repelFactor")) {
                String string7 = tokenReader.readToken();
                if (string7.equalsIgnoreCase("body")) {
                    this.repelFactorBody = tokenReader.readDouble();
                    continue;
                }
                if (string7.equalsIgnoreCase("rock")) {
                    this.repelFactorRock = tokenReader.readDouble();
                    if (this.debugLevel <= 0) continue;
                    System.out.println(" Repel Factor ROCK " + this.repelFactorRock);
                    continue;
                }
                try {
                    double d;
                    this.repelFactorBody = d = Double.parseDouble(string7);
                    this.repelFactorRock = d;
                }
                catch (Exception exception) {}
                continue;
            }
            if (string.equalsIgnoreCase("body")) {
                this.readBody(tokenReader);
                continue;
            }
            if (string.equalsIgnoreCase("rock")) {
                this.readRock(tokenReader);
                continue;
            }
            if (string.equalsIgnoreCase("scale")) {
                Scale scale = this.readScale(tokenReader);
                this.addScale(scale.getName(), scale);
                if (this.debugLevel <= 0) continue;
                System.out.println("Scale: " + scale);
                continue;
            }
            if (string.equalsIgnoreCase("melody")) {
                Melody melody = this.readMelody(tokenReader);
                this.addMelody(melody.getName(), melody);
                if (this.debugLevel <= 0) continue;
                System.out.println("Melody: " + melody);
                continue;
            }
            if (string.equalsIgnoreCase("sequence")) {
                Sequence sequence = this.readSequence(tokenReader);
                this.addSequence(sequence.getName(), sequence);
                if (this.debugLevel <= 0) continue;
                System.out.println("sequence: " + sequence);
                continue;
            }
            tokenReader.readLine();
        }
    }

    private void readChannel(TokenReader tokenReader) {
        try {
            int n = tokenReader.readInt();
            String string = tokenReader.readToken();
            this.channelMap.put(string, new Integer(n));
            this.channelMap.put("" + n, string);
            int n2 = tokenReader.readInt();
            int n3 = tokenReader.readInt();
            this.midiStuff.setPatch(n, n2, n3);
            String string2 = tokenReader.readToken();
            if (this.debugLevel > 0) {
                System.out.println("channel " + n + ": " + string + " b: " + n2 + " p: " + n3);
            }
            if (!"midi".equals(string2)) {
                tokenReader.pushToken();
            } else {
                int n4 = tokenReader.readInt();
                int n5 = tokenReader.readInt();
                if (n4 > 0) {
                    this.midiVelocity_min[n] = n4;
                }
                if (n5 > 0) {
                    this.midiVelocity_max[n] = n5;
                }
            }
        }
        catch (Exception exception) {
            System.out.println(" Caught exception reading Channel. " + exception);
            exception.printStackTrace();
            try {
                tokenReader.readLine();
            }
            catch (Exception exception2) {
                System.out.println(" Caught exception reading rest of line. " + exception);
                exception2.printStackTrace();
            }
        }
    }

    private Body readBody(TokenReader tokenReader) {
        try {
            double d;
            Body body = new Body();
            this.readCoords_pos(tokenReader, body);
            this.readCoords_v(tokenReader, body);
            body.mass = d = tokenReader.readDouble();
            if (this.debugLevel > 0) {
                System.out.println("BODY ");
            }
            body.init(this.maxBodies);
            this.addInitialBody(body);
            this.readBodyMods(tokenReader, body);
            return body;
        }
        catch (Exception exception) {
            System.out.println(" Caught exception reading Body. " + exception);
            exception.printStackTrace();
            try {
                tokenReader.readLine();
            }
            catch (Exception exception2) {
                System.out.println(" Caught exception reading rest of line. " + exception);
                exception2.printStackTrace();
            }
            return null;
        }
    }

    private Rock readRock(TokenReader tokenReader) {
        try {
            double d;
            Rock rock = new Rock();
            this.readCoords_pos(tokenReader, rock);
            rock.mass = d = tokenReader.readDouble();
            rock.init(this.maxRocks);
            if (this.debugLevel > 0) {
                System.out.println("ROCK ");
            }
            this.addInitialRock(rock);
            this.readBodyMods(tokenReader, rock);
            return rock;
        }
        catch (Exception exception) {
            System.out.println(" Caught exception reading Rock. " + exception);
            exception.printStackTrace();
            try {
                tokenReader.readLine();
            }
            catch (Exception exception2) {
                System.out.println(" Caught exception reading rest of line. " + exception);
                exception2.printStackTrace();
            }
            return null;
        }
    }

    public void writeWorld(String string) {
        this.writeWorld(new File(string));
    }

    public void writeWorld(File file) {
        try {
            StringBuffer stringBuffer = new StringBuffer(2048);
            this.writeWorld(stringBuffer);
            PrintStream printStream = new PrintStream(new FileOutputStream(file));
            printStream.println(stringBuffer);
            printStream.close();
        }
        catch (FileNotFoundException fileNotFoundException) {
            System.out.println("Orrery.writeWorld caught File not found exception. " + fileNotFoundException);
            fileNotFoundException.printStackTrace();
        }
    }

    public void writeWorld(StringBuffer stringBuffer) {
        this.writeWorldMetaData(stringBuffer);
        stringBuffer.append("drawbg");
        stringBuffer.append("\n");
        this.writeInstruments(stringBuffer);
        this.writeMelodies(stringBuffer);
        stringBuffer.append("\n");
        this.writeBodies(stringBuffer, this.initialBodies);
        stringBuffer.append("\n");
        this.writeBodies(stringBuffer, this.initialRocks);
    }

    public void writeAttribute(StringBuffer stringBuffer, String string, String string2) {
        if (string2 != null && string != null) {
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(string2);
            stringBuffer.append("\n");
        }
    }

    public void writeAttribute(StringBuffer stringBuffer, String string, String string2, String string3) {
        if (string2 != null && string != null && !string2.equals(string3)) {
            this.writeAttribute(stringBuffer, string, string2);
        }
    }

    public void writeAttribute(StringBuffer stringBuffer, String string, double d, double d2) {
        if (string != null && d != d2) {
            this.writeAttribute(stringBuffer, string, "" + d);
        }
    }

    public void writeAttribute(StringBuffer stringBuffer, String string, int n, int n2) {
        if (string != null && n != n2) {
            this.writeAttribute(stringBuffer, string, "" + n);
        }
    }

    public void writeWorldMetaData(StringBuffer stringBuffer) {
        this.writeInfos(stringBuffer);
        stringBuffer.append("# \n");
        stringBuffer.append("# Metadata\n");
        stringBuffer.append("# \n");
        this.writeAttribute(stringBuffer, "title", this.title);
        this.writeAttribute(stringBuffer, "maxbodies", this.maxBodies, -1);
        this.writeAttribute(stringBuffer, "maxrocks", this.maxRocks, -1);
        this.writeAttribute(stringBuffer, "radius", this.radius, 0.0);
        this.writeAttribute(stringBuffer, "friction", this.friction, 0.99);
        this.writeAttribute(stringBuffer, "maxmass", this.maxMass, 0.0);
        this.writeAttribute(stringBuffer, "minmass", this.minMass, -1.0);
        this.writeAttribute(stringBuffer, "baseradius", this.bodyBaseRadius, 512.0);
        this.writeAttribute(stringBuffer, "dt", this.local_dt, -1.0);
        this.writeAttribute(stringBuffer, "trails", this.trails, 0);
        this.writeAttribute(stringBuffer, "gridcircles", this.gridCircles, 0);
        this.writeAttribute(stringBuffer, "gridradii", this.gridRadii, 0);
        this.writeAttribute(stringBuffer, "reboundmethod", Body.reboundMethodString(Body.getReboundMethod()), Body.reboundMethodString(1));
        this.writeAttribute(stringBuffer, "midi_velocity_min", this.midiVelocity_min[0], this.defaultMidiVelocity_min);
        this.writeAttribute(stringBuffer, "midi_velocity_max", this.midiVelocity_max[0], this.defaultMidiVelocity_max);
        this.writeAttribute(stringBuffer, "gravityfactor body", this.gravFactorBody, 1.0);
        this.writeAttribute(stringBuffer, "repelfactor   body", this.repelFactorBody, 1.0);
        this.writeAttribute(stringBuffer, "gravityfactor rock", this.gravFactorRock, 1.0);
        this.writeAttribute(stringBuffer, "repelfactor   rock", this.repelFactorRock, 1.0);
        Iterator iterator = this.backgrounds.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.writeAttribute(stringBuffer, "background", string);
        }
        stringBuffer.append("\n");
    }

    public void writeInfos(StringBuffer stringBuffer) {
        if (this.infos.size() > 0) {
            stringBuffer.append("# \n");
            stringBuffer.append("# Infos\n");
            stringBuffer.append("# \n");
            Iterator iterator = this.infos.keySet().iterator();
            while (iterator.hasNext()) {
                String string = (String)iterator.next();
                List list = (List)this.infos.get(string);
                Iterator iterator2 = list.iterator();
                while (iterator2.hasNext()) {
                    stringBuffer.append("@");
                    stringBuffer.append(string);
                    stringBuffer.append(" ");
                    stringBuffer.append(iterator2.next());
                    stringBuffer.append("\n");
                }
            }
            stringBuffer.append("\n");
        }
    }

    public void writeInstruments(StringBuffer stringBuffer) {
        stringBuffer.append("# \n");
        stringBuffer.append("# Instruments\n");
        stringBuffer.append("# \n");
        int n = this.channelMap.size() / 2;
        for (int i = 0; i < n; ++i) {
            String string = (String)this.channelMap.get("" + i);
            int n2 = this.midiStuff.getPatchBank(i);
            int n3 = this.midiStuff.getPatchProgram(i);
            stringBuffer.append("channel ");
            stringBuffer.append(i);
            stringBuffer.append(" ");
            stringBuffer.append(string);
            stringBuffer.append(" ");
            stringBuffer.append(n2);
            stringBuffer.append(" ");
            stringBuffer.append(n3);
            stringBuffer.append("\n");
        }
        stringBuffer.append("end_channels\n");
        stringBuffer.append("\n");
    }

    public int getNumChannels() {
        int n = this.channelMap.size() / 2;
        return n;
    }

    public String getChannelName(int n) {
        return (String)this.channelMap.get("" + n);
    }

    public int getChannelBank(int n) {
        int n2 = this.midiStuff.getPatchBank(n);
        return n2;
    }

    public int getChannelProgram(int n) {
        int n2 = this.midiStuff.getPatchProgram(n);
        return n2;
    }

    public void setChannelInfo(int n, String string, int n2, int n3) {
        this.channelMap.put(string, new Integer(n));
        this.channelMap.put("" + n, string);
        this.midiStuff.setPatch(n, n2, n3);
    }

    public void reloadPatches() {
        this.midiStuff.reloadPatchSet();
    }

    public void writeMelodies(StringBuffer stringBuffer) {
        Playable playable;
        String string;
        Iterator iterator;
        stringBuffer.append("# \n");
        stringBuffer.append("# Melodies\n");
        stringBuffer.append("# \n");
        if (this.debugLevel > 0) {
            System.out.println("writeMelodies. ");
            System.out.println(" scales: " + (this.scales == null ? "<null>" : "" + this.scales.size()));
        }
        if (this.scales != null) {
            iterator = this.scales.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                playable = (Scale)this.scales.get(string);
                playable.write(stringBuffer);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
        if (this.debugLevel > 0) {
            System.out.println(" melodies: " + (this.melodies == null ? "<null>" : "" + this.melodies.size()));
        }
        if (this.melodies != null) {
            iterator = this.melodies.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                playable = (Melody)this.melodies.get(string);
                playable.write(stringBuffer);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
        if (this.debugLevel > 0) {
            System.out.println(" sequences: " + (this.sequences == null ? "<null>" : "" + this.sequences.size()));
        }
        if (this.sequences != null) {
            iterator = this.sequences.keySet().iterator();
            while (iterator.hasNext()) {
                string = (String)iterator.next();
                playable = (Sequence)this.sequences.get(string);
                playable.write(stringBuffer);
                stringBuffer.append("\n");
            }
            stringBuffer.append("\n");
        }
    }

    public void writeBodies(StringBuffer stringBuffer, Body[] bodyArray) {
        for (int i = 0; i < bodyArray.length; ++i) {
            Body body = bodyArray[i];
            if (body == null) continue;
            if (body instanceof Rock) {
                this.writeRock(stringBuffer, (Rock)body);
                continue;
            }
            this.writeBody(stringBuffer, body);
        }
    }

    public void writeRock(StringBuffer stringBuffer, Rock rock) {
        stringBuffer.append("rock ");
        Vect vect = rock.pos;
        if (rock.posOffset != null) {
            vect = vect.minus(rock.posOffset);
        }
        this.writeCoords(stringBuffer, vect, rock.posSpecifiedPolar);
        stringBuffer.append(rock.getMass());
        this.writeBodyMods(stringBuffer, rock);
        stringBuffer.append("\n");
    }

    public void writeBody(StringBuffer stringBuffer, Body body) {
        stringBuffer.append("body ");
        Vect vect = body.pos;
        if (body.posOffset != null) {
            vect = vect.minus(body.posOffset);
        }
        this.writeCoords(stringBuffer, vect, body.posSpecifiedPolar);
        this.writeCoords(stringBuffer, body.v, body.vSpecifiedPolar);
        stringBuffer.append(body.getMass());
        this.writeBodyMods(stringBuffer, body);
        stringBuffer.append("\n");
    }

    public void writeBodyMods(StringBuffer stringBuffer, Body body) {
        Playable playable;
        if (body.posOffset != null) {
            stringBuffer.append(" offset ");
            this.writeCoords(stringBuffer, body.posOffset, body.offsetSpecifiedPolar);
        }
        if (body.constrainMovesToRadius()) {
            stringBuffer.append(" constrain");
        }
        if (body.getRepelFactor() != 1.0) {
            stringBuffer.append(" repelfactor");
            stringBuffer.append(body.getRepelFactor());
        }
        if (body.getGravityFactor() != 1.0) {
            stringBuffer.append(" gravityfactor");
            stringBuffer.append(body.getGravityFactor());
        }
        if ((playable = body.getPlayable()) != null) {
            stringBuffer.append(" ");
            stringBuffer.append(playable.getType());
            stringBuffer.append(" ");
            if (playable.isShared()) {
                stringBuffer.append("shared ");
            }
            stringBuffer.append(playable.getName());
        }
        int n = body.getChannel();
        String string = (String)this.channelMap.get("" + n);
        if (string != null) {
            stringBuffer.append(" instrument");
            stringBuffer.append(" ");
            stringBuffer.append(string);
        } else if (body.getChannel() != 0) {
            stringBuffer.append(" channel");
            stringBuffer.append(body.getChannel());
        }
        this.writeMutations(stringBuffer, body);
        if (body instanceof Rock && ((Rock)body).move_theta > 0.0) {
            stringBuffer.append(" move_theta ");
            stringBuffer.append(((Rock)body).move_theta);
        }
    }

    private void writeMutations(StringBuffer stringBuffer, Body body) {
        if (body.is_mutator) {
            stringBuffer.append(" mutate");
            if (body.mutate_after > 0) {
                stringBuffer.append(" after ");
                stringBuffer.append(body.mutate_after);
            }
            if (body.mutate_clone) {
                stringBuffer.append(" clone ");
                stringBuffer.append(body.mutate_clone_chance);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_clone_lo);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_clone_hi);
            }
            if (body.mutate_killa) {
                stringBuffer.append(" killa ");
                stringBuffer.append(body.mutate_killa_chance);
            }
            if (body.mutate_blackhole) {
                stringBuffer.append(" blackhole ");
                stringBuffer.append(body.mutate_blackhole_chance);
            }
            if (body.mutate_mass_type == 1) {
                stringBuffer.append(" mass ");
                stringBuffer.append(body.mutate_mass_chance);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_mass_lo);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_mass_hi);
            }
            if (body.mutate_mass_type == 2) {
                stringBuffer.append(" mass% ");
                stringBuffer.append(body.mutate_mass_chance);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_mass_lo);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_mass_hi);
            }
            if (body.mutate_velocity_type == 3) {
                stringBuffer.append(" velocity% ");
                stringBuffer.append(body.mutate_velocity_chance);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_velocity_lo);
                stringBuffer.append(" ");
                stringBuffer.append(body.mutate_velocity_hi);
            }
            stringBuffer.append(" end");
        }
    }

    public void addInitialBody(Body body) {
        if (this.nbodies_initial < this.maxBodies) {
            this.initialBodies[this.nbodies_initial] = body;
            ++this.nbodies_initial;
            body.massToSize(this.drawer);
        }
    }

    public void addBody(Body body) {
        if (this.nbodies < this.maxBodies) {
            this.bodies[this.nbodies] = body;
            ++this.nbodies;
            body.massToSize(this.drawer);
        }
    }

    public void addInitialRock(Rock rock) {
        Rock.orrery = this;
        if (this.nrocks_initial < this.maxRocks) {
            this.initialRocks[this.nrocks_initial] = rock;
            ++this.nrocks_initial;
            rock.massToSize(this.drawer);
        }
    }

    public void addRock(Rock rock) {
        Rock.orrery = this;
        if (this.nrocks < this.maxRocks) {
            this.rocks[this.nrocks] = rock;
            ++this.nrocks;
            rock.massToSize(this.drawer);
        }
    }

    public void deleteBody(Body body) {
        int n = this.deleteBody(body, this.bodies);
        if (n != -1) {
            --this.nbodies;
        }
    }

    public void deleteInitialBody(Body body) {
        int n = this.deleteBody(body, this.initialBodies);
        if (n != -1) {
            --this.nbodies_initial;
        }
    }

    public void deleteRock(Rock rock) {
        int n = this.deleteBody(rock, this.rocks);
        if (n != -1) {
            --this.nrocks;
        }
    }

    public void deleteInitialRock(Rock rock) {
        int n = this.deleteBody(rock, this.initialRocks);
        if (n != -1) {
            --this.nrocks_initial;
        }
    }

    public int deleteBody(Body body, Body[] bodyArray) {
        int n;
        int n2 = -1;
        for (n = 0; n < bodyArray.length; ++n) {
            Body body2 = bodyArray[n];
            if (body2 == null || body2 != body) continue;
            n2 = n;
            break;
        }
        if (n2 != -1) {
            for (n = n2; n < bodyArray.length - 1; ++n) {
                bodyArray[n] = bodyArray[n + 1];
            }
            bodyArray[bodyArray.length - 1] = null;
        }
        return n2;
    }

    public void readCoords_pos(TokenReader tokenReader, Body body) throws IOException {
        Vect vect;
        String string = tokenReader.readToken();
        if (string.equalsIgnoreCase("polar")) {
            double d = tokenReader.readDouble();
            double d2 = tokenReader.readDouble();
            vect = Vect.createPolarDegrees(d, d2);
            body.posSpecifiedPolar = true;
        } else {
            double d = Double.parseDouble(string);
            double d3 = tokenReader.readDouble();
            vect = new Vect(d, d3);
            body.posSpecifiedPolar = false;
        }
        body.pos = vect;
    }

    public void readCoords_v(TokenReader tokenReader, Body body) throws IOException {
        Vect vect;
        String string = tokenReader.readToken();
        if (string.equalsIgnoreCase("polar")) {
            double d = tokenReader.readDouble();
            double d2 = tokenReader.readDouble();
            vect = Vect.createPolarDegrees(d, d2);
            body.vSpecifiedPolar = true;
        } else {
            double d = Double.parseDouble(string);
            double d3 = tokenReader.readDouble();
            vect = new Vect(d, d3);
            body.vSpecifiedPolar = false;
        }
        body.v = vect;
    }

    public void readCoords_offset(TokenReader tokenReader, Body body) throws IOException {
        Vect vect;
        String string = tokenReader.readToken();
        if (string.equalsIgnoreCase("polar")) {
            double d = tokenReader.readDouble();
            double d2 = tokenReader.readDouble();
            vect = Vect.createPolarDegrees(d, d2);
            body.offsetSpecifiedPolar = true;
        } else {
            double d = Double.parseDouble(string);
            double d3 = tokenReader.readDouble();
            vect = new Vect(d, d3);
        }
        body.posOffset = vect;
    }

    public void readBodyMods(TokenReader tokenReader, Body body) throws IOException {
        while (!tokenReader.atEol()) {
            int n;
            String string = tokenReader.readToken();
            if (this.debugLevel > 0) {
                System.out.println("      read mod: " + string + " atEol: " + tokenReader.atEol());
            }
            if (string == null) {
                tokenReader.readLine();
                continue;
            }
            if (string.equalsIgnoreCase("offset")) {
                this.readCoords_offset(tokenReader, body);
                body.pos.plusEquals(body.posOffset);
                continue;
            }
            if (string.equals("constrain")) {
                body.setConstrainMovesToRadius(true);
                if (this.debugLevel <= 0) continue;
                System.out.println("    Constrain");
                continue;
            }
            if (string.equalsIgnoreCase("repelfactor")) {
                double d = tokenReader.readDouble();
                body.setRepelFactor(d);
                if (this.debugLevel <= 0) continue;
                System.out.println("    repelFactor: " + d);
                continue;
            }
            if (string.equalsIgnoreCase("gravityfactor")) {
                double d = tokenReader.readDouble();
                body.setGravityFactor(d);
                if (this.debugLevel <= 0) continue;
                System.out.println("    gravityFactor: " + d);
                continue;
            }
            if (string.equalsIgnoreCase("note")) {
                String string2 = tokenReader.readToken();
                this.setPlayable(body, "note", string2, false);
                continue;
            }
            if (string.equalsIgnoreCase("scale")) {
                String string3 = tokenReader.readToken();
                this.setPlayable(body, "scale", string3, false);
                continue;
            }
            if (string.equalsIgnoreCase("melody")) {
                String string4 = tokenReader.readToken();
                n = 0;
                if (string4.equalsIgnoreCase("shared")) {
                    string4 = tokenReader.readToken();
                    n = 1;
                }
                this.setPlayable(body, "melody", string4, n != 0);
                continue;
            }
            if (string.equalsIgnoreCase("sequence")) {
                String string5 = tokenReader.readToken();
                n = 0;
                if (string5.equalsIgnoreCase("shared")) {
                    string5 = tokenReader.readToken();
                    n = 1;
                }
                this.setPlayable(body, "sequence", string5, n != 0);
                continue;
            }
            if (string.equals("channel") || string.equals("ch") || string.equalsIgnoreCase("inst") || string.equalsIgnoreCase("instrument")) {
                block19: {
                    String string6 = tokenReader.readToken();
                    n = 0;
                    try {
                        n = Integer.parseInt(string6);
                    }
                    catch (NumberFormatException numberFormatException) {
                        body.instrument = string6;
                        n = this.getInstrumentChannel(body.instrument);
                        if (n != -1) break block19;
                        n = 0;
                    }
                }
                body.setChannel(n);
                continue;
            }
            if (string.equalsIgnoreCase("action")) {
                Action action = this.readAction();
                this.addAction(action);
                continue;
            }
            if (string.equals("mutate")) {
                this.readMutations(tokenReader, body);
                continue;
            }
            if (string.equals("move_theta") && body instanceof Rock) {
                double d;
                ((Rock)body).move_theta = d = tokenReader.readDouble();
                continue;
            }
            if (this.debugLevel <= 0) continue;
            System.out.println("    other mod: " + string);
        }
    }

    public void writeCoords(StringBuffer stringBuffer, Vect vect, boolean bl) {
        if (bl) {
            stringBuffer.append("polar ");
            stringBuffer.append(vect.r());
            stringBuffer.append(" ");
            stringBuffer.append(vect.thetaDegrees());
            stringBuffer.append(" ");
        } else {
            stringBuffer.append(vect.x());
            stringBuffer.append(" ");
            stringBuffer.append(vect.y());
            stringBuffer.append(" ");
        }
    }

    public int getInstrumentChannel(String string) {
        Integer n = (Integer)this.channelMap.get(string);
        int n2 = -1;
        if (n != null) {
            n2 = n;
        }
        return n2;
    }

    private void readMutations(TokenReader tokenReader, Body body) throws IOException {
        String string = tokenReader.readToken();
        while (string != null && !string.equals("end")) {
            double d;
            double d2;
            int n;
            if (this.debugLevel > 0) {
                System.out.println("ReadMutations. " + string);
            }
            if (string.equals("after")) {
                n = tokenReader.readInt();
                body.mutate_after = this.secondsToCycles(n);
            } else if (string.equals("clone")) {
                n = tokenReader.readInt();
                d2 = tokenReader.readDouble();
                d = tokenReader.readDouble();
                body.is_mutator = true;
                body.mutate_clone = true;
                body.mutate_clone_chance = n;
                body.mutate_clone_lo = d2;
                body.mutate_clone_hi = d;
            } else if (string.equals("killa")) {
                n = tokenReader.readInt();
                body.is_mutator = true;
                body.mutate_killa = true;
                body.mutate_killa_chance = n;
            } else if (string.equals("blackhole")) {
                n = tokenReader.readInt();
                body.is_mutator = true;
                body.mutate_blackhole = true;
                body.mutate_blackhole_chance = n;
            } else {
                n = tokenReader.readInt();
                d2 = tokenReader.readDouble();
                d = tokenReader.readDouble();
                if (string.equals("mass")) {
                    body.is_mutator = true;
                    body.mutate_mass_type = 1;
                    body.mutate_mass_chance = n;
                    body.mutate_mass_lo = d2;
                    body.mutate_mass_hi = d;
                } else if (string.equals("mass%")) {
                    body.is_mutator = true;
                    body.mutate_mass_type = 2;
                    body.mutate_mass_chance = n;
                    body.mutate_mass_lo = d2;
                    body.mutate_mass_hi = d;
                } else if (string.equals("velocity") || string.equals("velocity%")) {
                    body.is_mutator = true;
                    body.mutate_velocity_type = 3;
                    body.mutate_velocity_chance = n;
                    body.mutate_velocity_lo = d2;
                    body.mutate_velocity_hi = d;
                }
            }
            string = tokenReader.readToken();
        }
    }

    private Action readAction() {
        return null;
    }

    public void addAction(Action action) {
        if (action != null) {
            this.actions.put(action.name, action);
        }
    }

    public Playable parsePlayable(String string, String string2, String string3) {
        Playable playable = null;
        try {
            TokenReader tokenReader = TokenReader.makeStringTokenReader(string2 + " " + string3);
            if (string.equals("scale")) {
                playable = this.readScale(tokenReader);
            } else if (string.equals("melody")) {
                playable = this.readMelody(tokenReader);
            } else if (string.equals("sequence")) {
                playable = this.readSequence(tokenReader);
            }
            tokenReader.close();
        }
        catch (Exception exception) {
            System.out.println("Orrery.parsePlayable got exception parsing playable(" + string + "): " + exception);
        }
        return playable;
    }

    public void storePlayable(Playable playable) {
        String string = playable.getType();
        String string2 = playable.getName();
        if (string.equals("scale")) {
            this.addScale(string2, (Scale)playable);
        } else if (string.equals("melody")) {
            this.addMelody(string2, (Melody)playable);
        } else if (string.equals("sequence")) {
            this.addSequence(string2, (Sequence)playable);
        }
    }

    public void removePlayable(Playable playable) {
        String string = playable.getType();
        String string2 = playable.getName();
        this.removePlayable(string, string2);
    }

    public void removePlayable(String string, String string2) {
        if (string.equals("scale")) {
            this.removeScale(string2);
        } else if (string.equals("melody")) {
            this.removeMelody(string2);
        } else if (string.equals("sequence")) {
            this.removeSequence(string2);
        }
    }

    private Scale readScale(TokenReader tokenReader) throws IOException {
        String string = tokenReader.readToken();
        Scale scale = new Scale(string);
        boolean bl = false;
        while (!bl) {
            String string2 = tokenReader.readToken();
            if (string2 == null || string2.equalsIgnoreCase("end")) {
                bl = true;
                continue;
            }
            scale.addNote(new Note(string2));
        }
        return scale;
    }

    private Melody readMelody(TokenReader tokenReader) throws IOException {
        Scale scale = this.readScale(tokenReader);
        Melody melody = new Melody(scale);
        return melody;
    }

    public void addScale(String string, Scale scale) {
        this.scales.put(string, scale);
    }

    public void removeScale(String string) {
        this.scales.put(string, null);
    }

    public void addMelody(String string, Melody melody) {
        this.melodies.put(string, melody);
    }

    public void removeMelody(String string) {
        this.melodies.put(string, null);
    }

    public Scale getScale(String string) {
        return (Scale)this.scales.get(string);
    }

    public Iterator getScaleNames() {
        return this.scales.keySet().iterator();
    }

    public Melody getOrCreateMelody(String string) {
        Melody melody = this.getMelody(string);
        if (melody != null) {
            return melody;
        }
        Scale scale = this.getScale(string);
        if (scale != null) {
            melody = new Melody(scale);
            this.melodies.put(string, melody);
        }
        return melody;
    }

    public Melody cloneMelody(String string) {
        Melody melody = this.getMelody(string);
        if (melody != null) {
            Melody melody2 = new Melody(melody.getScale());
            return melody2;
        }
        return null;
    }

    public Iterator getMelodyNames() {
        return this.melodies.keySet().iterator();
    }

    public Melody getMelody(String string) {
        return (Melody)this.melodies.get(string);
    }

    public void clearMelodies() {
        this.melodies = new HashMap();
        this.sequences = new HashMap();
    }

    public void clearInfos() {
        this.infos = new HashMap();
    }

    public void addInfo(String string, String string2) {
        ArrayList<String> arrayList = (ArrayList<String>)this.infos.get(string);
        if (arrayList == null) {
            arrayList = new ArrayList<String>();
        }
        arrayList.add(string2);
        this.infos.put(string, arrayList);
        this.resetInfosArray();
    }

    public List getInfo(String string) {
        return (List)this.infos.get(string);
    }

    public Iterator getInfoKeysIterator() {
        return this.infos.keySet().iterator();
    }

    private void resetInfosArray() {
        Object object;
        Object object2;
        int n = 0;
        Iterator iterator = this.getInfoKeysIterator();
        while (iterator.hasNext()) {
            object2 = (String)iterator.next();
            ++n;
            object = this.getInfo((String)object2);
            n += object.size();
        }
        int n2 = 0;
        if (this.title != null) {
            ++n;
        }
        this.infosArray = new String[n];
        if (this.title != null) {
            this.infosArray[n2] = this.title;
            ++n2;
        }
        object2 = this.getInfoKeysIterator();
        while (object2.hasNext()) {
            object = (String)object2.next();
            List list = this.getInfo((String)object);
            this.infosArray[n2] = object;
            ++n2;
            Iterator iterator2 = list.iterator();
            while (iterator2.hasNext()) {
                String string = (String)iterator2.next();
                this.infosArray[n2] = "    " + string;
                ++n2;
            }
        }
    }

    private Sequence readSequence(TokenReader tokenReader) throws IOException {
        String string = tokenReader.readToken();
        Sequence sequence = new Sequence(string);
        this.readSequenceMods(tokenReader, sequence);
        int n = sequence.timeType;
        boolean bl = false;
        while (!bl) {
            Playable playable = null;
            String string2 = tokenReader.readToken();
            if (string2.equalsIgnoreCase("end")) {
                bl = true;
                continue;
            }
            String string3 = tokenReader.readToken();
            String string4 = tokenReader.readToken();
            if (string2.equalsIgnoreCase("melody")) {
                playable = this.getOrCreateMelody(string3);
            } else if (string2.equalsIgnoreCase("sequence")) {
                playable = this.getSequence(string3).duplicate();
            } else if (string2.equalsIgnoreCase("scale")) {
                playable = this.getScale(string3);
            } else if (string2.equalsIgnoreCase("note")) {
                playable = new Note(string3);
            }
            int n2 = string4.equalsIgnoreCase("continue") ? -1 : Integer.parseInt(string4);
            if (playable == null) continue;
            sequence.add(playable, n2);
        }
        return sequence;
    }

    private void readSequenceMods(TokenReader tokenReader, Sequence sequence) throws IOException {
        String string = tokenReader.readToken();
        while (string != null && !string.equalsIgnoreCase("start")) {
            if (string.equalsIgnoreCase("timetype")) {
                String string2 = tokenReader.readToken();
                if (this.debugLevel > 0) {
                    System.out.println("  timetype: " + string2);
                }
                sequence.setTimeType(string2);
            }
            string = tokenReader.readToken();
        }
    }

    public Iterator getSequenceNames() {
        return this.sequences.keySet().iterator();
    }

    public Sequence getSequence(String string) {
        return (Sequence)this.sequences.get(string);
    }

    public void addSequence(String string, Sequence sequence) {
        this.sequences.put(string, sequence);
    }

    public void removeSequence(String string) {
        this.sequences.put(string, null);
    }

    public void clearSequences() {
        this.sequences = new HashMap();
    }

    public void increaseTime(double d) {
        int n;
        Body body;
        int n2;
        for (n2 = 0; n2 < this.nbodies; ++n2) {
            this.forces[n2].zero();
        }
        Body.resetCollisions();
        for (n2 = 0; n2 < this.nbodies; ++n2) {
            int n3;
            Body body2 = this.bodies[n2];
            if (body2 == null || !body2.alive) continue;
            for (n3 = 0; n3 < this.nbodies; ++n3) {
                body = this.bodies[n3];
                if (body == null || !body.alive || n2 == n3) continue;
                this.forces[n2].plusEquals(body.forceTo(body2, this.gravFactorBody, this.repelFactorBody, true));
            }
            for (n3 = 0; n3 < this.nrocks; ++n3) {
                body = this.rocks[n3];
                if (body == null || !((Rock)body).alive) continue;
                this.forces[n2].plusEquals(body.forceTo(body2, this.gravFactorRock, this.repelFactorRock, true));
            }
        }
        n2 = Body.getNumCollisions();
        if (n2 > 0) {
            for (int i = 0; i < n2; ++i) {
                Note note;
                Body[] bodyArray = Body.getCollision(i);
                body = bodyArray[0];
                Body body3 = bodyArray[1];
                body.highlight(5);
                body3.highlight(5);
                if (!body.isPlaying() && (note = this.playNote(body)) != null && !note.isRest()) {
                    body.setPlaying(10);
                }
                if (!body3.isPlaying() && (note = this.playNote(body3)) != null && !note.isRest()) {
                    body3.setPlaying(10);
                }
                body.maybeMutate(body3, this.numCycles);
                body3.maybeMutate(body, this.numCycles);
            }
        }
        for (n = 0; n < this.nbodies; ++n) {
            Body body4 = this.bodies[n];
            if (body4 == null || !body4.alive) continue;
            body4.move(this.forces[n], d, this.radius, this.radius);
        }
        for (n = 0; n < this.nrocks; ++n) {
            Rock rock = this.rocks[n];
            if (rock == null || !rock.alive) continue;
            rock.maybeMove();
        }
    }

    public void draw(Body[] bodyArray, Rock[] rockArray, int n, int n2) {
        Body body;
        int n3;
        if (this.displayInfo != 0) {
            this.drawDisplayInfo();
            if (this.displayInfo > 0) {
                --this.displayInfo;
            }
        }
        if (this.showHelpInfo && this.helpInfo != null) {
            this.drawHelpInfo();
        }
        if (this.showForceField) {
            this.drawForceField(bodyArray, rockArray);
        }
        for (n3 = 0; n3 < n2; ++n3) {
            body = rockArray[n3];
            if (body == null || !((Rock)body).alive) continue;
            ((Rock)body).draw(this.drawer);
        }
        for (n3 = 0; n3 < n; ++n3) {
            Vect vect;
            body = bodyArray[n3];
            if (body == null || !body.alive) continue;
            body.draw(this.drawer);
            if (this.showBodyForces) {
                vect = this.forces[n3];
                double d = vect.magnitude();
                if (d > 1.0) {
                    d = Math.log(d);
                }
                if ((d -= this.minForce) < 0.0) {
                    d = 0.0;
                }
                vect.unitEquals();
                vect.timesEquals(d);
                double d2 = this.maxForce - this.minForce;
                double d3 = this.normalizedVectorLength / d2;
                this.drawVect(this.drawer, body.pos.x, body.pos.y, vect, d3);
            }
            if (!this.showVelocities) continue;
            vect = body.v;
            Vect vect2 = vect.times(this.dt);
            this.drawer.setPenColor(this.velocityColor);
            this.drawVect(this.drawer, body.pos.x, body.pos.y, vect2, this.velocityFactor);
        }
        n3 = this.secondsLeft();
        if (n3 >= 0 && !this.winkingOut && n3 <= 5) {
            this.drawCountdown();
        }
        if (this.winkingOut) {
            this.drawDoomsayersLament();
        }
    }

    public void drawForceField(Body[] bodyArray, Rock[] rockArray) {
        int n = this.forceFieldGridVectors;
        double d = 1.0E14;
        Vect vect = new Vect();
        this.drawer.setPenColor(this.forceColor);
        for (int i = 0; i < n; ++i) {
            double d2 = (double)i * this.gridSize - this.radius;
            for (int j = 0; j < n; ++j) {
                Body body;
                int n2;
                double d3 = (double)j * this.gridSize - this.radius;
                this.forceVs[i][j].zero();
                Vect vect2 = new Vect(d3, d2);
                Body body2 = new Body(vect2, vect, d, 1);
                for (n2 = 0; n2 < this.nbodies; ++n2) {
                    body = bodyArray[n2];
                    if (body == null || !body.alive) continue;
                    this.forceVs[i][j].plusEquals(body.forceTo(body2, this.gravFactorBody, this.repelFactorBody, false));
                }
                for (n2 = 0; n2 < this.nrocks; ++n2) {
                    body = rockArray[n2];
                    if (body == null || !((Rock)body).alive) continue;
                    this.forceVs[i][j].plusEquals(body.forceTo(body2, this.gravFactorRock, this.repelFactorRock, false));
                }
            }
        }
        double d4 = 0.0;
        double d5 = 1.0E102;
        for (int i = 0; i < n; ++i) {
            for (int j = 0; j < n; ++j) {
                double d6 = this.forceVs[i][j].magnitude();
                if (d6 > 1.0) {
                    d6 = Math.log(d6);
                }
                if (d6 > d4) {
                    d4 = d6;
                }
                if (!(d6 < d5)) continue;
                d5 = d6;
            }
        }
        double d7 = 30.0;
        this.maxForce = this.maxForce * (d7 - 1.0) / d7;
        this.maxForce += d4 / d7;
        this.minForce = this.minForce * (d7 - 1.0) / d7;
        this.minForce += d5 / d7;
        double d8 = this.maxForce - this.minForce;
        double d9 = this.normalizedVectorLength / d8;
        for (int i = 0; i < n; ++i) {
            double d10 = (double)i * this.gridSize - this.radius;
            for (int j = 0; j < n; ++j) {
                double d11 = (double)j * this.gridSize - this.radius;
                Vect vect3 = this.forceVs[i][j];
                double d12 = vect3.magnitude();
                if (d12 != 0.0) {
                    d12 = Math.log(vect3.magnitude());
                }
                vect3.unitEquals();
                vect3.timesEquals(d12 -= this.minForce);
                this.drawVect(this.drawer, d11, d10, vect3, d9);
            }
        }
    }

    public void drawVect(StdDraw stdDraw, double d, double d2, Vect vect, double d3) {
        double d4 = d + vect.x * d3;
        double d5 = d2 + vect.y * d3;
        stdDraw.line(d, d2, d4, d5);
        stdDraw.circle(d4, d5, 150.0);
    }

    public void drawVectWithHandle(StdDraw stdDraw, double d, double d2, Vect vect, double d3, double d4) {
        double d5 = d + vect.x * d3;
        double d6 = d2 + vect.y * d3;
        stdDraw.line(d, d2, d5, d6);
        stdDraw.filledSquare(d5, d6, d4);
    }

    public void drawDisplayInfo() {
        double d = this.drawer.getLineHeight();
        double d2 = -0.995 * this.radius + (double)this.infosArray.length * d;
        this.drawer.set_text_point(-0.98 * this.radius, d2);
        this.drawer.setPenColor(this.infoColor);
        for (int i = 0; i < this.infosArray.length; ++i) {
            this.drawer.text_line(this.infosArray[i]);
            this.drawer.next_line();
        }
    }

    public void drawCountdown() {
        this.drawer.set_text_point(0.45 * this.radius, 0.97 * this.radius);
        this.drawer.next_line();
        this.drawer.setPenColor(this.countdownColor);
        int n = this.secondsLeft();
        this.drawer.text_line("World ends in " + n + " seconds.");
    }

    public void drawDoomsayersLament() {
        this.drawer.set_text_point(0.45 * this.radius, 0.97 * this.radius);
        if (this.doomsayersLament != null) {
            this.drawer.setPenColor(this.countdownColor);
            for (int i = 0; i < this.doomsayersLament.length; ++i) {
                this.drawer.next_line();
                this.drawer.text_line(this.doomsayersLament[i]);
            }
        }
    }

    public void chooseRandomDoomsayersLament() {
        if (this.doomsayersLaments == null) {
            this.setupDoomsayersLaments();
        }
        this.doomsayersLament = this.doomsayersLaments[(int)((double)this.doomsayersLaments.length * Math.random())];
    }

    private void setupDoomsayersLaments() {
        this.doomsayersLaments = new String[][]{{"...and one by one, ", "   the stars started to wink out."}, {"It's the end of the world", "as we know it."}, {"...and I feel fine."}, {"The end is nigh!"}};
    }

    public void drawBodyStats(Body body) {
        this.drawer.set_text_point(-0.97 * this.radius, -0.9 * this.radius);
        this.drawer.text_line("Mass: " + this.numFormat(body.mass));
        this.drawer.next_line();
        String string = body.posSpecifiedPolar ? "Pos:  {r: " + this.numFormat(body.pos.r()) + ", theta: " + this.numFormat(body.pos.thetaDegrees()) + "}" : "Pos:  {X: " + this.numFormat(body.pos.x) + ", Y: " + this.numFormat(body.pos.y) + "}";
        this.drawer.text_line(string);
        this.drawer.next_line();
        if (!(body instanceof Rock)) {
            String string2 = body.vSpecifiedPolar ? "Vel:  {r: " + this.numFormat(body.v.r()) + ", theta: " + this.numFormat(body.v.thetaDegrees()) + "}" : "Vel:  {X: " + this.numFormat(body.v.x) + ", Y: " + this.numFormat(body.v.y) + "}";
            this.drawer.text_line(string2);
        }
    }

    private void setupNumberFormats() {
        this.doublesFormat = NumberFormat.getInstance();
        this.doublesFormat.setMaximumFractionDigits(4);
        this.doublesFormat.setGroupingUsed(false);
        this.eFormat = (DecimalFormat)NumberFormat.getInstance();
        ((DecimalFormat)this.eFormat).applyPattern("0.####E0");
    }

    public String numFormat(double d) {
        if (d > 1000000.0) {
            return this.eFormat.format(d);
        }
        return this.doublesFormat.format(d);
    }

    public int secondsLeft() {
        if (this.playCycles <= 0) {
            return -1;
        }
        int n = this.playCycles - this.numCycles;
        return (int)this.cyclesToSeconds(n);
    }

    public void drawHelpInfo() {
        this.drawer.set_text_point(-0.98 * this.radius, 0.0);
        this.drawer.setPenColor(this.titleColor);
        Iterator iterator = this.helpInfo.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            this.drawer.text_line("   " + string);
            this.drawer.next_line();
        }
    }

    public void redrawBackground() {
        this.drawer.clearbg(this.bgColor);
        this.drawer.initbg(this.bgColor);
        this.drawer.show(true);
        this.repaint();
    }

    public void draw_slowly(int n) {
        Body body;
        int n2;
        if (this.displayInfo != 0) {
            this.drawDisplayInfo();
        }
        if (this.showForceField) {
            this.drawForceField(this.bodies, this.rocks);
        }
        for (n2 = 0; n2 < this.nrocks; ++n2) {
            body = this.rocks[n2];
            if (body == null) continue;
            ((Rock)body).draw(this.drawer);
            this.drawer.show(n / 4);
            this.repaint();
        }
        for (n2 = 0; n2 < this.nbodies; ++n2) {
            body = this.bodies[n2];
            if (body == null) continue;
            body.draw(this.drawer);
            this.drawer.show(n);
            this.repaint();
        }
    }

    public void clearBG() {
        this.drawBG_blank();
    }

    public void drawBG(String string) {
        if (string.equals("radar")) {
            this.drawBG_radar();
        } else if (string.equals("square")) {
            this.drawBG_square();
        } else if (string.equals("circle")) {
            this.drawBG_circle();
        } else if (string.equals("stars")) {
            this.drawBG_stars();
        } else if (string.equals("starclusters") || string.equals("starclusters_circle")) {
            this.drawStarClusters(50, 55, 35000.0);
        } else if (string.equals("starclusters_square")) {
            this.drawStarClusters_square(45, 55, 35000.0);
        } else if (string.equals("none") || string.equals("blank") || string.equals("clear")) {
            this.drawBG_blank();
        } else {
            this.drawBG_radar();
        }
        this.drawTitle_bg();
    }

    private void drawTitle_bg() {
        if (this.title != null) {
            this.drawer.setPenColor_bg(this.titleColor);
            this.drawer.text_bg(-0.98 * this.radius, 0.97 * this.radius, this.title);
        }
    }

    private void drawTitle_fg() {
        if (this.title != null) {
            this.drawer.setPenColor(this.titleColor);
            this.drawer.text(-0.98 * this.radius, 0.97 * this.radius, this.title);
        }
    }

    public void drawBG_radar() {
        this.drawBG_circle();
        this.drawgrid();
    }

    public void drawBG_stars() {
        this.drawStars();
    }

    public void drawBG_blank() {
        this.drawer.setPenColor_bg(this.bgColor);
        this.drawer.filledSquare_bg(0.0, 0.0, this.radius * 1.15);
    }

    public void drawBG_circle() {
        this.drawer.setPenColor_bg(this.circleColor);
        this.drawer.filledCircle_bg(0.0, 0.0, this.radius * 1.02);
        this.drawer.setPenColor_bg(this.circleBorderColor);
        this.drawer.setPenRadius_bg(0.005);
        this.drawer.circle_bg(0.0, 0.0, this.radius * 1.02);
    }

    public void drawBG_square() {
        this.drawer.setPenColor_bg(this.circleColor);
        this.drawer.filledSquare_bg(0.0, 0.0, this.radius * 1.02);
        this.drawer.setPenRadius_bg(0.015);
        this.drawer.setPenColor_bg(this.circleBorderColor);
        this.drawer.square_bg(0.0, 0.0, this.radius * 1.02);
    }

    public void drawStars() {
        int n = (int)Orrery.randomRange(175.0, 550.0);
        for (int i = 0; i < n; ++i) {
            double d = Orrery.randomRange(-1.0 * this.radius, this.radius);
            double d2 = Orrery.randomRange(-1.0 * this.radius, this.radius);
            this.drawRandomStar(d, d2, 40.0, 250.0);
        }
    }

    public void drawStarClusters(int n, int n2, double d) {
        int n3 = Orrery.randomRange(5, n);
        for (int i = 0; i < n3; ++i) {
            int n4 = Orrery.randomRange(n2 / 4, n2);
            double d2 = Orrery.randomRange(0.0, d);
            double d3 = Orrery.randomRange(d2, this.radius);
            double d4 = Orrery.randomRange(0.0, 360.0);
            Vect vect = Vect.createPolarDegrees(d3, d4);
            this.drawStarCluster(vect, d2, n4);
        }
    }

    public void drawStarClusters_square(int n, int n2, double d) {
        int n3 = Orrery.randomRange(5, n);
        for (int i = 0; i < n3; ++i) {
            int n4 = Orrery.randomRange(n2 / 4, n2);
            double d2 = Orrery.randomRange(0.0, d);
            double d3 = Orrery.randomRange(-1.0 * this.radius, this.radius);
            double d4 = Orrery.randomRange(-1.0 * this.radius, this.radius);
            Vect vect = new Vect(d3, d4);
            this.drawStarCluster(vect, d2, n4);
        }
    }

    public void drawStarCluster(Vect vect, double d, int n) {
        for (int i = 0; i < n; ++i) {
            double d2 = Orrery.randomRange(0.0, d);
            double d3 = Orrery.randomRange(0.0, 360.0);
            Vect vect2 = Vect.createPolar(d2, d3);
            vect2.plusEquals(vect);
            double d4 = vect2.x();
            double d5 = vect2.y();
            this.drawRandomStar(d4, d5, 20.0, 200.0);
        }
    }

    public void drawRandomStar(double d, double d2, double d3, double d4) {
        double d5 = Orrery.randomRange(d3, d4);
        float f = Orrery.randomRange(0.0f, 0.7f);
        float f2 = Orrery.randomRange(0.0f, 0.25f);
        float f3 = Orrery.randomRange(0.0f, 1.0f);
        Color color = Color.getHSBColor(f3, f2, f);
        this.drawer.setPenColor_bg(color);
        this.drawer.filledCircle_bg(d, d2, d5);
    }

    public void drawgrid() {
        int n;
        double d = this.radius * 1.02;
        this.drawer.setPenColor_bg(this.gridColor);
        this.drawer.setPenRadius_bg(0.001);
        for (n = 0; n < this.gridCircles; ++n) {
            this.drawer.circle_bg(0.0, 0.0, (double)n * d / (double)this.gridCircles);
        }
        for (n = 0; n < this.gridRadii; ++n) {
            double d2 = (double)n * 2.0 * Math.PI / (double)this.gridRadii;
            Vect vect = Vect.createPolar(d, d2);
            this.drawer.line_bg(0.0, 0.0, vect.x(), vect.y());
        }
    }

    private void resetDragPoints(Body body) {
        for (int i = 0; i < this.numDragPoints; ++i) {
            this.dragPoints[i] = body.pos;
        }
    }

    private void addDragPoint(double d, double d2) {
        for (int i = this.numDragPoints - 1; i > 0; --i) {
            this.dragPoints[i] = this.dragPoints[i - 1];
        }
        this.dragPoints[0] = new Vect(d, d2);
    }

    private Vect getDragVelocity() {
        Vect vect = new Vect(0.0, 0.0);
        for (int i = 0; i < this.numDragPoints - 1; ++i) {
            Vect vect2 = this.dragPoints[i].minus(this.dragPoints[i + 1]);
            vect.plusEquals(vect2);
        }
        vect.timesEquals(1.0 / (double)(this.numDragPoints - 1));
        vect.timesEquals(this.velocityDragFactor / this.dt);
        return vect;
    }

    public void selectBody(Body body) {
        this.selectedBody = body;
        if (body != null) {
            this.selectedBodyOriginalMass = body.mass;
            this.selectedBodyOriginalControlBoxDiagonal = this.selectedBody.getControlBoxWidth() * Math.sqrt(2.0);
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        this.resetPlayTimer();
        if (this.mode == 1) {
            this.mousePressed_InitialConditionsMode(mouseEvent);
        } else {
            this.mousePressed_PlayMode(mouseEvent);
        }
    }

    public void mousePressed_InitialConditionsMode(MouseEvent mouseEvent) {
        int n;
        if (this.worldBuilder == null) {
            return;
        }
        if (this.debugLevel > 0) {
            System.out.println("Bing! [INITCOND]");
        }
        this.worldBuilder.setMousePressedTime(System.currentTimeMillis());
        double d = this.drawer.mouseX();
        double d2 = this.drawer.mouseY();
        if (mouseEvent.isControlDown() && mouseEvent.isAltDown()) {
            this.worldBuilder.controlAltMousePressed(d, d2);
            return;
        }
        if (mouseEvent.isControlDown()) {
            this.worldBuilder.controlMousePressed(d, d2);
            return;
        }
        if (mouseEvent.isMetaDown()) {
            this.worldBuilder.metaMousePressed(d, d2);
            return;
        }
        if (mouseEvent.isAltDown()) {
            this.worldBuilder.altMousePressed(d, d2);
            return;
        }
        if (mouseEvent.isShiftDown()) {
            this.worldBuilder.shiftMousePressed(d, d2);
        }
        if (this.paused && this.selectedBody != null) {
            if (this.closeToVelocityVector(this.selectedBody, d, d2)) {
                this.dragChangesVelocityOnSelectedBody = true;
                this.worldBuilderDraw();
                return;
            }
            if (this.closeToControlHandle(this.selectedBody, d, d2)) {
                this.dragChangesMassOnSelectedBody = true;
                this.selectedBody.highlightControlBox(true);
                this.selectedBodyOriginalMass = this.selectedBody.mass;
                this.selectedBodyOriginalControlBoxDiagonal = this.selectedBody.getControlBoxWidth() * Math.sqrt(2.0);
                this.worldBuilderDraw();
                return;
            }
        }
        if ((n = this.findRockIndex(d, d2, this.initialRocks, this.nrocks_initial)) >= 0) {
            Rock rock;
            this.dragRock = rock = this.initialRocks[n];
            this.dragRock.select(-1);
            this.worldBuilder.selectRock(this.dragRock, n);
            this.worldBuilderDraw();
        } else {
            n = this.findBodyIndex(d, d2, this.initialBodies, this.nbodies_initial);
            if (n >= 0) {
                Body body = this.initialBodies[n];
                if (this.debugLevel > 0) {
                    System.out.println("WB: [INIT] FOUND Body[" + n + "]" + body);
                }
                this.dragBody = body;
                this.dragBody.select(-1);
                this.worldBuilder.selectBody(this.dragBody, n);
                this.worldBuilderDraw();
            } else {
                if (this.debugLevel > 0) {
                    System.out.println("MISSED");
                }
                this.worldBuilder.unselect();
                this.worldBuilderDraw();
            }
        }
    }

    public void mousePressed_PlayMode(MouseEvent mouseEvent) {
        int n;
        if (this.debugLevel > 0) {
            System.out.println("Bing!");
        }
        double d = this.drawer.mouseX();
        double d2 = this.drawer.mouseY();
        if (this.paused && this.selectedBody != null) {
            if (this.closeToVelocityVector(this.selectedBody, d, d2)) {
                this.dragChangesVelocityOnSelectedBody = true;
                this.redraw();
                return;
            }
            if (this.closeToControlHandle(this.selectedBody, d, d2)) {
                this.dragChangesMassOnSelectedBody = true;
                this.selectedBody.highlightControlBox(true);
                this.selectedBodyOriginalMass = this.selectedBody.mass;
                this.selectedBodyOriginalControlBoxDiagonal = this.selectedBody.getControlBoxWidth() * Math.sqrt(2.0);
                this.redraw();
                return;
            }
        }
        if ((n = this.findRockIndex(d, d2, this.rocks, this.nrocks)) >= 0) {
            Rock rock = this.rocks[n];
            if (this.debugLevel > 0) {
                int n2;
                System.out.println("WB: FOUND Rock");
                System.out.print("      Rocks: [");
                for (n2 = 0; n2 < this.nrocks; ++n2) {
                    System.out.print(this.rocks[n2] + "{" + this.rocks[n2].pos + "} ");
                }
                System.out.println("]");
                System.out.print("      INITRocks: [");
                for (n2 = 0; n2 < this.nrocks_initial; ++n2) {
                    System.out.print(this.initialRocks[n2] + "{" + this.initialRocks[n2].pos + "} ");
                }
                System.out.println("]");
            }
            this.dragRock = rock;
            this.dragRock.select(-1);
            this.worldBuilder.selectRock(this.dragRock, n);
        } else {
            n = this.findBodyIndex(d, d2, this.bodies, this.nbodies);
            if (n >= 0) {
                Body body = this.bodies[n];
                if (body != null && body.alive) {
                    if (this.debugLevel > 0) {
                        System.out.println("FOUND Body");
                    }
                    body.select(-1);
                    this.dragBody = body;
                    this.resetDragPoints(body);
                    this.worldBuilder.selectBody(this.dragBody, n);
                    this.redraw();
                } else {
                    if (this.debugLevel > 0) {
                        System.out.println("HIT DEAD BODY!");
                    }
                    this.worldBuilder.unselect();
                    this.redraw();
                }
            } else {
                if (this.debugLevel > 0) {
                    System.out.println("MISSED");
                }
                this.worldBuilder.unselect();
                this.redraw();
            }
        }
    }

    public void mouseClicked(MouseEvent mouseEvent) {
    }

    public void mouseEntered(MouseEvent mouseEvent) {
    }

    public void mouseExited(MouseEvent mouseEvent) {
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        this.resetPlayTimer();
        this.dragRock = null;
        this.dragBody = null;
        this.dragChangesMassOnSelectedBody = false;
        this.dragChangesVelocityOnSelectedBody = false;
        if (this.selectedBody != null) {
            this.selectedBody.highlightControlBox(false);
        }
        if (this.paused) {
            if (this.mode == 1) {
                this.worldBuilderDraw();
                this.worldBuilder.updateSelected();
            } else {
                this.redraw();
            }
        } else if (this.selectedBody != null && this.mode == 0 && !(this.selectedBody instanceof Rock)) {
            Vect vect = this.getDragVelocity();
            this.selectedBody.setV(vect);
        }
    }

    public void mouseMoved(MouseEvent mouseEvent) {
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.mode == 1) {
            this.mouseDragged_InitialConditionsMode(mouseEvent);
        } else {
            this.mouseDragged_PlayMode(mouseEvent);
        }
    }

    public void mouseDragged_PlayMode(MouseEvent mouseEvent) {
        if (this.drawer.mousePressed()) {
            double d = this.drawer.mouseX();
            double d2 = this.drawer.mouseY();
            if (this.dragChangesVelocityOnSelectedBody && this.selectedBody != null) {
                double d3 = d - this.selectedBody.pos.x();
                double d4 = d2 - this.selectedBody.pos.y();
                double d5 = this.ctlVelocityFactor * this.dt;
                this.selectedBody.v.setX(d3 / d5);
                this.selectedBody.v.setY(d4 / d5);
                this.redraw();
                return;
            }
            if (this.dragChangesMassOnSelectedBody && this.selectedBody != null) {
                double d6 = d - this.selectedBody.pos.x();
                double d7 = d2 - this.selectedBody.pos.y();
                double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                double d9 = d8 / this.selectedBodyOriginalControlBoxDiagonal;
                double d10 = this.selectedBodyOriginalMass * d9;
                if (Body.massToSizeMethod != 0 && Body.massToSizeMethod == 1) {
                    double d11 = 0.3333333333333333;
                    double d12 = Math.pow(this.selectedBodyOriginalMass, d11);
                    double d13 = d12 * d9;
                    d10 = d13 * d13 * d13;
                }
                this.selectedBody.setMass(d10);
                this.redraw();
                return;
            }
            if (this.dragRock != null) {
                if (this.dragRock.constrainMovesToRadius()) {
                    this.dragRock.moveto_constrainRadius(d, d2);
                } else {
                    this.dragRock.moveto(d, d2);
                    if (this.paused) {
                        this.redraw();
                    }
                }
            } else if (this.dragBody != null) {
                this.dragBody.moveto(d, d2);
                if (this.paused) {
                    this.redraw();
                } else {
                    if (this.debugLevel > 0) {
                        System.out.println("AddDragPoint: (" + d + ", " + d2 + ")");
                    }
                    this.addDragPoint(d, d2);
                }
            }
        }
    }

    public void mouseDragged_InitialConditionsMode(MouseEvent mouseEvent) {
        if (this.drawer.mousePressed()) {
            double d = this.drawer.mouseX();
            double d2 = this.drawer.mouseY();
            if (this.dragChangesVelocityOnSelectedBody && this.selectedBody != null) {
                double d3 = d - this.selectedBody.pos.x();
                double d4 = d2 - this.selectedBody.pos.y();
                double d5 = this.ctlVelocityFactor * this.dt;
                this.selectedBody.v.setX(d3 / d5);
                this.selectedBody.v.setY(d4 / d5);
                this.worldBuilderDraw();
                return;
            }
            if (this.dragChangesMassOnSelectedBody && this.selectedBody != null) {
                double d6 = d - this.selectedBody.pos.x();
                double d7 = d2 - this.selectedBody.pos.y();
                double d8 = Math.sqrt(d6 * d6 + d7 * d7);
                double d9 = d8 / this.selectedBodyOriginalControlBoxDiagonal;
                System.out.println("HANDLEDRAG dist: " + d8);
                this.selectedBody.setMass(this.selectedBodyOriginalMass * d9);
                this.worldBuilderDraw();
                return;
            }
            if (this.worldBuilder != null) {
                this.worldBuilder.mouseDragged(d, d2);
            }
        }
    }

    public int findRockIndex(double d, double d2, Rock[] rockArray, int n) {
        for (int i = 0; i < n; ++i) {
            Rock rock = rockArray[i];
            if (rock == null || !rock.intersects(d, d2, 1.5)) continue;
            return i;
        }
        return -1;
    }

    public int findBodyIndex(double d, double d2, Body[] bodyArray, int n) {
        for (int i = 0; i < n; ++i) {
            Body body = bodyArray[i];
            if (body == null || !body.intersects(d, d2, 2.0)) continue;
            return i;
        }
        return -1;
    }

    public boolean closeToControlHandle(Body body, double d, double d2) {
        return body.controlBoxHandleIntersects(d, d2, 4.0);
    }

    public boolean closeToVelocityVector(Body body, double d, double d2) {
        if (body instanceof Rock) {
            return false;
        }
        Vect vect = body.v.times(this.dt * this.ctlVelocityFactor);
        boolean bl = body.pointIsClose(d, d2, body.pos.x + vect.x, body.pos.y + vect.y, 4.0 * Body.baseRadius);
        return bl;
    }

    public Note playNote(Body body) {
        if (this.muted) {
            return null;
        }
        Playable playable = body.getPlayable();
        Note note = null;
        if (playable != null) {
            note = playable.nextNote(body, this);
        }
        return this.playNote(body, note, body.getChannel());
    }

    public Note playNote(Body body, Note note, int n) {
        if (this.muted || note == null) {
            return null;
        }
        Vect vect = body.getVelocity();
        if (vect != null) {
            if ((note.pitch > 0.0f || note.pitch == (float)Note.REST_STOP) && this.debugLevel > 0) {
                System.out.println("Note: " + note + "-" + n + " [q: " + this.channelQueues[n].size() + " p:" + note.getPitch() + ", v:" + note.getVelocity() + "] BodyV: " + body.getVelocity().magnitude());
            }
            float f = (float)Math.max((double)this.midiVelocity_min[n], Math.min(vect.magnitude(), (double)this.midiVelocity_max[n]));
            note.setVelocity(f);
        } else if (this.debugLevel > 0) {
            System.out.println("Note: " + note + "-" + n + " [p:" + note.getPitch() + ", v:" + note.getVelocity() + "] ROCK");
        }
        return this.playNote(note, n);
    }

    public Note playNote(Note note, int n) {
        if ((int)note.pitch != Note.REST) {
            ChannelQueue channelQueue = this.channelQueues[n];
            channelQueue.nq((int)note.pitch);
            if (channelQueue.full()) {
                int n2 = channelQueue.dq();
                if (this.debugLevel > 0) {
                    System.out.println("NoteOFF: " + n2 + "[ch: " + n + "]");
                }
                this.midiStuff.noteOff(n2, n);
            }
        }
        long l = -1L;
        if (this.beatLocked) {
            l = this.calculateBeatLocking(note, true);
        }
        this.midiStuff.playNote(note, n, l);
        return note;
    }

    public void playNote(Note note, int n, int n2) {
        try {
            this.playNote(note, n);
            Thread.sleep(n2);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public long calculateBeatLocking(Note note, boolean bl) {
        long l = this.midiStuff.getMicrosecondPosition();
        long l2 = l - this.t0_songStart;
        long l3 = l2 % this.measureMs;
        int n = (int)(l3 / this.quantMs);
        long l4 = l3 - (long)n * this.quantMs;
        long l5 = -1L;
        System.out.println("BEAT LOCK. timeInMeasure: " + l3 + " quants: " + n + " deltaQ: " + l4 + " quantMs: " + this.quantMs);
        if ((double)l4 > 0.1 * (double)this.quantMs && (double)l4 < 0.9 * (double)this.quantMs) {
            long l6 = l2 / this.measureMs;
            long l7 = l6 * this.measureMs;
            l5 = this.t0_songStart + l7 + (long)(++n) * this.quantMs;
            System.out.println("  now: " + l + " BPTime: " + l5 + " later: " + (l5 - l));
        }
        if (bl) {
            if (n == 0) {
                note.velocity *= this.measureBump;
            } else if (n == this.halfMeasureQuants) {
                note.velocity *= this.halfMeasureBump;
            } else if (n % this.beatQuants == 0) {
                note.velocity *= this.beatBump;
            }
        }
        return l5;
    }

    public void notifyNotePlayed(Body body, Playable playable, Note note) {
        if (this.noteListeners != null) {
            Iterator iterator = this.noteListeners.iterator();
            while (iterator.hasNext()) {
                NoteListener noteListener = (NoteListener)iterator.next();
                noteListener.notePlayed(body, playable, note);
            }
        }
    }

    public void addNoteListener(NoteListener noteListener) {
        if (this.noteListeners == null) {
            this.noteListeners = new ArrayList();
        }
        this.noteListeners.add(noteListener);
    }

    public void preview(Playable playable, int n) {
        this.preview(playable, n, 200, 700);
    }

    public void preview(Playable playable, int n, int n2, int n3) {
        System.out.println(" o:Preview: current thread: " + Thread.currentThread());
        System.out.println(" o:Preview. playable [" + playable.getType() + " ]: " + playable.getName());
        if (playable instanceof Note) {
            this.playNote((Note)playable, n, 500);
        } else {
            this.previewing = true;
            playable.reset();
            while (this.previewing && !playable.atEnd()) {
                int n4 = Orrery.randomRange(n2, n3);
                Note note = playable.nextNote(null, this);
                if (this.debugLevel > 0) {
                    System.out.println("    playing note: " + note + " dur: " + n4);
                }
                this.playNote(note, n, n4);
                if (this.debugLevel <= 0) continue;
                System.out.println("      played note. previewing=" + this.previewing);
            }
            this.previewing = false;
            this.midiAllOff();
        }
    }

    public void stopPreview() {
        System.out.println("Orrery: stopPreview...");
        System.out.println(" o:stopPreview: current thread: " + Thread.currentThread());
        this.previewing = false;
    }

    public void cycle(double d) {
        ++this.numCycles;
        this.drawer.clearbg(this.bgColor);
        this.increaseTime(d);
        this.draw(this.bodies, this.rocks, this.nbodies, this.nrocks);
        if (this.trails > 0) {
            this.drawTitle_fg();
        }
        this.drawer.show(true);
        this.repaint();
    }

    public void redraw() {
        if (this.paused) {
            try {
                Thread.sleep(100L);
            }
            catch (Exception exception) {
                // empty catch block
            }
            this.drawer.clearbg(this.bgColor);
            this.draw(this.bodies, this.rocks, this.nbodies, this.nrocks);
            this.drawer.show(true);
            this.repaint();
        }
    }

    public void startDrawingThread(String string) {
        System.out.println("start drawing thread(" + string + "). drawingThread: " + this.drawingThread);
        if (this.drawingThread == null) {
            this.drawingThread = new DrawingThread(this);
            System.out.println("created drawing thread. ");
        }
        this.drawingThread.worldfile = string;
        System.out.println("starting drawing thread: " + this.drawingThread);
        this.drawingThread.start();
        System.out.println("started drawing thread: " + this.drawingThread);
    }

    public void stopDrawingThread() {
        System.out.println("Orrery: stop drawing thread");
        if (this.drawingThread != null) {
            this.drawingThread.halt();
            this.drawingThread = null;
        }
    }

    public void resetPlayTimer() {
        this.numCycles = 0;
    }

    public void togglePause() {
        this.setPaused(this.paused);
    }

    public void setPaused(boolean bl) {
        this.paused = bl;
        if (this.paused) {
            this.midiAllOff();
            this.redraw();
        }
    }

    public boolean paused() {
        return this.paused;
    }

    public void toggleInfoDisplay() {
        if (this.displayInfo == -1) {
            this.displayInfo = 0;
        } else if (this.displayInfo == 0) {
            this.displayInfo = -1;
        }
    }

    public void showInfoDisplay(boolean bl) {
        this.displayInfo = bl ? -1 : 0;
    }

    public void setDisplayInfo(int n) {
        this.displayInfo = n;
    }

    public void setDisplayInfoSeconds(float f) {
        this.displayInfo = this.secondsToCycles(f);
    }

    public void setInitialDisplayInfoSeconds(float f) {
        this.initialInfoDisplaySeconds = f;
    }

    public void showHelpInfo(List list) {
        this.helpInfo = list;
        this.showHelpInfo = true;
    }

    public void hideHelpInfo() {
        this.showHelpInfo = false;
    }

    public boolean getShowForceField() {
        return this.showForceField;
    }

    public void setShowForceField(boolean bl) {
        if (this.isInitialConditionsMode()) {
            this.showForceField_keep = bl;
        } else {
            this.showForceField = bl;
        }
    }

    public void toggleForceField() {
        System.out.println("Toggle force vectors: " + !this.showForceField);
        this.showForceField = !this.showForceField;
    }

    public void toggleBodyForces() {
        this.showBodyForces = !this.showBodyForces;
    }

    public void setShowBodyForces(boolean bl) {
        if (this.isInitialConditionsMode()) {
            this.showBodyForces_keep = bl;
        } else {
            this.showBodyForces = bl;
        }
    }

    public boolean getShowBodyForces() {
        return this.showBodyForces;
    }

    public void setShowVelocities(boolean bl) {
        if (this.isInitialConditionsMode()) {
            this.showVelocities_keep = bl;
        } else {
            this.showVelocities = bl;
        }
    }

    public boolean getShowVelocities() {
        return this.showVelocities;
    }

    public void resetForceFieldGridVectors() {
        this.setForceFieldGridVectors(this.forceFieldGridVectors);
    }

    public void setForceFieldGridVectors(int n) {
        this.forceFieldGridVectors = n;
        this.gridSize = 2.0 * this.radius / (double)(this.forceFieldGridVectors - 1);
        this.normalizedVectorLength = 1.25 * this.gridSize;
        System.out.println("SetForceFieldGridVectors(" + n + " normalizedVeectorLength: " + this.normalizedVectorLength + " radius = " + this.radius);
        this.forceVs = new Vect[this.forceFieldGridVectors][this.forceFieldGridVectors];
        for (int i = 0; i < this.forceFieldGridVectors; ++i) {
            for (int j = 0; j < this.forceFieldGridVectors; ++j) {
                this.forceVs[i][j] = new Vect();
            }
        }
    }

    public void pause() {
        this.setPaused(true);
    }

    public void resume() {
        this.setPaused(false);
    }

    public void singleStep() {
        if (this.paused) {
            this.cycle(this.dt);
        }
    }

    public void waitForDrawingThread() {
        if (this.drawingThread != null && this.drawingThread.drawing) {
            try {
                this.drawingThread.join();
                this.drawingThread = null;
                System.out.println("\n\n GODOT arrived at the drawing thread. \n\n");
            }
            catch (Exception exception) {
                System.out.println("Orrery.gotException waiting for drawing thread. ");
                exception.printStackTrace();
            }
        }
    }

    public void winkOut() {
        if (this.paused) {
            this.paused = false;
        }
        this.chooseRandomDoomsayersLament();
        if (this.kepler != null) {
            this.kepler.setMode("worldtransition", true);
            this.kepler.setMode("worldending", true);
        }
        WinkingOutThread winkingOutThread = new WinkingOutThread(this);
        winkingOutThread.start();
    }

    public boolean isWinkingOut() {
        return this.winkingOut;
    }

    public void winkOut(int n, boolean bl) {
        int n2;
        this.winkingOut = true;
        for (n2 = 0; n2 < this.nbodies; ++n2) {
            if (this.bodies[n2] == null || !this.bodies[n2].alive) continue;
            this.bodies[n2] = null;
            this.delay(Orrery.randomRange(n, 2 * n));
        }
        for (n2 = 0; n2 < this.nrocks; ++n2) {
            if (this.rocks[n2] == null || !this.rocks[n2].alive) continue;
            this.rocks[n2] = null;
            this.delay(Orrery.randomRange(n / 5, n / 3));
        }
        for (n2 = 0; n2 < this.channelQueues.length; ++n2) {
            ChannelQueue channelQueue = this.channelQueues[n2];
            while (!channelQueue.empty()) {
                int n3 = channelQueue.dq();
                System.out.println("NoteOFF: " + n3 + "[ch: " + n2 + "]");
                this.midiStuff.noteOff(n3, n2);
                this.delay(Orrery.randomRange((int)(0.5 * (double)n), (int)(1.2 * (double)n)));
            }
        }
        if (bl) {
            this.stopDrawingThread();
        }
        this.winkingOut = false;
    }

    public void toggleMuted() {
        this.muted = !this.muted;
    }

    public void setMuted(boolean bl) {
        this.muted = bl;
        if (bl) {
            this.midiAllOff();
        }
    }

    public void midiAllOff() {
        for (int i = 0; i < this.channelQueues.length; ++i) {
            ChannelQueue channelQueue = this.channelQueues[i];
            while (!channelQueue.empty()) {
                int n = channelQueue.dq();
                this.midiStuff.noteOff(n, i);
            }
        }
    }

    public static int randomRange(int n, int n2) {
        return n + (int)(Math.random() * (double)(n2 - n));
    }

    public static double randomRange(double d, double d2) {
        return d + Math.random() * (d2 - d);
    }

    public static float randomRange(float f, float f2) {
        return f + (float)Math.random() * (f2 - f);
    }

    public void delay(int n) {
        try {
            Thread.sleep(n);
        }
        catch (InterruptedException interruptedException) {
            System.out.println("Error sleeping");
        }
    }

    public void repaint() {
        this.repaintComponent.repaint();
    }

    public void setRepaintComponent(Component component) {
        this.repaintComponent = component;
    }

    class WinkingOutThread
    extends Thread {
        private Orrery orrery;

        public WinkingOutThread(Orrery orrery2) {
            this.orrery = orrery2;
        }

        public synchronized void run() {
            this.orrery.winkOut(400, true);
        }
    }

    class DrawingThread
    extends Thread {
        public boolean drawing = false;
        protected Orrery orrery;
        public String worldfile;

        public DrawingThread(Orrery orrery2) {
            this.orrery = orrery2;
        }

        public synchronized void run() {
            try {
                if (Orrery.this.debugLevel > 0) {
                    System.out.println("DrawingThread.run. worldfile: " + this.worldfile);
                }
                this.drawing = true;
                Orrery.this.paused = false;
                Orrery.this.numCycles = 0;
                Orrery.this.randomizePlayCycles();
                if (Orrery.this.debugLevel > 0) {
                    System.out.println("ORRERY. playTimeRange: {" + Orrery.this.playTimeLo + ", " + Orrery.this.playTimeHi + "} playCycles: " + Orrery.this.playCycles);
                }
                double d = this.orrery.dt;
                if (this.orrery.local_dt > 0.0) {
                    d = this.orrery.local_dt;
                }
                Orrery.this.t0_songStart = Orrery.this.midiStuff.getMicrosecondPosition();
                while (this.drawing) {
                    if (Orrery.this.playCycles > 0 && Orrery.this.numCycles >= Orrery.this.playCycles && !Orrery.this.winkingOut) {
                        Orrery.this.numCycles = 0;
                        Orrery.this.winkOut();
                        continue;
                    }
                    if (!Orrery.this.paused) {
                        long l = System.currentTimeMillis();
                        this.orrery.cycle(d);
                        long l2 = System.currentTimeMillis();
                        long l3 = l2 - l;
                        if (this.orrery.cycleTime <= 0 || l3 >= (long)this.orrery.cycleTime) continue;
                        try {
                            Thread.sleep((long)this.orrery.cycleTime - l3);
                        }
                        catch (InterruptedException interruptedException) {
                            System.out.println("Error sleeping");
                        }
                        continue;
                    }
                    try {
                        Thread.sleep(400L);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Error sleeping");
                    }
                }
            }
            catch (Exception exception) {
                System.err.println("Drawing Thread caught exception: " + exception);
                exception.printStackTrace(System.err);
            }
        }

        public void halt() {
            if (Orrery.this.debugLevel > 0) {
                System.out.println("\n\n\n======OrreryDrawingTHread   HALT!!!\n\n\n");
            }
            this.drawing = false;
        }
    }
}

