/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.util.HashMap;
import kepler.Body;
import kepler.Orrery;
import kepler.Playable;

public class Note
extends Playable {
    public float pitch;
    public float velocity;
    public int duration;
    public static float DEFAULT_VELOCITY = 65.0f;
    public static int DEFAULT_DURATION = 444;
    public static Note EMPTY = new Note(-1.0f);
    public static int REST = -1;
    public static int REST_STOP = -2;
    public static HashMap notesHash = new HashMap();
    public static String[] notesArray;

    public Note(float f, float f2, int n) {
        this.pitch = f;
        this.velocity = f2;
        this.duration = n;
    }

    public Note(float f, float f2) {
        this.pitch = f;
        this.velocity = f2;
        this.duration = DEFAULT_DURATION;
    }

    public Note(float f) {
        this.pitch = f;
        this.velocity = DEFAULT_VELOCITY;
        this.duration = DEFAULT_DURATION;
    }

    public Note(String string) {
        this.pitch = Note.parseNote(string);
        this.velocity = DEFAULT_VELOCITY;
    }

    public Note(String string, float f) {
        this.pitch = Note.parseNote(string);
        this.velocity = f;
    }

    public String getName() {
        return Note.noteString((int)this.pitch);
    }

    public String getType() {
        return "note";
    }

    public Note nextNote(Body body, Orrery orrery) {
        return this;
    }

    public boolean atEnd() {
        return true;
    }

    public Playable duplicate() {
        return new Note(this.pitch, this.velocity);
    }

    public void reset() {
    }

    public void writeBody(StringBuffer stringBuffer) {
        stringBuffer.append(this.getName());
    }

    public void writeCurrentState(StringBuffer stringBuffer) {
        this.writeBody(stringBuffer);
    }

    public float getPitch() {
        return this.pitch;
    }

    public void setPitch(float f) {
        this.pitch = f;
    }

    public boolean isRest() {
        return this.pitch < 0.0f;
    }

    public boolean isRestStop() {
        return this.pitch == (float)REST_STOP;
    }

    public float getVelocity() {
        return this.velocity;
    }

    public void setVelocity(float f) {
        this.velocity = f;
    }

    public static float midiToFreq(float f) {
        return 0.0f;
    }

    public static float freqToMidi(float f) {
        return 0.0f;
    }

    public static float parseNote(String string) {
        int n;
        String string2;
        if ("_".equals(string) || "rest".equalsIgnoreCase(string)) {
            return REST;
        }
        if (".".equals(string) || "*".equals(string) || "rest_stop".equalsIgnoreCase(string)) {
            return REST_STOP;
        }
        char c = string.charAt(1);
        if (c == 'b' || c == '#') {
            string2 = string.substring(0, 2).toUpperCase();
            n = 2;
        } else {
            string2 = string.substring(0, 1).toUpperCase();
            n = 1;
        }
        int n2 = Integer.parseInt(string.substring(n));
        int n3 = 60 + (n2 - 3) * 12;
        return n3 + (Integer)notesHash.get(string2);
    }

    public static String noteString(int n) {
        if (n == REST) {
            return "_";
        }
        if (n == REST_STOP) {
            return ".";
        }
        int n2 = n / 12 - 2;
        int n3 = n % 12;
        return notesArray[n3] + n2;
    }

    public void toString(StringBuffer stringBuffer) {
        stringBuffer.append(Note.noteString((int)this.pitch));
    }

    public String toString() {
        return Note.noteString((int)this.pitch);
    }

    static {
        notesHash.put("C", new Integer(0));
        notesHash.put("C#", new Integer(1));
        notesHash.put("DB", new Integer(1));
        notesHash.put("D", new Integer(2));
        notesHash.put("D#", new Integer(3));
        notesHash.put("EB", new Integer(3));
        notesHash.put("E", new Integer(4));
        notesHash.put("FB", new Integer(4));
        notesHash.put("E#", new Integer(5));
        notesHash.put("F", new Integer(5));
        notesHash.put("F#", new Integer(6));
        notesHash.put("GB", new Integer(6));
        notesHash.put("G", new Integer(7));
        notesHash.put("G#", new Integer(8));
        notesHash.put("AB", new Integer(8));
        notesHash.put("A", new Integer(9));
        notesHash.put("A#", new Integer(10));
        notesHash.put("BB", new Integer(10));
        notesHash.put("B", new Integer(11));
        notesHash.put("CB", new Integer(11));
        notesHash.put("B#", new Integer(0));
        notesArray = new String[]{"C", "C#", "D", "D#", "E", "F", "F#", "G", "G#", "A", "A#", "B"};
    }
}

