/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSlider;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kepler.ControlPanel;
import kepler.Kepler;

public class MissionControlPanel
extends ControlPanel {
    private JSlider gravitySlider = null;
    private JLabel gravityValue = null;
    private JLabel gravityHeaderLabel = null;
    private JLabel gravityLabel = null;
    private JSlider repulsionSlider = null;
    private JLabel repulsionValue = null;
    private JLabel repulsionLabel = null;
    private JSlider frictionSlider = null;
    private JLabel frictionValue = null;
    private JLabel frictionLabel = null;
    private JToggleButton trailsCheck = null;
    private JToggleButton forceFieldCheck = null;
    private JToggleButton bodyForceCheck = null;
    private JToggleButton velocitiesCheck = null;
    private JPanel bottomControls;
    private JButton selectPrevButton;
    private JButton selectNextButton;
    private JButton addRockButton;
    private JButton addBodyButton;
    private JButton deleteSelectedButton;
    Color backgroundColor;
    private double frictionLowRange = 0.0;
    private double frictionHighRange = 0.2;

    public MissionControlPanel(Kepler kepler, Color color) {
        super(kepler);
        this.backgroundColor = color;
        color = color == null && kepler.kioskMode() ? this.orrery.controlPanelBG3 : this.orrery.controlPanelBG;
        this.setPanel(this.makePanel(kepler));
    }

    public JPanel makePanel(Kepler kepler) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setBorder(new MatteBorder(0, 2, 2, 2, this.orrery.controlPanelBorder));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 10;
        JLabel jLabel = this.makeImageLabel("vspacer400.gif", "");
        jLabel.setBackground(this.backgroundColor);
        jPanel.add((Component)jLabel, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 3, 0);
        JLabel jLabel2 = this.makeImageLabel("spacer256.gif", "");
        jLabel2.setBackground(this.backgroundColor);
        jPanel.add((Component)jLabel2, gridBagConstraints);
        int n = 0;
        int n2 = 1;
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 3;
        gridBagConstraints2.gridwidth = 2;
        gridBagConstraints2.gridx = n + 0;
        gridBagConstraints2.gridy = n2 + 0;
        gridBagConstraints2.weightx = 0.0;
        gridBagConstraints2.insets = new Insets(10, 0, 0, 0);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 3;
        gridBagConstraints3.gridx = n;
        gridBagConstraints3.gridy = n2 + 1;
        gridBagConstraints3.weightx = 0.0;
        gridBagConstraints3.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints4.gridx = n;
        gridBagConstraints4.gridy = n2 + 2;
        gridBagConstraints4.weighty = 0.5;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 3;
        gridBagConstraints5.gridx = n;
        gridBagConstraints5.gridy = n2 + 3;
        gridBagConstraints5.weightx = 0.0;
        gridBagConstraints5.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.getGravityHeaderLabel(), gridBagConstraints2);
        jPanel.add((Component)this.getGravityLabel(), gridBagConstraints3);
        JLabel jLabel3 = this.makeImageLabel("vspacer200.gif", "");
        jLabel3.setBackground(this.backgroundColor);
        jPanel.add((Component)jLabel3, gridBagConstraints4);
        jPanel.add((Component)this.getGravitySlider(), gridBagConstraints4);
        jPanel.add((Component)this.getGravityValue(), gridBagConstraints5);
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 3;
        gridBagConstraints6.gridx = n + 1;
        gridBagConstraints6.gridy = n2 + 1;
        gridBagConstraints6.weightx = 0.0;
        gridBagConstraints6.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints7.gridx = n + 1;
        gridBagConstraints7.gridy = n2 + 2;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.fill = 3;
        gridBagConstraints8.gridx = n + 1;
        gridBagConstraints8.gridy = n2 + 3;
        gridBagConstraints8.weightx = 0.0;
        gridBagConstraints8.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.getRepulsionLabel(), gridBagConstraints6);
        jPanel.add((Component)this.getRepulsionSlider(), gridBagConstraints7);
        jPanel.add((Component)this.getRepulsionValue(), gridBagConstraints8);
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 3;
        gridBagConstraints9.gridx = n + 2;
        gridBagConstraints9.gridy = n2 + 1;
        gridBagConstraints9.weightx = 0.0;
        gridBagConstraints9.insets = new Insets(0, 0, 0, 0);
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.insets = new Insets(0, 0, 0, 0);
        gridBagConstraints10.gridx = n + 2;
        gridBagConstraints10.gridy = n2 + 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.fill = 3;
        gridBagConstraints11.gridx = n + 2;
        gridBagConstraints11.gridy = n2 + 3;
        gridBagConstraints11.weightx = 0.0;
        gridBagConstraints11.anchor = 10;
        gridBagConstraints11.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.getFrictionLabel(), gridBagConstraints9);
        jPanel.add((Component)this.getFrictionSlider(), gridBagConstraints10);
        jPanel.add((Component)this.getFrictionValue(), gridBagConstraints11);
        GridBagConstraints gridBagConstraints12 = new GridBagConstraints();
        gridBagConstraints12.gridx = n + 0;
        gridBagConstraints12.gridy = n2 + 4;
        gridBagConstraints12.gridwidth = 3;
        gridBagConstraints12.insets = new Insets(8, 16, 0, 0);
        gridBagConstraints12.anchor = 17;
        GridBagConstraints gridBagConstraints13 = new GridBagConstraints();
        gridBagConstraints13.gridx = n + 0;
        gridBagConstraints13.gridy = n2 + 5;
        gridBagConstraints13.gridwidth = 3;
        gridBagConstraints13.insets = new Insets(0, 16, 0, 0);
        gridBagConstraints13.anchor = 17;
        GridBagConstraints gridBagConstraints14 = new GridBagConstraints();
        gridBagConstraints14.gridx = n + 0;
        gridBagConstraints14.gridy = n2 + 6;
        gridBagConstraints14.gridwidth = 3;
        gridBagConstraints14.insets = new Insets(0, 16, 0, 0);
        gridBagConstraints14.anchor = 17;
        GridBagConstraints gridBagConstraints15 = new GridBagConstraints();
        gridBagConstraints15.gridx = n + 0;
        gridBagConstraints15.gridy = n2 + 7;
        gridBagConstraints15.gridwidth = 3;
        gridBagConstraints15.insets = new Insets(0, 16, 8, 0);
        gridBagConstraints15.anchor = 17;
        jPanel.add((Component)this.getTrailsCheck(), gridBagConstraints12);
        jPanel.add((Component)this.getForceFieldCheck(), gridBagConstraints13);
        jPanel.add((Component)this.getBodyForceCheck(), gridBagConstraints14);
        jPanel.add((Component)this.getVelocitiesCheck(), gridBagConstraints15);
        if (kepler.kioskMode()) {
            gridBagConstraints.gridx = n + 0;
            gridBagConstraints.gridy = n2 + 7;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.weighty = 1.0;
            gridBagConstraints.insets = new Insets(0, 0, 0, 0);
            jPanel.add((Component)this.makeTextLabel(""), gridBagConstraints);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = n + 0;
            gridBagConstraints.gridwidth = 4;
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 0.0;
            jPanel.add((Component)this.makeBottomControls_kiosk(this.backgroundColor), gridBagConstraints);
        }
        return jPanel;
    }

    private JPanel makeBottomControls_kiosk(Color color) {
        this.bottomControls = new JPanel();
        this.bottomControls.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        gridBagConstraints.anchor = 10;
        this.bottomControls.setBackground(color);
        this.selectPrevButton = this.makeImageButton("SelectPrevButton_up.gif", "SelectPrevButton_down.gif", "SelectPrevButton_disabled.gif", "Select Prev");
        this.bottomControls.add((Component)this.selectPrevButton, gridBagConstraints);
        this.selectPrevButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MissionControlPanel.this.orrery.resetPlayTimer();
                MissionControlPanel.this.orrery.getWorldBuilder().selectPrevBodyOrRock();
            }
        });
        this.addBodyButton = this.makeImageButton("NewBody_up.gif", "NewBody_down.gif", "NewBody_disabled.gif", "New Body");
        ++gridBagConstraints.gridx;
        this.bottomControls.add((Component)this.addBodyButton, gridBagConstraints);
        this.addBodyButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MissionControlPanel.this.orrery.getWorldBuilder().addBody();
            }
        });
        this.addRockButton = this.makeImageButton("NewRock_up.gif", "NewRock_down.gif", "NewRock_disabled.gif", "New Rock");
        ++gridBagConstraints.gridx;
        this.bottomControls.add((Component)this.addRockButton, gridBagConstraints);
        this.addRockButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MissionControlPanel.this.orrery.getWorldBuilder().addRock();
            }
        });
        this.deleteSelectedButton = this.makeImageButton("deleteSelected_up.gif", "deleteSelected_down.gif", "deleteSelected_disabled.gif", "Delete Selected Rock or Body");
        ++gridBagConstraints.gridx;
        this.bottomControls.add((Component)this.deleteSelectedButton, gridBagConstraints);
        this.deleteSelectedButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MissionControlPanel.this.orrery.getWorldBuilder().deleteSelected();
            }
        });
        this.selectNextButton = this.makeImageButton("SelectNextButton_up.gif", "SelectNextButton_down.gif", "SelectNextButton_disabled.gif", "Select Next");
        ++gridBagConstraints.gridx;
        this.bottomControls.add((Component)this.selectNextButton, gridBagConstraints);
        this.selectNextButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                MissionControlPanel.this.orrery.resetPlayTimer();
                MissionControlPanel.this.orrery.getWorldBuilder().selectNextBodyOrRock();
            }
        });
        return this.bottomControls;
    }

    private JSlider getGravitySlider() {
        if (this.gravitySlider == null) {
            this.gravitySlider = new JSlider();
            this.gravitySlider.setName("gravitySlider");
            this.gravitySlider.setPreferredSize(new Dimension(30, 150));
            this.gravitySlider.setOrientation(1);
            this.gravitySlider.setBackground(this.backgroundColor);
            this.gravitySlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue();
                    double d = MissionControlPanel.this.cookFactorValue(n, 50, 11.0);
                    if (!jSlider.getValueIsAdjusting()) {
                        MissionControlPanel.this.orrery.setGravityFactorBody(d);
                        MissionControlPanel.this.orrery.setGravityFactorRock(d);
                    } else {
                        String string = "" + d;
                        if (string.length() > 5) {
                            string = string.substring(0, 5);
                        }
                        MissionControlPanel.this.gravityValue.setText(string);
                    }
                }
            });
        }
        return this.gravitySlider;
    }

    private JLabel getGravityValue() {
        if (this.gravityValue == null) {
            this.gravityValue = new JLabel("1.00");
            this.gravityValue.setForeground(this.orrery.controlPanelValueFG);
            this.gravityValue.setName("gravityValue");
        }
        return this.gravityValue;
    }

    private JLabel getGravityHeaderLabel() {
        if (this.gravityHeaderLabel == null) {
            this.gravityHeaderLabel = new JLabel(Kepler.createImageIcon("gravity_header.gif", "gravity attracts at the inverse square law"));
        }
        return this.gravityHeaderLabel;
    }

    private JLabel getGravityLabel() {
        if (this.gravityLabel == null) {
            this.gravityLabel = new JLabel(Kepler.createImageIcon("gravity_attract.gif", "gravity attracts at the inverse square law"));
            this.gravityLabel.setBackground(this.orrery.titleColor);
            this.gravityLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        return this.gravityLabel;
    }

    private JSlider getRepulsionSlider() {
        if (this.repulsionSlider == null) {
            this.repulsionSlider = new JSlider();
            this.repulsionSlider.setName("repulsionSlider");
            this.repulsionSlider.setPreferredSize(new Dimension(30, 150));
            this.repulsionSlider.setOrientation(1);
            this.repulsionSlider.setBackground(this.backgroundColor);
            this.repulsionSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue();
                    double d = MissionControlPanel.this.cookFactorValue(n, 50, 11.0);
                    if (!jSlider.getValueIsAdjusting()) {
                        MissionControlPanel.this.orrery.setRepelFactorBody(d);
                        MissionControlPanel.this.orrery.setRepelFactorRock(d);
                    } else {
                        String string = "" + d;
                        if (string.length() > 5) {
                            string = string.substring(0, 5);
                        }
                        MissionControlPanel.this.repulsionValue.setText(string);
                        System.out.println("r:" + n + " | c:" + d);
                    }
                }
            });
        }
        return this.repulsionSlider;
    }

    private JLabel getRepulsionValue() {
        if (this.repulsionValue == null) {
            this.repulsionValue = new JLabel("1.00");
            this.repulsionValue.setForeground(this.orrery.controlPanelValueFG);
            this.repulsionValue.setName("repulsionValue");
        }
        return this.repulsionValue;
    }

    private JLabel getRepulsionLabel() {
        if (this.repulsionLabel == null) {
            this.repulsionLabel = new JLabel(Kepler.createImageIcon("gravity_repel.gif", "...and repels at the inverse cube law"));
            this.repulsionLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        }
        return this.repulsionLabel;
    }

    private JSlider getFrictionSlider() {
        if (this.frictionSlider == null) {
            this.frictionSlider = new JSlider();
            this.frictionSlider.setName("frictionSlider");
            this.frictionSlider.setPreferredSize(new Dimension(30, 150));
            this.frictionSlider.setOrientation(1);
            this.frictionSlider.setBackground(this.backgroundColor);
            this.frictionSlider.setForeground(this.orrery.controlPanelFG);
            this.frictionSlider.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    JSlider jSlider = (JSlider)changeEvent.getSource();
                    int n = jSlider.getValue();
                    double d = MissionControlPanel.this.cookLinearValue(n, MissionControlPanel.this.frictionLowRange, MissionControlPanel.this.frictionHighRange);
                    d = Math.min(1.0, d);
                    if (!jSlider.getValueIsAdjusting()) {
                        MissionControlPanel.this.orrery.setFriction(1.0 - d);
                    } else {
                        String string = "" + d;
                        if (string.length() > 5) {
                            string = string.substring(0, 5);
                        }
                        MissionControlPanel.this.frictionValue.setText(string);
                    }
                }
            });
        }
        return this.frictionSlider;
    }

    private JLabel getFrictionValue() {
        if (this.frictionValue == null) {
            this.frictionValue = new JLabel("0.990");
            this.frictionValue.setForeground(this.orrery.controlPanelValueFG);
        }
        return this.frictionValue;
    }

    private JLabel getFrictionLabel() {
        if (this.frictionLabel == null) {
            this.frictionLabel = new JLabel(Kepler.createImageIcon("friction.gif", "'Aether friction'"));
        }
        return this.frictionLabel;
    }

    public void setGravityFactor(double d) {
        System.out.println("MISSIONCONTROL: setGrasvFactor(" + d + ") uncoook: " + this.uncookFactorValue(d, 50, 11.0));
        String string = "" + d;
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        this.gravityValue.setText(string);
        this.gravitySlider.setValue(this.uncookFactorValue(d, 50, 11.0));
    }

    public void setRepulsionFactor(double d) {
        System.out.println("MISSIONCONTROL: setRepelFactor(" + d + ") uncook: " + this.uncookFactorValue(d, 50, 11.0));
        String string = "" + d;
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        this.repulsionValue.setText(string);
        this.repulsionSlider.setValue(this.uncookFactorValue(d, 50, 11.0));
    }

    public void setFriction(double d) {
        double d2 = 1.0 - d;
        String string = "" + d2;
        if (string.length() > 5) {
            string = string.substring(0, 5);
        }
        this.frictionValue.setText(string);
        this.frictionSlider.setValue(this.uncookLinearValue(d2, this.frictionLowRange, this.frictionHighRange));
    }

    public void worldRead() {
        this.setGravityFactor(this.orrery.getGravityFactorBody());
        this.setRepulsionFactor(this.orrery.getRepelFactorBody());
        this.setFriction(this.orrery.getFriction());
    }

    public void dawnOfCreation() {
    }

    public void endOfTheWorld() {
    }

    private JToggleButton getTrailsCheck() {
        if (this.trailsCheck == null) {
            String string = "trails_off.gif";
            String string2 = "trails_on.gif";
            this.trailsCheck = new JToggleButton(Kepler.createImageIcon(string, "Turn on trails"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Turn off trails");
            this.trailsCheck.setBorderPainted(false);
            this.trailsCheck.setPressedIcon(imageIcon);
            this.trailsCheck.setSelectedIcon(imageIcon);
            this.trailsCheck.setMargin(new Insets(0, 0, 0, 0));
            this.trailsCheck.setContentAreaFilled(false);
            this.trailsCheck.setBackground(this.backgroundColor);
            this.trailsCheck.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    MissionControlPanel.this.kepler.setTrails(MissionControlPanel.this.trailsCheck.isSelected());
                }
            });
        }
        return this.trailsCheck;
    }

    private JToggleButton getForceFieldCheck() {
        if (this.forceFieldCheck == null) {
            String string = "forcefield_off.gif";
            String string2 = "forcefield_on.gif";
            this.forceFieldCheck = new JToggleButton(Kepler.createImageIcon(string, "Turn on force field"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Turn off force field");
            this.forceFieldCheck.setBorderPainted(false);
            this.forceFieldCheck.setPressedIcon(imageIcon);
            this.forceFieldCheck.setSelectedIcon(imageIcon);
            this.forceFieldCheck.setMargin(new Insets(0, 0, 0, 0));
            this.forceFieldCheck.setContentAreaFilled(false);
            this.forceFieldCheck.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    MissionControlPanel.this.orrery.setShowForceField(MissionControlPanel.this.forceFieldCheck.isSelected());
                }
            });
        }
        return this.forceFieldCheck;
    }

    private JToggleButton getBodyForceCheck() {
        if (this.bodyForceCheck == null) {
            String string = "bodyforces_off.gif";
            String string2 = "bodyforces_on.gif";
            this.bodyForceCheck = new JToggleButton(Kepler.createImageIcon(string, "Turn on force field"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Turn off force field");
            this.bodyForceCheck.setBorderPainted(false);
            this.bodyForceCheck.setPressedIcon(imageIcon);
            this.bodyForceCheck.setSelectedIcon(imageIcon);
            this.bodyForceCheck.setMargin(new Insets(0, 0, 0, 0));
            this.bodyForceCheck.setContentAreaFilled(false);
            this.bodyForceCheck.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    MissionControlPanel.this.orrery.setShowBodyForces(MissionControlPanel.this.bodyForceCheck.isSelected());
                }
            });
        }
        return this.bodyForceCheck;
    }

    private JToggleButton getVelocitiesCheck() {
        if (this.velocitiesCheck == null) {
            String string = "velocities_off.gif";
            String string2 = "velocities_on.gif";
            this.velocitiesCheck = new JToggleButton(Kepler.createImageIcon(string, "Turn on force field"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Turn off force field");
            this.velocitiesCheck.setBorderPainted(false);
            this.velocitiesCheck.setPressedIcon(imageIcon);
            this.velocitiesCheck.setSelectedIcon(imageIcon);
            this.velocitiesCheck.setMargin(new Insets(0, 0, 0, 0));
            this.velocitiesCheck.setContentAreaFilled(false);
            this.velocitiesCheck.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    MissionControlPanel.this.orrery.resetPlayTimer();
                    MissionControlPanel.this.orrery.setShowVelocities(MissionControlPanel.this.velocitiesCheck.isSelected());
                }
            });
        }
        return this.velocitiesCheck;
    }

    public void setMode(String string, boolean bl) {
        if (string.equals("pause")) {
            if (this.orrery.isWinkingOut()) {
                bl = false;
            }
            this.hideBottomButtons(bl);
        } else if (string.equals("worldtransition")) {
            this.hideBottomButtons(!bl);
        }
    }

    private void hideBottomButtons(boolean bl) {
        if (this.bottomControls != null) {
            this.bottomControls.setVisible(bl);
        }
    }

    private void enableBottomButtons(boolean bl) {
        if (this.selectPrevButton != null) {
            this.selectPrevButton.setEnabled(bl);
        }
        if (this.selectNextButton != null) {
            this.selectNextButton.setEnabled(bl);
        }
        if (this.addRockButton != null) {
            this.addRockButton.setEnabled(bl);
        }
        if (this.addBodyButton != null) {
            this.addBodyButton.setEnabled(bl);
        }
        if (this.deleteSelectedButton != null) {
            this.deleteSelectedButton.setEnabled(bl);
        }
    }
}

