/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import javax.sound.midi.Instrument;
import javax.sound.midi.MidiChannel;
import javax.sound.midi.MidiDevice;
import javax.sound.midi.MidiSystem;
import javax.sound.midi.Patch;
import javax.sound.midi.Receiver;
import javax.sound.midi.Sequencer;
import javax.sound.midi.ShortMessage;
import javax.sound.midi.Soundbank;
import javax.sound.midi.Synthesizer;
import javax.sound.midi.Transmitter;
import kepler.Note;
import kepler.Orrery;

public class MidiStuff {
    public static final long NOW = -1L;
    private Orrery orrery;
    private Receiver rcvr = null;
    Sequencer seq;
    Transmitter seqTrans;
    Synthesizer synth;
    Patch[] currentPatchSet;
    Instrument[] loadedInstruments;
    Soundbank soundbank;
    Receiver synthRcvr;
    public int[][] defaultPatches = new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 0}, {0, 11}, {0, 19}, {0, 21}, {0, 34}, {0, 35}, {0, 40}, {0, 41}, {0, 49}, {0, 45}, {0, 52}, {0, 53}, {0, 58}};

    public MidiStuff(Orrery orrery) {
        this.orrery = orrery;
        this.init();
        if (this.rcvr != null) {
            this.printStuff();
        } else {
            System.out.println("Midi not set up. ");
        }
    }

    public void init() {
        MidiDevice.Info[] infoArray = MidiSystem.getMidiDeviceInfo();
        System.out.println("MidiInfo: ------------");
        for (int i = 0; i < infoArray.length; ++i) {
            this.printMidiInfo(infoArray[i]);
        }
        System.out.println("-------- ------------");
        try {
            System.out.println("Default Receiver: " + this.rcvr);
            this.seq = MidiSystem.getSequencer();
            this.seqTrans = this.seq.getTransmitter();
            this.synth = MidiSystem.getSynthesizer();
            System.out.println("Synth: " + this.synth);
            if (!this.synth.isOpen()) {
                this.synth.open();
            }
            this.soundbank = this.synth.getDefaultSoundbank();
            this.currentPatchSet = this.makePatches(this.defaultPatches);
            System.out.println("Soundbank: " + this.soundbank);
            this.synth.loadAllInstruments(this.soundbank);
            this.loadedInstruments = this.synth.getLoadedInstruments();
            this.loadPatchSet(this.currentPatchSet);
            this.rcvr = this.synthRcvr = this.synth.getReceiver();
            this.seqTrans.setReceiver(this.synthRcvr);
        }
        catch (Exception exception) {
            System.out.println("Caught exception setting up midi devices. " + exception);
            exception.printStackTrace();
        }
    }

    public long getMicrosecondPosition() {
        return this.seq.getMicrosecondPosition();
    }

    public void reloadPatchSet() {
        this.loadPatchSet(this.currentPatchSet);
    }

    public void loadPatchSet(Patch[] patchArray) {
        if (this.rcvr == null) {
            return;
        }
        MidiChannel[] midiChannelArray = this.synth.getChannels();
        for (int i = 0; i < midiChannelArray.length; ++i) {
            MidiChannel midiChannel = midiChannelArray[i];
            Patch patch = patchArray[i];
            midiChannel.programChange(patch.getBank(), patch.getProgram());
            if (this.orrery.debugLevel <= 0) continue;
            System.out.println("CH" + i + " bank: " + patch.getBank() + " prog: " + midiChannel.getProgram());
        }
    }

    public void setPatch(int n, int n2, int n3) {
        if (this.currentPatchSet != null) {
            this.currentPatchSet[n] = new Patch(n2, n3);
        }
    }

    public Patch getPatch(int n) {
        return this.currentPatchSet[n];
    }

    public int getPatchBank(int n) {
        Patch patch = this.getPatch(n);
        if (patch != null) {
            return patch.getBank();
        }
        return -1;
    }

    public int getPatchProgram(int n) {
        Patch patch = this.getPatch(n);
        if (patch != null) {
            return patch.getProgram();
        }
        return -1;
    }

    public Patch[] makePatches(int[][] nArray) {
        System.out.println("Making Patches. ps.len: " + nArray.length);
        Patch[] patchArray = new Patch[nArray.length];
        for (int i = 0; i < nArray.length; ++i) {
            int[] nArray2 = nArray[i];
            patchArray[i] = new Patch(nArray2[0], nArray2[1]);
        }
        return patchArray;
    }

    public void printStuff() {
        this.printSynthStuff(this.synth);
    }

    public void printSynthStuff(Synthesizer synthesizer) {
        System.out.println("Loaded Instruments: " + this.loadedInstruments.length);
        if (this.orrery.debugLevel > 0) {
            for (int i = 0; i < this.loadedInstruments.length; ++i) {
                System.out.println("LInstrument{" + i + "}: " + this.loadedInstruments[i]);
                System.out.println("     patch: " + this.patchString(this.loadedInstruments[i].getPatch()));
            }
        }
        System.out.println(" CHANNEL INFO =======");
        MidiChannel[] midiChannelArray = synthesizer.getChannels();
        for (int i = 0; i < midiChannelArray.length; ++i) {
            MidiChannel midiChannel = midiChannelArray[i];
            System.out.println("CH" + i + " prog: " + midiChannel.getProgram());
        }
    }

    public String patchString(Patch patch) {
        return "Patch{bank: " + patch.getBank() + " prog: " + patch.getProgram() + "}";
    }

    public void printMidiInfo(MidiDevice.Info info) {
        System.out.println(" Name: " + info.getName());
        System.out.println(" Desc: " + info.getDescription());
        System.out.println(" Vend: " + info.getVendor());
        System.out.println(" Vers: " + info.getVersion());
        System.out.println();
    }

    public void playNote(Note note, int n, long l) {
        this.playNote(note, note.duration, n, l);
    }

    public void playNote(Note note, int n, int n2, long l) {
        if (note.pitch <= 0.0f || this.rcvr == null) {
            return;
        }
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(144, n2, (int)note.pitch, (int)note.velocity);
            long l2 = l;
            this.rcvr.send(shortMessage, l2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void noteOff(Note note, int n) {
        this.noteOff((int)note.pitch, n);
    }

    public void noteOff(int n, int n2) {
        if (n <= 0) {
            return;
        }
        try {
            ShortMessage shortMessage = new ShortMessage();
            shortMessage.setMessage(128, n2, n, 0);
            long l = -1L;
            this.rcvr.send(shortMessage, l);
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    public void playBank(int n, int n2) {
        for (int i = 0; i < 16; ++i) {
            this.currentPatchSet[i] = new Patch(n, n2 + i);
        }
        this.reloadPatchSet();
        this.playSamples(300, 600);
    }

    public void playInst(int n, int n2) {
        this.currentPatchSet[0] = new Patch(n, n2);
        this.reloadPatchSet();
        this.playSampleInst(0, 300);
    }

    public void playSampleInst(int n, int n2) {
        Note note;
        int n3;
        Note[] noteArray = new Note[]{new Note("A0"), new Note("D0"), new Note("A1"), new Note("D1"), new Note("A2"), new Note("D2"), new Note("A3"), new Note("D3"), new Note("A4"), new Note("D4")};
        Note[] noteArray2 = new Note[]{new Note("D0"), new Note("E0"), new Note("F0"), new Note("G0"), new Note("A1"), new Note("B1"), new Note("C1"), new Note("D1"), new Note("E1")};
        Note[] noteArray3 = new Note[]{new Note("D2"), new Note("E2"), new Note("F2"), new Note("G2"), new Note("A3"), new Note("B3"), new Note("C3"), new Note("D3"), new Note("E3")};
        n2 = 800;
        for (n3 = 0; n3 < noteArray.length; ++n3) {
            note = noteArray[n3];
            note.setVelocity(50.0f);
            this.playNote(note, n2, n, -1L);
            System.out.println("    Note: " + note + "[ch: " + n + " p:" + note.getPitch() + ", v:" + note.getVelocity() + "] ");
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Error sleeping");
            }
            this.noteOff(note, n);
        }
        n2 = 900;
        for (n3 = 0; n3 < noteArray2.length; ++n3) {
            note = noteArray2[n3];
            note.setVelocity(45.0f);
            this.playNote(note, n2, n, -1L);
            System.out.println("    Note: " + note + "[ch: " + n + " p:" + note.getPitch() + ", v:" + note.getVelocity() + "] ");
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Error sleeping");
            }
            this.noteOff(note, n);
        }
        n2 = 500;
        for (n3 = 0; n3 < noteArray3.length; ++n3) {
            note = noteArray3[n3];
            note.setVelocity(45.0f);
            this.playNote(note, n2, n, -1L);
            System.out.println("    Note: " + note + "[ch: " + n + " p:" + note.getPitch() + ", v:" + note.getVelocity() + "] ");
            try {
                Thread.sleep(n2);
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Error sleeping");
            }
            this.noteOff(note, n);
        }
    }

    public void playSamples(int n, int n2) {
        Note[] noteArray = new Note[]{new Note("C2"), new Note("D2"), new Note("E2")};
        Note[] noteArray2 = new Note[]{new Note("A0"), new Note("B0"), new Note("E0"), new Note("_"), new Note("_"), new Note("."), new Note("."), new Note("."), new Note("G0"), new Note("A1"), new Note("B1"), new Note("E1"), new Note("G2"), new Note("A3"), new Note("E3"), new Note("A2")};
        for (int i = 0; i < 16; ++i) {
            Note note;
            int n3;
            Patch patch = this.currentPatchSet[i];
            int n4 = patch.getBank() * 16 + patch.getProgram();
            System.out.println(" Ch: " + i + " {" + patch.getBank() + ", " + patch.getProgram() + "] " + this.loadedInstruments[n4]);
            for (n3 = 0; n3 < noteArray.length; ++n3) {
                note = noteArray[n3];
                note.setVelocity(20 * (n3 + 1));
                this.playNote(note, 400, i, -1L);
                System.out.println("    Note: " + note + "[ch: " + i + " p:" + note.getPitch() + ", v:" + note.getVelocity() + "] ");
                try {
                    Thread.sleep(n);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Error sleeping");
                }
                this.noteOff(note, i);
            }
            for (n3 = 0; n3 < 2 * noteArray2.length; ++n3) {
                if (n3 < noteArray2.length) {
                    note = noteArray2[n3];
                    note.setVelocity(Math.min(72, 12 * (n3 + 1)));
                    this.playNote(note, 400, i, -1L);
                    System.out.println(" Note: " + note);
                } else {
                    note = noteArray2[n3 - noteArray2.length];
                    this.noteOff(note, i);
                }
                try {
                    Thread.sleep(n);
                    continue;
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Error sleeping");
                }
            }
            System.out.println();
            try {
                Thread.sleep(n2);
                continue;
            }
            catch (InterruptedException interruptedException) {
                System.out.println("Error sleeping");
            }
        }
    }

    public static void main(String[] stringArray) {
        MidiStuff midiStuff = new MidiStuff(new Orrery());
        if (stringArray.length > 0) {
            if (stringArray[0].equals("bank")) {
                int n = Integer.parseInt(stringArray[1]);
                int n2 = Integer.parseInt(stringArray[2]);
                midiStuff.playBank(n, n2);
            } else if (stringArray[0].equals("inst")) {
                int n = Integer.parseInt(stringArray[1]);
                int n3 = Integer.parseInt(stringArray[2]);
                midiStuff.playInst(n, n3);
            } else {
                midiStuff.playSamples(300, 800);
            }
        }
        System.exit(0);
    }
}

