/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.util.Iterator;
import kepler.Body;
import kepler.Note;
import kepler.Orrery;
import kepler.Playable;
import kepler.Scale;

public class Melody
extends Scale {
    protected int cursor = -1;
    protected boolean wrap = true;
    protected Scale scale = null;

    public Melody(Scale scale) {
        super(scale.getName());
        this.scale = scale;
        this.cursor = 0;
    }

    public String getType() {
        return "melody";
    }

    public Scale getScale() {
        return this.scale;
    }

    public Playable duplicate() {
        return new Melody((Scale)this.scale.duplicate());
    }

    public Note nextNote(Body body, Orrery orrery) {
        return this.next();
    }

    public boolean atEnd() {
        return this.cursor >= this.length();
    }

    public void reset() {
        this.reset(0);
    }

    public void writeBody(StringBuffer stringBuffer) {
        this.scale.writeBody(stringBuffer);
    }

    public void writeCurrentState(StringBuffer stringBuffer) {
        int n = 0;
        Iterator iterator = this.scale.notes.iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            boolean bl = false;
            if (this.cursor == n) {
                bl = true;
            }
            if (bl) {
                stringBuffer.append("[");
            }
            note.writeBody(stringBuffer);
            if (bl) {
                stringBuffer.append("]");
            }
            stringBuffer.append(" ");
            ++n;
        }
        stringBuffer.append("end");
    }

    public void reset(int n) {
        this.cursor = n;
    }

    public int length() {
        return this.scale.length();
    }

    public Note next() {
        int n;
        if (this.cursor == -1) {
            this.cursor = 0;
        }
        if (this.cursor >= (n = this.length())) {
            this.cursor -= n;
        }
        Note note = this.scale.getNote(this.cursor);
        ++this.cursor;
        return note;
    }

    public String toString() {
        return this.toString(-1);
    }

    public String toString(int n) {
        StringBuffer stringBuffer = new StringBuffer();
        this.toString(stringBuffer, n);
        return stringBuffer.toString();
    }

    public void toString(StringBuffer stringBuffer) {
        this.toString(stringBuffer, -1);
    }

    public void toString(StringBuffer stringBuffer, int n) {
        stringBuffer.append("Melody[");
        stringBuffer.append(this.name);
        stringBuffer.append("] {");
        int n2 = 0;
        Iterator iterator = this.scale.notes.iterator();
        while (iterator.hasNext()) {
            Note note = (Note)iterator.next();
            if (n == n2) {
                stringBuffer.append("<");
            }
            note.toString(stringBuffer);
            if (n == n2) {
                stringBuffer.append(">");
            }
            if (iterator.hasNext()) {
                stringBuffer.append(" ");
            }
            ++n2;
        }
        stringBuffer.append("}");
    }
}

