/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Iterator;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import kepler.BottomControlsPanel;
import kepler.ControlPanel;
import kepler.Kepler;
import kepler.KioskTitleControlPanel;
import kepler.MissionControlPanel;
import kepler.Playlist;
import kepler.PlaylistManager;
import kepler.WorldBuilder;

public class KioskControlPanel
extends ControlPanel {
    private JPanel physicsPanel = null;
    private JPanel musicPanel = null;
    private JToggleButton physicsMusicToggle = null;
    private Color physicsBG;
    private Color musicBG;
    private WorldBuilder worldBuilder;
    private MissionControlPanel missionControlPanel;
    private BottomControlsPanel bottomControls;
    private JLabel worldStateLabel;
    private JButton prevWorldButton;
    private JButton nextWorldButton;
    JComboBox playlistDrop = null;
    JComboBox playlistSelectorDrop = null;
    boolean playlistDropActive = false;
    boolean playlistSelectorDropActive = false;

    public KioskControlPanel(Kepler kepler, WorldBuilder worldBuilder) {
        super(kepler);
        this.worldBuilder = worldBuilder;
        this.setPanel(this.makePanel(kepler, worldBuilder));
    }

    public JPanel makePanel(Kepler kepler, WorldBuilder worldBuilder) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setMinimumSize(new Dimension(256, 300));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add(new KioskTitleControlPanel(kepler).getPanel());
        this.physicsPanel = this.makePhysicsPanel(kepler);
        this.musicPanel = this.makeMusicPanel(worldBuilder);
        this.musicPanel.setSize(new Dimension(252, 300));
        this.musicPanel.setMaximumSize(new Dimension(252, 300));
        ++gridBagConstraints.gridy;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.physicsMusicToggle = this.makePhysicsMusicToggle(kepler, this.physicsPanel, this.musicPanel);
        gridBagConstraints.insets = new Insets(0, 0, -1, 0);
        gridBagConstraints.weightx = 0.0;
        jPanel.add((Component)this.physicsMusicToggle, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(-3, 0, 0, 0);
        jPanel.add((Component)this.physicsPanel, gridBagConstraints);
        this.physicsPanel.setVisible(true);
        gridBagConstraints.insets = new Insets(-3, 0, 0, 0);
        jPanel.add((Component)this.musicPanel, gridBagConstraints);
        this.musicPanel.setVisible(true);
        ++gridBagConstraints.gridy;
        gridBagConstraints.insets = new Insets(9, 0, 0, 0);
        this.bottomControls = new BottomControlsPanel(kepler);
        jPanel.add((Component)this.bottomControls.getPanel(), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.fill = 0;
        gridBagConstraints.anchor = 10;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        this.worldStateLabel = this.makeTextLabel("");
        this.worldStateLabel.setForeground(this.orrery.countdownColor);
        this.worldStateLabel.setVisible(false);
        jPanel.add((Component)this.worldStateLabel, gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.makeTextLabel(""), gridBagConstraints);
        ++gridBagConstraints.gridy;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.insets = new Insets(0, 0, 0, 0);
        jPanel.add((Component)this.makePlaylistPanel(), gridBagConstraints);
        return jPanel;
    }

    public JPanel makePhysicsPanel_oops(Kepler kepler) {
        this.missionControlPanel = new MissionControlPanel(kepler, this.orrery.physicsBG);
        return this.missionControlPanel.getPanel();
    }

    public JPanel makePhysicsPanel(Kepler kepler) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setSize(new Dimension(256, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        this.missionControlPanel = new MissionControlPanel(kepler, this.orrery.physicsBG);
        jPanel.add((Component)this.missionControlPanel.getPanel(), gridBagConstraints);
        return jPanel;
    }

    JPanel makeMusicPanel_maybe(WorldBuilder worldBuilder) {
        return worldBuilder.getMusicPanel_kiosk(this.kepler);
    }

    JPanel makeMusicPanel(WorldBuilder worldBuilder) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setSize(new Dimension(256, 400));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        jPanel.add((Component)worldBuilder.getMusicPanel_kiosk(this.kepler), gridBagConstraints);
        return jPanel;
    }

    public JToggleButton makePhysicsMusicToggle(Kepler kepler, final JPanel jPanel, final JPanel jPanel2) {
        final JToggleButton jToggleButton = this.makeImageToggleButton("PhysicsMusicToggle_music.gif", "PhysicsMusicToggle_physics.gif", "Change modes");
        jToggleButton.setSelected(true);
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("PHYSICS|MUSIC toggle pressed.");
                boolean bl = jToggleButton.isSelected();
                KioskControlPanel.this.worldBuilder.setShowingPhysicsMode(bl);
                if (bl) {
                    jPanel.setVisible(true);
                    jPanel2.setVisible(false);
                } else {
                    System.out.println("MUSIC toggle pressed.");
                    jPanel.setVisible(false);
                    jPanel2.setVisible(true);
                    if (KioskControlPanel.this.worldBuilder.getSelected() == null) {
                        KioskControlPanel.this.worldBuilder.selectNextBodyOrRock();
                    } else {
                        KioskControlPanel.this.worldBuilder.updateSelected();
                    }
                }
            }
        });
        return jToggleButton;
    }

    public JPanel makePlaylistPanel() {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.orrery.controlPanelBG);
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.prevWorldButton = this.makeImageButton("PrevWorld.gif", "PrevWorld_pressed.gif", "PrevWorld_disabled.gif", "Switch to previous world.");
        this.prevWorldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KioskControlPanel.this.orrery.resetPlayTimer();
                KioskControlPanel.this.kepler.playPrev();
            }
        });
        this.nextWorldButton = this.makeImageButton("NextWorld.gif", "NextWorld_pressed.gif", "NextWorld_disabled.gif", "Switch to next world.");
        this.nextWorldButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                KioskControlPanel.this.orrery.resetPlayTimer();
                KioskControlPanel.this.kepler.playNext();
            }
        });
        PlaylistManager playlistManager = this.kepler.getPlaylistManager();
        if (playlistManager.numPlaylists() > 1) {
            System.out.println("make playlist panel: making playlist selector dorp down");
            this.playlistSelectorDrop = this.makeDropDown();
            ArrayList arrayList = playlistManager.getPlaylists();
            Iterator iterator = arrayList.iterator();
            while (iterator.hasNext()) {
                Playlist playlist = (Playlist)iterator.next();
                String string = playlist.getTitle();
                if (string == null) {
                    string = "";
                }
                this.playlistSelectorDrop.addItem(string);
                this.playlistSelectorDrop.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent actionEvent) {
                        if (KioskControlPanel.this.playlistSelectorDropActive) {
                            JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                            String string = (String)jComboBox.getSelectedItem();
                            PlaylistManager playlistManager = KioskControlPanel.this.kepler.getPlaylistManager();
                            Playlist playlist = playlistManager.getPlaylistByTitle(string);
                            System.out.println("*** playlistSelector. getPlByTitle(" + string + ") => " + playlist);
                            if (playlist != null) {
                                KioskControlPanel.this.populatePlaylistDrop(playlist);
                                playlistManager.placePlaylistOnDeck(playlist);
                                Playlist.Item item = playlistManager.getOnDeckItem();
                                System.out.println("calling kepler.playItem(" + item + ")");
                                KioskControlPanel.this.kepler.playWorld(item);
                            }
                        }
                    }
                });
            }
        }
        this.playlistDrop = this.makeDropDown();
        this.playlistDrop.addItem("");
        this.playlistDrop.setSelectedItem("");
        this.playlistDrop.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                if (KioskControlPanel.this.playlistDropActive) {
                    JComboBox jComboBox = (JComboBox)actionEvent.getSource();
                    Playlist.Item item = (Playlist.Item)jComboBox.getSelectedItem();
                    System.out.println("calling kepler.playItem(" + item + ")");
                    KioskControlPanel.this.kepler.playWorld(item);
                }
            }
        });
        gridBagConstraints.gridy = 0;
        System.out.println("playlistselecgtor drop: " + this.playlistSelectorDrop);
        if (this.playlistSelectorDrop != null) {
            gridBagConstraints.gridx = 0;
            jPanel.add((Component)this.makeTextLabel("Playlist"), gridBagConstraints);
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.anchor = 17;
            gridBagConstraints.fill = 2;
            jPanel.add((Component)this.playlistSelectorDrop, gridBagConstraints);
            ++gridBagConstraints.gridy;
        }
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 1;
        jPanel.add((Component)this.prevWorldButton, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.playlistDrop, gridBagConstraints);
        ++gridBagConstraints.gridx;
        jPanel.add((Component)this.nextWorldButton, gridBagConstraints);
        return jPanel;
    }

    public void worldRead() {
        System.out.println("KIOSK CONTROL world read.");
        this.playlistDropActive = false;
        this.playlistSelectorDropActive = false;
        this.playlistDrop.removeAllItems();
        PlaylistManager playlistManager = this.kepler.getPlaylistManager();
        Playlist playlist = playlistManager.getOnDeckPlaylist();
        System.out.println("  playlist size: " + playlist.size());
        if (this.playlistSelectorDrop != null) {
            this.playlistSelectorDrop.setSelectedItem(playlist.getTitle());
        }
        this.populatePlaylistDrop(playlist);
        System.out.println("orrery.world file: " + this.orrery.getWorldFile());
        String string = this.orrery.getWorldFile();
        Playlist.Item item = playlistManager.getCurrentItem();
        this.playlistDrop.setSelectedItem(item);
        this.playlistDropActive = true;
        this.playlistSelectorDropActive = true;
        this.missionControlPanel.worldRead();
        this.worldBuilder.worldRead();
        this.bottomControls.worldRead();
    }

    private void populatePlaylistDrop(Playlist playlist) {
        System.out.println("PopulatePlaylistDrop:");
        Iterator iterator = playlist.getUnshuffledItems().iterator();
        while (iterator.hasNext()) {
            Playlist.Item item = (Playlist.Item)iterator.next();
            System.out.println("   world: " + item);
            this.playlistDrop.addItem(item);
        }
    }

    public void setMode(String string, boolean bl) {
        this.missionControlPanel.setMode(string, bl);
        this.worldBuilder.setMode(string, bl);
        this.bottomControls.setMode(string, bl);
        if (!string.equals("pause") && !string.equals("initialconditions")) {
            if (string.equals("worldtransition")) {
                this.nextWorldButton.setEnabled(!bl);
                this.prevWorldButton.setEnabled(!bl);
                this.playlistDrop.setEnabled(!bl);
                this.worldStateLabel.setVisible(bl);
            } else if (string.equals("worldending")) {
                if (bl) {
                    this.worldStateLabel.setText("World Ending!");
                } else {
                    this.worldStateLabel.setText("");
                }
            } else if (string.equals("worldstarting")) {
                if (bl) {
                    this.worldStateLabel.setText("World Starting!");
                } else {
                    this.worldStateLabel.setText("");
                }
            }
        }
    }

    public void dawnOfCreation() {
    }

    public void endOfTheWorld() {
    }
}

