/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import com.sun.j3d.utils.applet.MainFrame;
import java.applet.Applet;
import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import javax.swing.JLabel;
import kepler.Kepler;
import kepler.KioskControlPanel;
import kepler.Playlist;
import kepler.PlaylistManager;
import kepler.WorldBuilder;
import util.TokenReader;

public class KeplerApplet
extends Applet {
    protected Container drawingPane;
    private boolean loopPlaylist = true;
    private String playlistName = "";
    private ArrayList playlistNames = null;
    private boolean shuffle = false;
    private int playTimeLow = 60;
    private int playTimeHigh = 90;
    private int cycleTime = 0;
    private int canvas = 600;
    private Kepler kepler = null;
    private HashMap localParams = null;

    public String getLocalParameter(String string) {
        if (this.localParams == null) {
            return null;
        }
        return (String)this.localParams.get(string);
    }

    public void setLocalParameter(String string, String string2) {
        if (this.localParams == null) {
            this.localParams = new HashMap();
        }
        this.localParams.put(string, string2);
    }

    public String getParameter(String string) {
        String string2 = this.getLocalParameter(string);
        if (string2 == null) {
            string2 = super.getParameter(string);
        }
        return string2;
    }

    public String getParameter(String string, String string2) {
        String string3 = this.getParameter(string);
        if (string3 == null) {
            string3 = string2;
        }
        return string3;
    }

    public ArrayList getStringListParameter(String string, char c, ArrayList arrayList) {
        String string2 = this.getParameter(string);
        if (string2 == null) {
            return arrayList;
        }
        ArrayList arrayList2 = this.splitString(string2, c);
        return arrayList2;
    }

    private ArrayList splitString(String string, char c) {
        TokenReader tokenReader = TokenReader.makeStringTokenReader(string);
        ArrayList<String> arrayList = new ArrayList<String>();
        try {
            String string2 = tokenReader.readToken();
            while (string2 != null) {
                arrayList.add(string2);
                string2 = tokenReader.readToken();
            }
        }
        catch (IOException iOException) {
            System.out.println("KeplerApplet caught exception splitting string " + string + ": " + iOException);
        }
        return arrayList;
    }

    public int getIntParameter(String string, int n) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Integer.parseInt(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return n;
    }

    public float getFloatParameter(String string, float f) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Float.parseFloat(string2);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return f;
    }

    public boolean getBooleanParameter(String string, boolean bl) {
        String string2 = this.getParameter(string);
        if (string2 != null) {
            try {
                return Boolean.valueOf(string2);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return bl;
    }

    public void start() {
        this.canvas = this.getIntParameter("canvas", this.canvas);
        this.playlistNames = this.getStringListParameter("playlist", ' ', new ArrayList());
        String string = this.getParameter("time");
        if (string != null) {
            int n;
            this.playTimeLow = n = this.getIntParameter("time", this.playTimeLow);
            this.playTimeHigh = n;
        }
        this.cycleTime = this.getIntParameter("cycletime", 0);
        this.shuffle = this.getBooleanParameter("shuffle", this.shuffle);
        this.loopPlaylist = this.getBooleanParameter("loop", this.loopPlaylist);
        float f = this.getFloatParameter("info", 1.0f);
        boolean bl = true;
        PlaylistManager playlistManager = new PlaylistManager();
        this.readPlaylists(playlistManager, this.playlistNames);
        this.kepler = new Kepler(this.canvas, playlistManager, bl);
        KeplerApplet keplerApplet = this;
        keplerApplet.kepler.setLookAndFeel();
        Kepler.prependIconDir("applet");
        this.drawingPane = this.kepler.drawer.getDrawingPane();
        this.kepler.initOrrery();
        Kepler.setTheme(this.kepler.orrery);
        this.kepler.orrery.setInitialDisplayInfoSeconds(f);
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 3;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weightx = 0.0;
        this.add((Component)this.drawingPane, gridBagConstraints);
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 3;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JLabel(""), gridBagConstraints);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 2, 10, 5);
        WorldBuilder worldBuilder = new WorldBuilder(this.kepler, this.kepler.orrery.buildBG);
        this.kepler.orrery.setWorldBuilder(worldBuilder);
        this.kepler.setWorldBuilder(worldBuilder);
        KioskControlPanel kioskControlPanel = new KioskControlPanel(this.kepler, worldBuilder);
        this.kepler.controlPanels.add(kioskControlPanel);
        this.add((Component)kioskControlPanel.getPanel(), gridBagConstraints);
        kioskControlPanel.show();
        playlistManager.setLoop(this.loopPlaylist);
        playlistManager.setShuffle(this.shuffle);
        playlistManager.compactPlaylists();
        playlistManager.reset();
        this.kepler.setTrails(0);
        this.setBackground(this.kepler.orrery.bgColor);
        this.addKeyListener(this.kepler);
        if (this.cycleTime > 0) {
            this.kepler.orrery.setCycleTime(this.cycleTime);
        }
        this.kepler.setPlayTimes(this.playTimeLow, this.playTimeHigh);
        this.kepler.startKepling();
    }

    private void readPlaylists(PlaylistManager playlistManager, ArrayList arrayList) {
        Iterator iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            System.out.println(" ADDING playlist: " + string);
            Playlist playlist = new Playlist();
            playlistManager.addPlaylist(playlist);
            try {
                Kepler.readPlaylistFile(string, playlist);
            }
            catch (IOException iOException) {
                System.out.println("Caught exception reading playlist: " + string);
                iOException.printStackTrace();
            }
        }
        System.out.println("APPLET read playlists. ->" + playlistManager.numPlaylists());
    }

    public void stop() {
        if (this.kepler != null) {
            this.kepler.orrery.midiAllOff();
            this.kepler.orrery.stopDrawingThread();
            this.kepler.stopKepling();
        }
    }

    public static void main(String[] stringArray) {
        KeplerApplet keplerApplet = new KeplerApplet();
        keplerApplet.setLocalParameter("canvas", "680");
        keplerApplet.setLocalParameter("time", "80");
        keplerApplet.setLocalParameter("loop", "true");
        keplerApplet.setLocalParameter("shuffle", "true");
        keplerApplet.setLocalParameter("playlist", "http://art.net/simran/GenerativeMusic/Kepler/Worlds/artdotnet_music.kpl http://art.net/simran/GenerativeMusic/Kepler/Worlds/artdotnet_symmetries.kpl http://art.net/simran/GenerativeMusic/Kepler/Worlds/artdotnet_exercises.kpl");
        new MainFrame((Applet)keplerApplet, 950, 780);
    }
}

