/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Component;
import java.awt.Container;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.ImageIcon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.metal.MetalLookAndFeel;
import kepler.ControlPanel;
import kepler.KioskControlPanel;
import kepler.MidiStuff;
import kepler.MissionControlPanel;
import kepler.Orrery;
import kepler.Playlist;
import kepler.PlaylistManager;
import kepler.ThemeKepler;
import kepler.WorldBuilder;
import util.StdDraw;
import util.TokenReader;

public class Kepler
implements ActionListener,
KeyListener {
    protected Orrery orrery;
    protected WorldBuilder worldBuilder = null;
    protected MidiStuff midiStuff;
    protected IndraThread indraThread;
    protected boolean fullscreen = false;
    protected boolean decorated = false;
    protected JFrame frame;
    protected Container drawingPane;
    protected ArrayList controlPanels;
    StdDraw drawer;
    TokenReader reader;
    protected double dt = 75.0;
    protected int playTimeLo = 0;
    protected int playTimeHi = 0;
    protected PlaylistManager playlistManager = null;
    private int initialPause = 0;
    protected int trails = 0;
    protected int saved_trails = 0;
    protected boolean reloadWorld = false;
    protected String targetDirectory = null;
    protected boolean kioskMode = true;
    protected boolean showMenuBar = false;
    protected static ArrayList iconPath;
    protected static String iconBaseDir;
    private static int controlButtonSize;
    List runtimeKeysHelp = null;
    static /* synthetic */ Class class$kepler$Kepler;

    public Kepler(int n, PlaylistManager playlistManager, boolean bl) {
        this.drawer = new StdDraw(n);
        this.reader = new TokenReader();
        this.kioskMode = bl;
        if (bl) {
            Kepler.prependIconDir("kiosk");
        }
        this.controlPanels = new ArrayList();
        this.playlistManager = playlistManager;
    }

    public void initOrrery() {
        this.orrery = new Orrery(this.reader, this.drawer);
        this.orrery.setKepler(this);
        this.orrery.setRepaintComponent(this.drawer.getDrawingPane());
    }

    public Orrery getOrrery() {
        return this.orrery;
    }

    public void setWorldBuilder(WorldBuilder worldBuilder) {
        this.worldBuilder = worldBuilder;
    }

    public WorldBuilder getWorldBuilder() {
        return this.worldBuilder;
    }

    private static void setupControlPanels(Kepler kepler) {
        WorldBuilder worldBuilder = new WorldBuilder(kepler, kepler.orrery.buildBG);
        kepler.orrery.setWorldBuilder(worldBuilder);
        kepler.orrery.addNoteListener(worldBuilder);
        kepler.setWorldBuilder(worldBuilder);
        if (kepler.kioskMode()) {
            kepler.controlPanels.add(new KioskControlPanel(kepler, worldBuilder));
        } else {
            MissionControlPanel missionControlPanel = new MissionControlPanel(kepler, kepler.orrery.playBG);
            if (kepler.targetDirectory != null) {
                worldBuilder.targetDirectory = kepler.targetDirectory;
            }
            kepler.controlPanels.add(missionControlPanel);
            kepler.controlPanels.add(worldBuilder);
        }
    }

    public static JFrame recreateFrame(JFrame jFrame, Kepler kepler, StdDraw stdDraw, boolean bl) {
        jFrame = new JFrame();
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
            SwingUtilities.updateComponentTreeUI(jFrame);
        }
        catch (Exception exception) {
            System.err.println("Could not load LookAndFeel: " + exception);
            exception.printStackTrace();
            System.out.println(" System LAF classname: " + UIManager.getSystemLookAndFeelClassName());
            System.out.println(" System CP LAF classname: " + UIManager.getCrossPlatformLookAndFeelClassName());
        }
        jFrame.setBackground(kepler.orrery.controlPanelBG);
        KeplerWindowListener keplerWindowListener = new KeplerWindowListener(kepler);
        jFrame.addWindowListener(keplerWindowListener);
        jFrame.addWindowStateListener(keplerWindowListener);
        kepler.drawingPane = stdDraw.getDrawingPane();
        jFrame.setVisible(false);
        Kepler.setupControlPanels(kepler);
        Container container = jFrame.getContentPane();
        if (container instanceof JComponent) {
            ((JComponent)container).setOpaque(false);
        }
        container.setLayout(new GridBagLayout());
        container.setBackground(kepler.orrery.controlPanelBG);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 0.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.insets = new Insets(0, 0, 10, 0);
        gridBagConstraints.anchor = 18;
        container.add((Component)kepler.drawingPane, gridBagConstraints);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        JLabel jLabel = new JLabel("");
        gridBagConstraints.fill = 3;
        container.add((Component)jLabel, gridBagConstraints);
        jFrame.setResizable(bl);
        jFrame.setUndecorated(!bl);
        jFrame.setDefaultCloseOperation(3);
        jFrame.setTitle("Kepler's Orrery");
        JPanel jPanel = null;
        if (!kepler.kioskMode()) {
            gridBagConstraints.gridx = 2;
            gridBagConstraints.gridy = 1;
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 15;
            jPanel = new JPanel();
            jPanel.setBackground(kepler.orrery.controlPanelBG);
            jPanel.setLayout(new GridBagLayout());
            jPanel.setSize(controlButtonSize, controlButtonSize * kepler.controlPanels.size());
            container.add((Component)jPanel, gridBagConstraints);
        }
        ++gridBagConstraints.gridx;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 1.0;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.insets = new Insets(0, 0, 2, 0);
        container.add((Component)new JLabel(""), gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = null;
        if (!kepler.kioskMode()) {
            gridBagConstraints2 = new GridBagConstraints();
            gridBagConstraints2.gridx = 0;
            gridBagConstraints2.gridy = 0;
            gridBagConstraints2.anchor = 15;
            gridBagConstraints2.weighty = 1.0;
            jPanel.add((Component)new JLabel(""), gridBagConstraints2);
            gridBagConstraints2.weighty = 0.0;
        }
        if (kepler.kioskMode()) {
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = -1;
        }
        Iterator iterator = kepler.controlPanels.iterator();
        while (iterator.hasNext()) {
            ControlPanel controlPanel = (ControlPanel)iterator.next();
            if (kepler.kioskMode()) {
                ++gridBagConstraints.gridy;
                gridBagConstraints.gridheight = 1;
                gridBagConstraints.anchor = 12;
                gridBagConstraints.insets = new Insets(10, 5, 10, 30);
                gridBagConstraints.fill = 1;
                container.add((Component)controlPanel.getPanel(), gridBagConstraints);
                continue;
            }
            ++gridBagConstraints.gridx;
            gridBagConstraints.gridy = 0;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.anchor = 11;
            container.add((Component)new JLabel(""), gridBagConstraints);
            gridBagConstraints.gridy = 1;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.insets = new Insets(0, 2, 10, 5);
            gridBagConstraints.anchor = 11;
            gridBagConstraints.fill = 3;
            container.add((Component)controlPanel.getPanel(), gridBagConstraints);
            controlPanel.hide();
            JToggleButton jToggleButton = kepler.createControlButton(controlPanel);
            ++gridBagConstraints2.gridy;
            gridBagConstraints2.insets = new Insets(0, 0, 2, 0);
            jPanel.add((Component)jToggleButton, gridBagConstraints2);
            JLabel jLabel2 = new JLabel("  ");
            jLabel.setSize(controlButtonSize, controlButtonSize);
            ++gridBagConstraints2.gridy;
            jPanel.add((Component)jLabel2, gridBagConstraints2);
        }
        jFrame.pack();
        return jFrame;
    }

    public void repack() {
        if (this.frame != null && !this.fullscreen) {
            this.frame.pack();
        }
    }

    private JToggleButton createControlButton(ControlPanel controlPanel) {
        ImageIcon imageIcon = Kepler.createImageIcon("plus20.gif", "Open Control Panel");
        ImageIcon imageIcon2 = Kepler.createImageIcon("minus20.gif", "Close control panel");
        JToggleButton jToggleButton = new JToggleButton(imageIcon);
        jToggleButton.setBorderPainted(false);
        jToggleButton.setPressedIcon(imageIcon2);
        jToggleButton.setSelectedIcon(imageIcon2);
        jToggleButton.setSize(controlButtonSize, controlButtonSize);
        jToggleButton.setBackground(this.orrery.bgColor);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setContentAreaFilled(false);
        jToggleButton.setOpaque(true);
        jToggleButton.addActionListener(new ControlButtonActionListener(controlPanel, jToggleButton));
        return jToggleButton;
    }

    public static void prependIconDir(String string) {
        iconPath.add(0, iconBaseDir + "/" + string);
    }

    public static void prependIconPath(String string) {
        iconPath.add(0, string);
    }

    public static ImageIcon createImageIcon(String string, String string2) {
        Iterator iterator = iconPath.iterator();
        while (iterator.hasNext()) {
            String string3;
            String string4;
            URL uRL = (class$kepler$Kepler == null ? Kepler.class$("kepler.Kepler") : class$kepler$Kepler).getResource(string4 = (string3 = (String)iterator.next()) + "/" + string);
            if (uRL == null) continue;
            return new ImageIcon(uRL, string2);
        }
        System.err.println("Couldn't find icon file: " + string);
        return null;
    }

    public void repaint() {
        this.frame.repaint();
    }

    public void addControlPanel(ControlPanel controlPanel) {
        if (this.controlPanels == null) {
            this.controlPanels = new ArrayList();
        }
        this.controlPanels.add(controlPanel);
    }

    public void setPlayTimes(int n, int n2) {
        this.playTimeLo = n;
        this.playTimeHi = n2;
        this.orrery.setPlayTimes(n, n2);
    }

    public void setTrails(int n) {
        this.trails = n;
        this.orrery.setTrails(n);
    }

    public boolean kioskMode() {
        return this.kioskMode;
    }

    public PlaylistManager getPlaylistManager() {
        return this.playlistManager;
    }

    public void setDt(double d) {
        this.dt = d;
    }

    public void startKepling() {
        this.drawer.postDisplayInit();
        if (this.indraThread == null) {
            this.indraThread = new IndraThread(this, this.dt);
            this.setPaused(false);
            this.indraThread.start();
        }
    }

    public void stopKepling() {
        this.stopIndraThread();
    }

    public void stopIndraThread() {
        if (this.indraThread != null) {
            this.indraThread.halt();
        }
    }

    public void playPrev() {
        if (this.indraThread == null) {
            return;
        }
        this.playlistManager.placePrevOnDeck();
        this.reloadWorld = true;
        this.setMode("worldtransition", true);
        this.orrery.winkOut();
        this.orrery.possiblyResetPlayCycles();
    }

    public void playNext() {
        System.out.println("Kepler: playNext()");
        this.setMode("worldtransition", true);
        this.orrery.winkOut();
        this.orrery.possiblyResetPlayCycles();
    }

    public void playWorld(Playlist.Item item) {
        if (this.indraThread == null) {
            return;
        }
        this.playlistManager.placeItemOnDeck(item);
        this.reloadWorld = true;
        this.setMode("worldtransition", true);
        this.orrery.winkOut();
        this.orrery.possiblyResetPlayCycles();
        this.orrery.resetPlayTimer();
    }

    public void reloadWorld() {
        System.out.println("Kepler: reloadWorld()");
        this.reloadWorld = true;
        this.playNext();
    }

    public void setPaused(boolean bl) {
        this.orrery.setPaused(bl);
        this.setMode("pause", bl);
    }

    public void setMode(String string, boolean bl) {
        Iterator iterator = this.controlPanels.iterator();
        while (iterator.hasNext()) {
            ControlPanel controlPanel = (ControlPanel)iterator.next();
            controlPanel.setMode(string, bl);
        }
    }

    public void winkOut() {
        this.orrery.winkOut();
    }

    public JMenuBar createMenuBar() {
        JMenuBar jMenuBar = new JMenuBar();
        JMenu jMenu = new JMenu("File");
        jMenuBar.add(jMenu);
        JMenuItem jMenuItem = new JMenuItem("Save...   ");
        jMenuItem.addActionListener(this);
        jMenuItem.setAccelerator(KeyStroke.getKeyStroke(83, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem);
        JMenuItem jMenuItem2 = new JMenuItem("Pause...   ");
        jMenuItem2.addActionListener(this);
        jMenuItem2.setAccelerator(KeyStroke.getKeyStroke(80, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem2);
        JMenuItem jMenuItem3 = new JMenuItem("Resume...   ");
        jMenuItem3.addActionListener(this);
        jMenuItem3.setAccelerator(KeyStroke.getKeyStroke(82, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem3);
        JMenuItem jMenuItem4 = new JMenuItem("Next...   ");
        jMenuItem4.addActionListener(this);
        jMenuItem4.setAccelerator(KeyStroke.getKeyStroke(78, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem4);
        JMenuItem jMenuItem5 = new JMenuItem("FullScreen...   ");
        jMenuItem5.addActionListener(this);
        jMenuItem5.setAccelerator(KeyStroke.getKeyStroke(70, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem5);
        JMenuItem jMenuItem6 = new JMenuItem("Quit...   ");
        jMenuItem6.addActionListener(this);
        jMenuItem6.setAccelerator(KeyStroke.getKeyStroke(81, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()));
        jMenu.add(jMenuItem6);
        return jMenuBar;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        System.out.println("KEPLER  action command: " + string);
        if (string.equals("Quit...   ")) {
            System.exit(0);
        } else if (string.equals("FullScreen...   ")) {
            this.toggleFullScreen();
        } else if (string.equals("Pause...   ")) {
            System.out.println("We should pause...?");
            this.orrery.pause();
        } else if (string.equals("Resume...   ")) {
            System.out.println("We should resume...?");
            this.orrery.resume();
        } else if (string.equals("Next...   ")) {
            this.playNext();
        } else if (string.equals("Quit...   ")) {
            System.out.println("bye bye plane!");
        } else if (string.equals("Save...   ")) {
            this.saveDrawing();
        }
    }

    public void toggleFullScreen() {
        System.out.println("Toggling fullscreen: [" + this.fullscreen + "]");
        this.setFullScreen(!this.fullscreen);
    }

    public void setFullScreen(boolean bl) {
        this.fullscreen = bl;
        StdDraw.fullscreen(this.frame, this.fullscreen);
    }

    public void toggleTrails() {
        if (this.trails == 0) {
            this.trails = this.saved_trails == 0 ? 25 : this.saved_trails;
        } else {
            this.saved_trails = this.trails;
            this.trails = 0;
        }
        this.setTrails(this.trails);
    }

    public void setTrails(boolean bl) {
        if (bl) {
            if (this.trails == 0) {
                this.trails = this.saved_trails == 0 ? 25 : this.saved_trails;
            }
        } else {
            this.saved_trails = this.trails;
            this.trails = 0;
        }
        this.setTrails(this.trails);
    }

    public void saveDrawing() {
        FileDialog fileDialog = new FileDialog((Frame)this.frame, "Use a .png or .jpg extension", 1);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            this.drawer.save(fileDialog.getDirectory() + File.separator + fileDialog.getFile());
        }
    }

    public void keyTyped(KeyEvent keyEvent) {
    }

    public void keyPressed(KeyEvent keyEvent) {
    }

    public void keyReleased(KeyEvent keyEvent) {
        System.out.println("KEPLER got KeyEvent: [" + keyEvent.getKeyChar() + "]");
        System.out.println("KEPLER got KeyEvent: " + keyEvent);
        char c = keyEvent.getKeyChar();
        if (c == 'Q') {
            this.orrery.setMuted(true);
            this.orrery.stopDrawingThread();
            this.stopKepling();
            System.exit(0);
        } else if (c == 'X') {
            this.orrery.midiAllOff();
            this.orrery.stopDrawingThread();
            this.stopKepling();
        } else if (c == 'F') {
            this.toggleFullScreen();
        } else if (c == 'T') {
            this.toggleTrails();
        } else if (c == 'P') {
            this.orrery.togglePause();
        } else if (c == 'M') {
            this.orrery.toggleMuted();
        } else if (c == 'R') {
            this.reloadWorld();
        } else if (c == 'N') {
            this.playNext();
        } else if (c == 'S') {
            this.orrery.midiAllOff();
            this.orrery.stopDrawingThread();
        } else if (c == 'I') {
            this.orrery.toggleInfoDisplay();
        } else if (c == 'V') {
            this.orrery.toggleForceField();
        } else if (c == 'v') {
            this.orrery.toggleBodyForces();
        } else if (c == 'H' || c == 'h' || c == '?') {
            this.orrery.showHelpInfo(this.getRuntimeKeysHelp());
        } else if (c == ' ') {
            this.orrery.hideHelpInfo();
        } else if (c == 'D') {
            int n = this.orrery.getDebugLevel();
            if (++n > 1) {
                n = 0;
            }
            this.orrery.setDebugLevel(n);
        }
    }

    public List getRuntimeKeysHelp() {
        if (this.runtimeKeysHelp == null) {
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("Command Keys:");
            arrayList.add("");
            arrayList.add("  F -- Toggle full screen");
            arrayList.add("  T -- Toggle trails");
            arrayList.add("  P -- Toggle Pause");
            arrayList.add("  D -- Toggle debug info");
            arrayList.add("  V -- Toggle force field.");
            arrayList.add("  v -- Toggle body force vectors.");
            arrayList.add("  I -- Toggle info display.");
            arrayList.add("  R -- Reload world");
            arrayList.add("  N -- Next world");
            arrayList.add("  H, ? -- Show this list");
            arrayList.add("  Q -- Quit");
            arrayList.add("");
            arrayList.add("  Space bar to hide list");
            this.runtimeKeysHelp = arrayList;
        }
        return this.runtimeKeysHelp;
    }

    public static void readPlaylistFile(String string, Playlist playlist) throws IOException {
        System.out.println("Kepler:readPlayListFile(" + string + ")");
        TokenReader tokenReader = new TokenReader(string);
        boolean bl = false;
        String string2 = null;
        while (!bl) {
            String string3 = tokenReader.readToken();
            if (string3 == null) {
                bl = true;
                continue;
            }
            if (string3.equalsIgnoreCase("prefix")) {
                string2 = tokenReader.readToken();
                playlist.setPrefix(string2);
                continue;
            }
            if (string3.equalsIgnoreCase("title")) {
                String string4 = tokenReader.readLine().trim();
                playlist.setTitle(string4);
                continue;
            }
            playlist.add(string3);
        }
    }

    public static void usage() {
        StringBuffer stringBuffer = new StringBuffer();
        Kepler.usage(stringBuffer);
        System.out.println(stringBuffer.toString());
    }

    public static void usage(StringBuffer stringBuffer) {
        stringBuffer.append("java kepler.Kepler [options]*  [WorldFiles]*\n");
        stringBuffer.append("  options:\n");
        stringBuffer.append("    --time <seconds>      Playing time for each world\n");
        stringBuffer.append("    --timerange <low> <high>  Playing time for each world randomly varies \n");
        stringBuffer.append("                          between <low> and <high>\n");
        stringBuffer.append("    --pause <seconds>     Initial pause for each world: after drawing\n");
        stringBuffer.append("                          and before starting the simulation\n");
        stringBuffer.append("    --cycletime <ms>      Minimum time for each increment cycle. \n");
        stringBuffer.append("                          If cycles take less time than specified, the \n");
        stringBuffer.append("                          simulation thread will sleep for the difference.\n");
        stringBuffer.append("    --dt <mtu>            World-coordinate time for each cycle.\n");
        stringBuffer.append("                          (<mtu> is 'mythical time units')\n");
        stringBuffer.append("    --debug               turn on debugging information (mostly prints \n");
        stringBuffer.append("                          notes as they're played)\n");
        stringBuffer.append("    --trails <cycles>     Set fading trails to fade over a specified \n");
        stringBuffer.append("                          number of cycles.\n");
        stringBuffer.append("    --forcefield          Show force vectors.\n");
        stringBuffer.append("    --forcefieldgrid <n>  number of vectors.\n");
        stringBuffer.append("    --canvas <pixels>     Canvas size, in pixels\n");
        stringBuffer.append("    --fullscreen          Start in fullscreen mode, with no frame decorations.\n");
        stringBuffer.append("    --undecorated         No frame decorations.\n");
        stringBuffer.append("    --playlist <file>     Specify a playlist. \n");
        stringBuffer.append("                          The playlist comprises the world files specified.\n");
        stringBuffer.append("                          in --playlist arguments concatenated with world.\n");
        stringBuffer.append("                          files specified on the command line, in order.\n");
        stringBuffer.append("    --loop                Loop the playlist. \n");
        stringBuffer.append("    --shuffle             Randomize the order of the playlist.\n");
        stringBuffer.append("    --info <sec>          Set number of seconds to display info at beginning of each world.\n");
        stringBuffer.append("                            0: don't show info; -1: show all the time.");
        stringBuffer.append("    --kiosk               Bring controllers up in kiosk mode.\n");
        stringBuffer.append("\n");
        stringBuffer.append(" Keyboard commands while simulation is running:\n");
        stringBuffer.append("    F  -- Toggle fullscreen mode. If system starts up in fullscreen mode, \n");
        stringBuffer.append("          the frame will be undecorated. \n");
        stringBuffer.append("    P  -- Toggle Pause mode.\n");
        stringBuffer.append("    N  -- Next world. The stars will wink out, the sounds will turn off, and\n");
        stringBuffer.append("          the next world in the playlist will start.\n");
        stringBuffer.append("    S  -- Stop the world. \n");
        stringBuffer.append("          The simulation will stop. But unfortunately, at the moment, \n");
        stringBuffer.append("          the sounds will continue annoyingly. \n");
        stringBuffer.append("    Q  -- Quit.\n");
        stringBuffer.append("    D  -- Toggle debug mode.\n");
        stringBuffer.append("    T  -- Toggle trails. Will turn trails on or off. \n");
    }

    public static void setLookAndFeel() {
        try {
            UIManager.setLookAndFeel(UIManager.getCrossPlatformLookAndFeelClassName());
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
    }

    public static void setTheme(Orrery orrery) {
        ThemeKepler themeKepler = new ThemeKepler(orrery);
        MetalLookAndFeel.setCurrentTheme(themeKepler);
    }

    public static void main(String[] stringArray) {
        Object object;
        PlaylistManager playlistManager = new PlaylistManager();
        Playlist playlist = new Playlist();
        playlistManager.addPlaylist(playlist);
        int n = 0;
        double d = 75.0;
        int n2 = 0;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        boolean bl = false;
        boolean bl2 = false;
        int n7 = 0;
        int n8 = 0;
        boolean bl3 = false;
        int n9 = 0;
        String string = null;
        float f = 0.5f;
        boolean bl4 = true;
        if (stringArray.length == 0) {
            Kepler.usage();
            System.exit(0);
        }
        if (stringArray.length > 0) {
            while (n < stringArray.length) {
                try {
                    Object object2;
                    if (stringArray[n].equalsIgnoreCase("--help") || stringArray[n].equalsIgnoreCase("-h")) {
                        Kepler.usage();
                        System.exit(0);
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--time") || stringArray[n].equalsIgnoreCase("--playtime")) {
                        n4 = n3 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--timerange")) {
                        n3 = Integer.parseInt(stringArray[++n]);
                        n4 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--cycletime")) {
                        n2 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--dt")) {
                        d = Double.parseDouble(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--kiosk")) {
                        ++n;
                        bl4 = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--nokiosk")) {
                        ++n;
                        bl4 = false;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--trails")) {
                        n8 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--forcefield")) {
                        ++n;
                        bl3 = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--forcefieldgrid")) {
                        n9 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--debug")) {
                        ++n;
                        n5 = 1;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--pause")) {
                        n6 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--canvas")) {
                        n7 = Integer.parseInt(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--full") || stringArray[n].equalsIgnoreCase("--fullscreen")) {
                        ++n;
                        bl = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--undecorated")) {
                        ++n;
                        bl2 = true;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--loop")) {
                        ++n;
                        playlistManager.setLoop(true);
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--shuffle")) {
                        ++n;
                        playlistManager.setShuffle(true);
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--shuffle_across")) {
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--noloop")) {
                        ++n;
                        playlistManager.setLoop(false);
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--playlist")) {
                        object = stringArray[++n];
                        ++n;
                        try {
                            object2 = new Playlist();
                            playlistManager.addPlaylist((Playlist)object2);
                            Kepler.readPlaylistFile((String)object, (Playlist)object2);
                        }
                        catch (Exception exception) {
                            System.out.println("Kepler caught exception reading playlist file: " + exception);
                        }
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--info")) {
                        f = Float.parseFloat(stringArray[++n]);
                        ++n;
                        continue;
                    }
                    if (stringArray[n].equalsIgnoreCase("--targetdir")) {
                        string = stringArray[++n];
                        ++n;
                        continue;
                    }
                    object = Playlist.extractName(stringArray[n]);
                    object2 = stringArray[n];
                    playlist.add((String)object, (String)object2);
                    ++n;
                }
                catch (NumberFormatException numberFormatException) {
                    ++n;
                }
            }
        }
        playlistManager.compactPlaylists();
        object = new Kepler(n7, playlistManager, bl4);
        ((Kepler)object).initialPause = n6;
        ((Kepler)object).fullscreen = bl;
        boolean bl5 = ((Kepler)object).decorated = !bl2 && !bl;
        if (string != null) {
            ((Kepler)object).targetDirectory = string;
        }
        ((Kepler)object).initOrrery();
        Kepler.setTheme(((Kepler)object).orrery);
        ((Kepler)object).orrery.setInitialDisplayInfoSeconds(f);
        ((Kepler)object).frame = Kepler.recreateFrame(((Kepler)object).frame, (Kepler)object, ((Kepler)object).drawer, ((Kepler)object).decorated);
        ((Kepler)object).frame.getContentPane().addKeyListener((KeyListener)object);
        ((Kepler)object).drawer.getDrawingPane().addKeyListener((KeyListener)object);
        ((Kepler)object).frame.setBackground(((Kepler)object).orrery.bgColor);
        if (bl) {
            StdDraw cfr_ignored_0 = ((Kepler)object).drawer;
            StdDraw.fullscreen(((Kepler)object).frame, true);
        }
        ((Kepler)object).frame.pack();
        ((Kepler)object).frame.setVisible(true);
        ((Kepler)object).orrery.setDebugLevel(n5);
        if (n2 > 0) {
            ((Kepler)object).orrery.setCycleTime(n2);
        }
        ((Kepler)object).setPlayTimes(n3, n4);
        ((Kepler)object).setTrails(n8);
        if (n9 > 0) {
            ((Kepler)object).orrery.setForceFieldGridVectors(n9);
        }
        ((Kepler)object).orrery.setShowForceField(bl3);
        ((Kepler)object).setDt(d);
        ((Kepler)object).startKepling();
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        iconBaseDir = "images";
        iconPath = new ArrayList();
        Kepler.prependIconDir("base");
        controlButtonSize = 20;
    }

    class IndraThread
    extends Thread {
        public boolean yuga = true;
        protected Kepler kepler;
        protected double dt;

        public IndraThread(Kepler kepler2, double d) {
            this.kepler = kepler2;
            this.dt = d;
        }

        public synchronized void run() {
            this.yuga = true;
            System.out.println("Playlist Loop start");
            this.kepler.playlistManager.reset();
            Kepler.this.orrery = this.kepler.orrery;
            while (Kepler.this.playlistManager.hasOnDeckItem() && this.yuga) {
                ControlPanel controlPanel;
                Playlist.Item item = this.kepler.playlistManager.getOnDeckItem();
                String string = item.getFull();
                System.out.println("\n\n");
                System.out.println("/////////////////////////////////////////////////////////");
                System.out.println("////   Kepler's Orrery.                              ////");
                System.out.print("////     " + string);
                if (string.length() <= 44) {
                    for (int i = 0; i < 44 - string.length(); ++i) {
                        System.out.print(' ');
                    }
                    System.out.println("////");
                } else {
                    System.out.println();
                }
                System.out.println("/////////////////////////////////////////////////////////");
                this.kepler.setMode("worldtransition", true);
                this.kepler.setMode("worldstarting", true);
                Kepler.this.orrery.setDt(this.dt);
                Kepler.this.orrery.clearWorld();
                System.out.println("Setting orrery world file: " + string);
                Kepler.this.orrery.setWorldFile(string);
                Kepler.this.reader.open(string);
                Kepler.this.orrery.clearBG();
                Kepler.this.drawer.initbg(Kepler.this.orrery.bgColor);
                Kepler.this.orrery.readWorld();
                Kepler.this.orrery.copyInitialBodies();
                if (Kepler.this.controlPanels != null) {
                    Iterator iterator = Kepler.this.controlPanels.iterator();
                    while (iterator.hasNext()) {
                        controlPanel = (ControlPanel)iterator.next();
                        controlPanel.worldRead();
                    }
                }
                if (Kepler.this.initialPause > 0) {
                    try {
                        Thread.sleep(1000 * Kepler.this.initialPause);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Error sleeping");
                    }
                }
                Kepler.this.orrery.setupDrawing();
                Kepler.this.orrery.draw_slowly(Kepler.this.orrery.creationDelay);
                this.kepler.setMode("worldstarting", false);
                this.kepler.setMode("worldtransition", false);
                Kepler.this.orrery.startDrawingThread(string);
                if (Kepler.this.controlPanels != null) {
                    Iterator iterator = Kepler.this.controlPanels.iterator();
                    while (iterator.hasNext()) {
                        controlPanel = (ControlPanel)iterator.next();
                        controlPanel.dawnOfCreation();
                    }
                }
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    System.out.println("Error sleeping");
                }
                System.out.println("Kepler: waiting for drawing thread.");
                Kepler.this.orrery.waitForDrawingThread();
                System.out.println("Kepler: done waiting for drawing thread.");
                Kepler.this.reader.close();
                if (Kepler.this.controlPanels != null) {
                    Iterator iterator = Kepler.this.controlPanels.iterator();
                    while (iterator.hasNext()) {
                        controlPanel = (ControlPanel)iterator.next();
                        controlPanel.endOfTheWorld();
                    }
                }
                if (Kepler.this.initialPause > 0) {
                    try {
                        Thread.sleep(1000 * Kepler.this.initialPause / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        System.out.println("Error sleeping");
                    }
                }
                if (!Kepler.this.reloadWorld) {
                    this.kepler.playlistManager.placeNextOnDeck();
                }
                Kepler.this.reloadWorld = false;
            }
            System.exit(0);
        }

        public void halt() {
            this.yuga = false;
        }
    }

    class ControlButtonActionListener
    implements ActionListener {
        private ControlPanel controlPanel;
        private JToggleButton button;

        public ControlButtonActionListener(ControlPanel controlPanel, JToggleButton jToggleButton) {
            this.controlPanel = controlPanel;
            this.button = jToggleButton;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.button.isSelected()) {
                this.controlPanel.show();
            } else {
                this.controlPanel.hide();
            }
        }
    }

    static class KeplerWindowListener
    extends WindowAdapter {
        private Kepler kepler;

        public KeplerWindowListener(Kepler kepler) {
            this.kepler = kepler;
        }

        public void windowStateChanged(WindowEvent windowEvent) {
            System.out.println("\n\n\n KEPLER got window state change.. " + windowEvent);
            System.out.println(" KEPLER got window resize.");
            this.kepler.repack();
        }
    }
}

