/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Insets;
import java.text.NumberFormat;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.MatteBorder;
import kepler.Kepler;
import kepler.Orrery;

public class ControlPanel {
    protected Kepler kepler;
    protected Orrery orrery;
    protected JPanel controlPanel;
    protected int keepWidth = 0;
    protected NumberFormat doublesFormat;

    public ControlPanel(Kepler kepler) {
        this.kepler = kepler;
        this.orrery = kepler.getOrrery();
        this.doublesFormat = NumberFormat.getInstance();
        this.doublesFormat.setMinimumFractionDigits(4);
        this.doublesFormat.setGroupingUsed(false);
    }

    public void setPanel(JPanel jPanel) {
        this.controlPanel = jPanel;
    }

    public JPanel getPanel() {
        return this.controlPanel;
    }

    public void worldRead() {
    }

    public void dawnOfCreation() {
    }

    public void endOfTheWorld() {
    }

    public void setMode(String string, boolean bl) {
    }

    public void show(boolean bl) {
        this.getPanel().setVisible(bl);
    }

    public void show() {
        if (this.keepWidth > 0) {
            this.controlPanel.setSize(this.keepWidth, this.controlPanel.getHeight());
        }
        this.show(true);
        this.kepler.repack();
    }

    public void hide() {
        this.keepWidth = this.getPanel().getWidth();
        this.controlPanel.setSize(0, this.controlPanel.getHeight());
        this.show(false);
    }

    protected JLabel makeTextLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(this.orrery.controlPanelFG);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return jLabel;
    }

    protected JLabel makeValueLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(this.orrery.controlPanelValueFG);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return jLabel;
    }

    protected JLabel makeImageLabel(String string, String string2) {
        JLabel jLabel = new JLabel(Kepler.createImageIcon(string, string2));
        jLabel.setForeground(this.orrery.controlPanelFG);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return jLabel;
    }

    protected JLabel makeTitleLabel(String string) {
        JLabel jLabel = new JLabel(string);
        jLabel.setForeground(this.orrery.titleColor);
        jLabel.setBorder(new EmptyBorder(0, 0, 0, 0));
        return jLabel;
    }

    protected JTextField makeNumberField() {
        JTextField jTextField = new JTextField();
        jTextField.setBorder(new MatteBorder(1, 2, 1, 3, this.orrery.controlPanelValueBG));
        jTextField.setForeground(this.orrery.controlPanelValueFG);
        jTextField.setBackground(this.orrery.controlPanelValueBG);
        jTextField.setColumns(9);
        return jTextField;
    }

    protected JTextField makeTextField(String string, int n) {
        JTextField jTextField = this.makeTextField(string);
        jTextField.setColumns(n);
        return jTextField;
    }

    protected JTextField makeTextField(int n) {
        JTextField jTextField = this.makeTextField();
        jTextField.setColumns(n);
        return jTextField;
    }

    protected JTextField makeTextField(String string) {
        JTextField jTextField = this.makeTextField();
        jTextField.setText(string);
        return jTextField;
    }

    protected JTextField makeTextField() {
        JTextField jTextField = new JTextField();
        jTextField.setBorder(new MatteBorder(1, 2, 1, 3, this.orrery.controlPanelBG));
        jTextField.setForeground(this.orrery.controlPanelValueFG);
        jTextField.setBackground(this.orrery.controlPanelValueBG);
        jTextField.setColumns(12);
        return jTextField;
    }

    protected JTextArea makeTextArea() {
        return this.makeTextArea(5, 20, this.orrery.controlPanelBG, this.orrery.controlPanelValueBG);
    }

    protected JTextArea makeTextArea(int n, int n2, Color color, Color color2) {
        JTextArea jTextArea = new JTextArea(n, n2);
        jTextArea.setLineWrap(true);
        jTextArea.setBorder(new MatteBorder(1, 2, 1, 3, color));
        jTextArea.setForeground(this.orrery.controlPanelValueFG);
        jTextArea.setBackground(color2);
        return jTextArea;
    }

    protected JButton makeTextButton(String string) {
        JButton jButton = new JButton(string);
        jButton.setBorder(new MatteBorder(1, 1, 1, 1, this.orrery.controlPanelFG));
        jButton.setForeground(this.orrery.controlPanelFG);
        jButton.setBackground(this.orrery.controlPanelBG);
        return jButton;
    }

    protected JButton makeImageButton(String string, String string2, String string3, String string4) {
        JButton jButton = this.makeImageButton(string, string2, string4);
        ImageIcon imageIcon = Kepler.createImageIcon(string3, string4);
        jButton.setDisabledIcon(imageIcon);
        return jButton;
    }

    protected JButton makeImageButton(String string, String string2, String string3) {
        JButton jButton = new JButton(Kepler.createImageIcon(string, string3));
        ImageIcon imageIcon = Kepler.createImageIcon(string2, string3);
        jButton.setBorderPainted(false);
        jButton.setPressedIcon(imageIcon);
        jButton.setSelectedIcon(imageIcon);
        jButton.setMargin(new Insets(0, 0, 0, 0));
        jButton.setContentAreaFilled(false);
        return jButton;
    }

    protected JToggleButton makeImageToggleButton(String string, String string2, String string3, String string4) {
        JToggleButton jToggleButton = this.makeImageToggleButton(string, string2, string4);
        ImageIcon imageIcon = Kepler.createImageIcon(string3, string4);
        jToggleButton.setDisabledIcon(imageIcon);
        jToggleButton.setDisabledSelectedIcon(imageIcon);
        return jToggleButton;
    }

    protected JToggleButton makeImageToggleButton(String string, String string2, String string3) {
        JToggleButton jToggleButton = new JToggleButton(Kepler.createImageIcon(string, string3));
        ImageIcon imageIcon = Kepler.createImageIcon(string2, string3);
        jToggleButton.setBorderPainted(false);
        jToggleButton.setPressedIcon(imageIcon);
        jToggleButton.setSelectedIcon(imageIcon);
        jToggleButton.setMargin(new Insets(0, 0, 0, 0));
        jToggleButton.setContentAreaFilled(false);
        return jToggleButton;
    }

    protected JRadioButton makeRadioButton(String string, String string2, String string3) {
        ImageIcon imageIcon = Kepler.createImageIcon(string2, string3);
        ImageIcon imageIcon2 = Kepler.createImageIcon(string, string3);
        JRadioButton jRadioButton = new JRadioButton(imageIcon);
        jRadioButton.setBorderPainted(false);
        jRadioButton.setPressedIcon(imageIcon2);
        jRadioButton.setSelectedIcon(imageIcon2);
        jRadioButton.setMargin(new Insets(0, 0, 0, 0));
        jRadioButton.setContentAreaFilled(false);
        return jRadioButton;
    }

    protected JComboBox makeDropDown() {
        JComboBox jComboBox = new JComboBox();
        jComboBox.setBorder(new MatteBorder(1, 2, 1, 3, this.orrery.controlPanelBG));
        jComboBox.setForeground(this.orrery.controlPanelValueFG);
        jComboBox.setBackground(this.orrery.controlPanelValueBG);
        jComboBox.setLightWeightPopupEnabled(false);
        return jComboBox;
    }

    protected JSlider makeSliderH() {
        JSlider jSlider = new JSlider();
        jSlider.setName("slider");
        jSlider.setPreferredSize(new Dimension(200, 60));
        jSlider.setOrientation(0);
        jSlider.setBackground(this.orrery.controlPanelBG);
        return jSlider;
    }

    protected JSlider makeSliderV() {
        JSlider jSlider = new JSlider();
        jSlider.setName("slider");
        jSlider.setOrientation(1);
        jSlider.setPreferredSize(new Dimension(30, 200));
        jSlider.setMinimumSize(new Dimension(30, 200));
        jSlider.setBackground(this.orrery.controlPanelBG);
        return jSlider;
    }

    public double cookLinearValue(int n, double d, double d2) {
        int n2 = 100;
        int n3 = 0;
        double d3 = d2 - d;
        double d4 = (double)(n - n3) / (double)(n2 - n3);
        double d5 = d4 * d3;
        return d5;
    }

    public int uncookLinearValue(double d, double d2, double d3) {
        int n = 100;
        int n2 = 0;
        double d4 = d3 - d2;
        double d5 = d / d4;
        int n3 = (int)((double)(n - n2) * d5) + n2;
        return n3;
    }

    public double cookFactorValue(int n, int n2, double d) {
        double d2;
        int n3 = 100;
        int n4 = 0;
        if (n < n2) {
            double d3 = n - n4;
            double d4 = n2 - n4;
            d2 = d3 / d4;
        } else {
            double d5 = n - n2;
            double d6 = n3 - n2;
            d2 = 1.0 + (d - 1.0) * d5 / d6;
        }
        return d2;
    }

    public int uncookFactorValue(double d, int n, double d2) {
        double d3;
        int n2 = 100;
        int n3 = 0;
        if (d < 1.0) {
            double d4 = n - n3;
            d3 = d * d4;
        } else {
            double d5 = n2 - n;
            double d6 = d - 1.0;
            d3 = (double)n + d5 * d6 / d2;
        }
        return (int)d3;
    }

    protected int extractInt(JTextField jTextField, String string) throws DataException {
        try {
            int n = Integer.parseInt(jTextField.getText());
            return n;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataException(string, "", numberFormatException);
        }
    }

    protected int extractInt(JTextField jTextField, String string, int n) {
        try {
            int n2 = Integer.parseInt(jTextField.getText());
            return n2;
        }
        catch (NumberFormatException numberFormatException) {
            return n;
        }
    }

    protected float extractFloat(JTextField jTextField, String string) throws DataException {
        try {
            float f = Float.parseFloat(jTextField.getText());
            return f;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataException(string, "", numberFormatException);
        }
    }

    protected float extractFloat(JTextField jTextField, String string, float f) {
        try {
            float f2 = Float.parseFloat(jTextField.getText());
            return f2;
        }
        catch (NumberFormatException numberFormatException) {
            return f;
        }
    }

    protected double extractDouble(JTextField jTextField, String string) throws DataException {
        try {
            double d = Double.parseDouble(jTextField.getText());
            return d;
        }
        catch (NumberFormatException numberFormatException) {
            throw new DataException(string, "", numberFormatException);
        }
    }

    protected double extractDouble(JTextField jTextField, String string, double d) {
        try {
            double d2 = Double.parseDouble(jTextField.getText());
            return d2;
        }
        catch (NumberFormatException numberFormatException) {
            return d;
        }
    }

    protected boolean emptyText(JTextField jTextField) {
        String string = jTextField.getText();
        return string == null || string.equals("");
    }

    protected void displayText(JTextField jTextField, String string) {
        jTextField.setText(string);
    }

    protected void displayText(JTextField jTextField, double d) {
        String string = Math.abs(d) > 1000000.0 ? "" + d : this.doublesFormat.format(d);
        jTextField.setText(string);
    }

    protected void displayText(JTextField jTextField, int n) {
        jTextField.setText("" + n);
    }

    protected void displayText(JTextField jTextField, boolean bl) {
        jTextField.setText("" + bl);
    }

    protected void displayText(JLabel jLabel, String string) {
        jLabel.setText(string);
    }

    protected void displayText(JLabel jLabel, double d) {
        String string = Math.abs(d) > 1000000.0 ? "" + d : this.doublesFormat.format(d);
        jLabel.setText(string);
    }

    protected void displayText(JLabel jLabel, int n) {
        jLabel.setText("" + n);
    }

    protected void displayText(JLabel jLabel, boolean bl) {
        jLabel.setText("" + bl);
    }

    class DataException
    extends Exception {
        String field;

        public DataException(String string, String string2, Throwable throwable) {
            super(string2, throwable);
            this.field = string;
        }

        public String getField() {
            return this.field;
        }
    }
}

