/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JToggleButton;
import javax.swing.border.MatteBorder;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import kepler.ControlPanel;
import kepler.Kepler;
import kepler.WorldBuilder;

public class BottomControlsPanel
extends ControlPanel {
    private JToggleButton resetToggle = null;
    private JButton stepButton = null;
    private JButton nextWorldButton = null;
    private JToggleButton pauseToggle = null;
    private JToggleButton muteToggle = null;
    private JToggleButton fullScreenToggle = null;
    private boolean includeFrameControls = true;
    Color backgroundColor;

    public BottomControlsPanel(Kepler kepler) {
        super(kepler);
        this.setPanel(this.makePanel(kepler));
    }

    public BottomControlsPanel(Kepler kepler, boolean bl) {
        super(kepler);
        this.includeFrameControls = bl;
        this.backgroundColor = kepler.kioskMode() ? this.orrery.controlPanelBG3 : this.orrery.controlPanelBG;
        this.setPanel(this.makePanel(kepler));
    }

    public JPanel makePanel(Kepler kepler) {
        JPanel jPanel = new JPanel();
        jPanel.setBackground(this.backgroundColor);
        jPanel.setLayout(new GridBagLayout());
        jPanel.setSize(new Dimension(256, 48));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        JPanel jPanel2 = new JPanel();
        jPanel2.setBorder(new MatteBorder(0, 0, 0, 0, this.orrery.controlPanelBorder));
        jPanel2.setBackground(this.orrery.controlPanelBG);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.insets = new Insets(0, 8, 0, 8);
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 10;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        this.resetToggle = this.makeResetToggle();
        jPanel2.add(this.resetToggle);
        jPanel2.add(this.getPauseToggle());
        jPanel2.add(this.getStepButton());
        if (!kepler.kioskMode()) {
            jPanel2.add(this.getMuteToggle());
            if (this.includeFrameControls) {
                jPanel2.add(this.getFullScreenToggle());
            }
        }
        return jPanel;
    }

    public void worldRead() {
    }

    public void dawnOfCreation() {
    }

    public void endOfTheWorld() {
    }

    private JToggleButton getPauseToggle() {
        if (this.pauseToggle == null) {
            String string = "pause.gif";
            String string2 = "play.gif";
            String string3 = "play_pause_disabled.gif";
            this.pauseToggle = new JToggleButton(Kepler.createImageIcon(string, "Pause"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Play");
            this.pauseToggle.setBorderPainted(false);
            this.pauseToggle.setPressedIcon(imageIcon);
            this.pauseToggle.setSelectedIcon(imageIcon);
            ImageIcon imageIcon2 = Kepler.createImageIcon(string3, "Play");
            this.pauseToggle.setDisabledIcon(imageIcon2);
            this.pauseToggle.setDisabledSelectedIcon(imageIcon2);
            this.pauseToggle.setMargin(new Insets(0, 0, 0, 0));
            this.pauseToggle.setContentAreaFilled(false);
            this.pauseToggle.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    if (!BottomControlsPanel.this.pauseToggle.isEnabled()) {
                        return;
                    }
                    BottomControlsPanel.this.orrery.resetPlayTimer();
                    boolean bl = BottomControlsPanel.this.pauseToggle.isSelected();
                    if (BottomControlsPanel.this.orrery.isInitialConditionsMode()) {
                        if (!bl) {
                            System.out.println("PAUSE button while in init cond mode. restarting...");
                            BottomControlsPanel.this.orrery.getWorldBuilder().setInitialConditionsMode(false);
                            BottomControlsPanel.this.resetToggle.setSelected(false);
                        }
                    } else {
                        BottomControlsPanel.this.orrery.setPaused(BottomControlsPanel.this.pauseToggle.isSelected());
                        BottomControlsPanel.this.kepler.setMode("pause", BottomControlsPanel.this.pauseToggle.isSelected());
                    }
                }
            });
        }
        return this.pauseToggle;
    }

    private JToggleButton getMuteToggle() {
        if (this.muteToggle == null) {
            String string = "mute_off.gif";
            String string2 = "mute_on.gif";
            this.muteToggle = new JToggleButton(Kepler.createImageIcon(string, "Turn on force field"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Turn off force field");
            this.muteToggle.setBorderPainted(false);
            this.muteToggle.setPressedIcon(imageIcon);
            this.muteToggle.setSelectedIcon(imageIcon);
            this.muteToggle.setMargin(new Insets(0, 0, 0, 0));
            this.muteToggle.setContentAreaFilled(false);
            this.muteToggle.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BottomControlsPanel.this.orrery.setMuted(BottomControlsPanel.this.muteToggle.isSelected());
                }
            });
        }
        return this.muteToggle;
    }

    private JToggleButton getFullScreenToggle() {
        if (this.fullScreenToggle == null) {
            String string = "fullscreen_off.gif";
            String string2 = "fullscreen_on.gif";
            this.fullScreenToggle = new JToggleButton(Kepler.createImageIcon(string, "Turn on full screen"));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, "Turn off full screen");
            this.fullScreenToggle.setBorderPainted(false);
            this.fullScreenToggle.setPressedIcon(imageIcon);
            this.fullScreenToggle.setSelectedIcon(imageIcon);
            this.fullScreenToggle.setMargin(new Insets(0, 0, 0, 0));
            this.fullScreenToggle.setContentAreaFilled(false);
            this.fullScreenToggle.addChangeListener(new ChangeListener(){

                public void stateChanged(ChangeEvent changeEvent) {
                    BottomControlsPanel.this.kepler.setFullScreen(BottomControlsPanel.this.fullScreenToggle.isSelected());
                }
            });
        }
        return this.fullScreenToggle;
    }

    private JToggleButton makeResetToggle() {
        final JToggleButton jToggleButton = this.makeImageToggleButton("ResetToggle_up.gif", "ResetToggle_down.gif", "ResetToggle_disabled.gif", "Reset world to initial conditions");
        jToggleButton.setSelected(false);
        jToggleButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                System.out.println("Reset toggle pressed.");
                boolean bl = jToggleButton.isSelected();
                WorldBuilder worldBuilder = BottomControlsPanel.this.orrery.getWorldBuilder();
                if (bl) {
                    BottomControlsPanel.this.orrery.setPaused(true);
                    worldBuilder.setInitialConditionsMode(true);
                    BottomControlsPanel.this.kepler.setMode("initialconditions", true);
                    BottomControlsPanel.this.kepler.setMode("pause", true);
                } else {
                    worldBuilder.setInitialConditionsMode(false);
                    BottomControlsPanel.this.kepler.setMode("initialconditions", false);
                    BottomControlsPanel.this.kepler.setMode("pause", false);
                }
            }
        });
        return jToggleButton;
    }

    private JButton getStepButton() {
        if (this.stepButton == null) {
            String string = "SingleStep.gif";
            String string2 = "SingleStep_pressed.gif";
            String string3 = "SingleStep_disabled.gif";
            String string4 = "Single Step";
            this.stepButton = new JButton(Kepler.createImageIcon(string, string4));
            ImageIcon imageIcon = Kepler.createImageIcon(string2, string4);
            ImageIcon imageIcon2 = Kepler.createImageIcon(string3, string4);
            this.stepButton.setBorderPainted(false);
            this.stepButton.setPressedIcon(imageIcon);
            this.stepButton.setSelectedIcon(imageIcon);
            this.stepButton.setDisabledIcon(imageIcon2);
            this.stepButton.setMargin(new Insets(0, 0, 0, 0));
            this.stepButton.setContentAreaFilled(false);
            this.stepButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent actionEvent) {
                    BottomControlsPanel.this.orrery.resetPlayTimer();
                    if (BottomControlsPanel.this.orrery.isInitialConditionsMode()) {
                        WorldBuilder worldBuilder = BottomControlsPanel.this.orrery.getWorldBuilder();
                        worldBuilder.setInitialConditionsMode(false);
                        BottomControlsPanel.this.kepler.setMode("initialconditions", false);
                        BottomControlsPanel.this.kepler.setMode("pause", true);
                        BottomControlsPanel.this.orrery.pause();
                    }
                    BottomControlsPanel.this.orrery.singleStep();
                }
            });
        }
        return this.stepButton;
    }

    public void setMode(String string, boolean bl) {
        if (string.equals("pause")) {
            this.pauseToggle.setSelected(bl);
            if (this.stepButton != null) {
                this.stepButton.setEnabled(bl);
            }
        } else if (string.equals("initialconditions")) {
            this.stepButton.setEnabled(!bl);
            this.resetToggle.setSelected(bl);
        } else if (string.equals("worldtransition")) {
            this.stepButton.setEnabled(!bl);
            this.resetToggle.setEnabled(!bl);
            this.resetToggle.setSelected(false);
            this.pauseToggle.setEnabled(false);
            this.pauseToggle.setSelected(false);
            this.pauseToggle.setEnabled(!bl);
        }
    }
}

