/*
 * Decompiled with CFR 0.152.
 */
package kepler;

import java.awt.Color;
import kepler.Orrery;
import kepler.Playable;
import kepler.Rock;
import kepler.Vect;
import util.StdDraw;

public class Body {
    public static final int REBOUND_NONE = 0;
    public static final int REBOUND_SQUARE = 1;
    public static final int REBOUND_CIRCLE = 2;
    public static final int REBOUND_CIRCLE_FAKE = 3;
    public static final int REBOUND_CIRCLE_NOTRAP = 4;
    public static final int REBOUND_TORUS = 5;
    public static final int DEFAULT_REBOUND_METHOD = 1;
    public static final int M2SM_LINEAR = 0;
    public static final int M2SM_CUBE_ROOT = 1;
    public Vect pos = null;
    public Vect v = null;
    public double mass;
    public double radius;
    public static int massToSizeMethod = 1;
    protected static Orrery orrery;
    public static double orreryRadius;
    public static double baseRadius;
    public static double massToSizeFactor;
    public boolean posSpecifiedPolar = false;
    public boolean vSpecifiedPolar = false;
    public boolean offsetSpecifiedPolar = false;
    public Vect posOffset = null;
    public static StdDraw drawer;
    protected int highlight = 0;
    protected int select = 0;
    protected int playing = 0;
    public int channel = 0;
    public String instrument = null;
    public boolean alive = true;
    protected Color color;
    protected Color highlightColor;
    protected Color playingColor;
    protected Color selectColor;
    protected double penRadius = 0.025;
    private static double friction;
    protected static double minDistance;
    public static double minMass;
    public static double maxMass;
    protected static double basePenRadius;
    protected static int reboundMethod;
    protected boolean constrainMovesToRadius = false;
    public static final int MUTATE_NONE = 0;
    public static final int MUTATE_MASS = 1;
    public static final int MUTATE_MASS_PERCENT = 2;
    public static final int MUTATE_VELOCITY_PERCENT = 3;
    public static final int MUTATE_CLONE = 4;
    public static final int MUTATE_KILLA = 5;
    public static final int MUTATE_BLACKHOLE = 6;
    public boolean is_mutator = false;
    public int mutating = 0;
    public int mutate_after = 0;
    public int mutate_mass_type = 0;
    public int mutate_mass_chance = 0;
    public double mutate_mass_lo = 0.0;
    public double mutate_mass_hi = 0.0;
    public int mutate_velocity_type = 0;
    public int mutate_velocity_chance = 0;
    public double mutate_velocity_lo = 0.0;
    public double mutate_velocity_hi = 0.0;
    public boolean mutate_clone = false;
    public int mutate_clone_chance = 0;
    public double mutate_clone_lo = 0.0;
    public double mutate_clone_hi = 0.0;
    public boolean mutate_killa = false;
    public int mutate_killa_chance = 0;
    public boolean mutate_blackhole = false;
    public int mutate_blackhole_chance = 0;
    private static int next_nth;
    private int nth = 0;
    protected double repelFactor = 1.0;
    protected double gravityFactor = 1.0;
    protected Playable playable = null;
    public boolean playableIsShared = false;
    boolean highlightControlBox = false;
    private static int numCollisions;
    private static Body[][] collisions;

    public Body() {
    }

    public Body(Vect vect, Vect vect2, double d, int n) {
        this.pos = vect;
        this.v = vect2;
        this.mass = d;
        this.init(n);
    }

    public void init(int n) {
        this.setMinMaxMasses(this.mass);
        this.nth = next_nth++;
        float f = (float)(1.0 / (double)n * (double)this.nth);
        if (f > 1.0f) {
            f = 1.0f;
        }
        this.color = Color.getHSBColor(f, 0.85f, 0.7f);
        this.highlightColor = Color.getHSBColor(f, 0.95f, 0.95f);
        this.playingColor = Color.getHSBColor(f, 0.95f, 1.0f);
        this.selectColor = Color.getHSBColor(f, 0.9f, 0.8f);
    }

    public Body duplicate() {
        Vect vect = this.pos.duplicate();
        Vect vect2 = this.v.duplicate();
        Body body = new Body(vect, vect2, this.mass, Body.orrery.maxBodies);
        body.cloneMutatorData(this);
        body.clonePlayable(this);
        body.posSpecifiedPolar = this.posSpecifiedPolar;
        body.vSpecifiedPolar = this.vSpecifiedPolar;
        body.offsetSpecifiedPolar = this.offsetSpecifiedPolar;
        body.posOffset = this.posOffset;
        return body;
    }

    protected void cloneMutatorData(Body body) {
        this.is_mutator = body.is_mutator;
        this.mutate_after = body.mutate_after;
        this.mutate_mass_type = body.mutate_mass_type;
        this.mutate_mass_chance = body.mutate_mass_chance;
        this.mutate_mass_lo = body.mutate_mass_lo;
        this.mutate_mass_hi = body.mutate_mass_hi;
        this.mutate_velocity_type = body.mutate_velocity_type;
        this.mutate_velocity_chance = body.mutate_velocity_chance;
        this.mutate_velocity_lo = body.mutate_velocity_lo;
        this.mutate_velocity_hi = body.mutate_velocity_hi;
        this.mutate_clone = body.mutate_clone;
        this.mutate_clone_chance = body.mutate_clone_chance;
        this.mutate_clone_lo = body.mutate_clone_lo;
        this.mutate_clone_hi = body.mutate_clone_hi;
        this.mutate_killa = body.mutate_killa;
        this.mutate_killa_chance = body.mutate_killa_chance;
        this.mutate_blackhole = body.mutate_blackhole;
        this.mutate_blackhole_chance = body.mutate_blackhole_chance;
    }

    public void clonePlayable(Body body) {
        this.playable = body.playable;
        this.setChannel(body.channel);
    }

    public void resetPlayable() {
        if (this.playable != null) {
            this.playable.reset();
        }
    }

    public static void resetNth() {
        next_nth = 0;
    }

    public static void resetDefaults() {
        next_nth = 0;
        minMass = -1.0;
        maxMass = 0.0;
        baseRadius = 512.0;
    }

    public static void setOrreryRadius(double d) {
        orreryRadius = d;
    }

    public static void setFriction(double d) {
        friction = d;
    }

    public static void setMinDistance(double d) {
        minDistance = d;
    }

    public static void setReboundMethod(int n) {
        reboundMethod = n;
    }

    public static int getReboundMethod() {
        return reboundMethod;
    }

    public static void setBaseRadius(double d) {
        baseRadius = d;
    }

    public double getRepelFactor() {
        return this.repelFactor;
    }

    public void setRepelFactor(double d) {
        this.repelFactor = d;
    }

    public double getGravityFactor() {
        return this.gravityFactor;
    }

    public void setGravityFactor(double d) {
        this.gravityFactor = d;
    }

    public Playable getPlayable() {
        return this.playable;
    }

    public void setPlayable(Playable playable) {
        this.playable = playable;
    }

    public boolean constrainMovesToRadius() {
        return this.constrainMovesToRadius;
    }

    public void setConstrainMovesToRadius(boolean bl) {
        this.constrainMovesToRadius = bl;
    }

    public double getMass() {
        return this.mass;
    }

    public Vect getPos() {
        return this.pos;
    }

    public Vect getVelocity() {
        return this.v;
    }

    public void move(Vect vect, double d) {
        Vect vect2 = vect.times(1.0 / this.mass);
        this.v.plusEquals(vect2.timesEquals(d));
        this.pos.plusEquals(this.v.times(d));
    }

    public void moveStep(double d) {
        this.pos.plusEquals(this.v.times(d));
    }

    public void moveStep() {
        this.pos.plusEquals(this.v.times(Body.orrery.dt));
    }

    public void move(Vect vect, double d, double d2, double d3) {
        Vect vect2 = vect.times(1.0 / this.mass);
        this.v.plusEquals(vect2.timesEquals(d));
        this.v.timesEquals(friction);
        this.pos.plusEquals(this.v.times(d));
        this.possiblyRebound(d2, d3);
    }

    public static String reboundMethodString(int n) {
        switch (n) {
            case 1: {
                return "square";
            }
            case 0: {
                return "none";
            }
            case 2: {
                return "circle";
            }
            case 3: {
                return "circlefake";
            }
            case 4: {
                return "circlenotrap";
            }
            case 5: {
                return "torus";
            }
        }
        return "square";
    }

    public void possiblyRebound(double d, double d2) {
        if (reboundMethod == 1) {
            if (Math.abs(this.pos.x()) > d) {
                this.v.setX(0.0 - this.v.x());
            }
            if (Math.abs(this.pos.y()) > d2) {
                this.v.setY(0.0 - this.v.y());
            }
        } else if (reboundMethod == 5) {
            double d3 = this.pos.x();
            double d4 = this.pos.y();
            double d5 = 2.0 * this.radius;
            double d6 = d + d5;
            double d7 = d2 + d5;
            if (d3 > d6) {
                this.pos.setX(d3 - 2.0 * d6);
            } else if (d3 < -d6) {
                this.pos.setX(d3 + 2.0 * d6);
            }
            if (d4 > d7) {
                this.pos.setY(d4 - 2.0 * d7);
            } else if (d4 < -d7) {
                this.pos.setY(d4 + 2.0 * d7);
            }
        } else if (reboundMethod == 3) {
            if (this.pos.magnitude() >= d) {
                this.v.timesEquals(-1.0);
            }
        } else if (reboundMethod == 2) {
            if (this.pos.magnitude() >= d) {
                Vect vect;
                Vect vect2 = this.pos.unit();
                this.v = vect = this.v.reflect(vect2);
            }
        } else if (reboundMethod == 4 && this.pos.magnitude() > d) {
            Vect vect = this.pos.unit();
            Vect vect3 = this.v.reflect(vect);
            System.out.println("\n");
            this.v = vect3;
            this.pos = vect.timesEquals(d);
        }
    }

    public Vect forceTo(Body body, double d, double d2, boolean bl) {
        if (body == null) {
            return Vect.ZERO;
        }
        double d3 = 6.67E-11;
        double d4 = -3.667E-9;
        Vect vect = this.pos.minus(body.pos);
        double d5 = this.mass * body.mass;
        double d6 = vect.magnitude();
        if (bl && (d6 < this.radius || d6 < body.radius)) {
            this.registerCollision(body);
        }
        d6 = Math.max(d6, minDistance);
        double d7 = d6 * d6;
        double d8 = d7 * d6;
        double d9 = this.gravityFactor * d * d3 * d5 / d7 + this.repelFactor * d2 * d4 * d5 / d8;
        return vect.unitEquals().timesEquals(d9);
    }

    public void setDrawColor(StdDraw stdDraw) {
        if (this.select == -1) {
            stdDraw.setPenColor(this.selectColor);
        } else if (this.select > 0) {
            stdDraw.setPenColor(this.selectColor);
            --this.select;
        } else if (this.playing > 0) {
            stdDraw.setPenColor(this.playingColor);
            --this.highlight;
        } else if (this.highlight > 0) {
            stdDraw.setPenColor(this.highlightColor);
            --this.highlight;
        } else if (this.highlight == -1) {
            stdDraw.setPenColor(this.highlightColor);
        } else {
            stdDraw.setPenColor(this.color);
        }
        if (this.mutating > 0) {
            stdDraw.setPenColor(this.selectColor);
            --this.mutating;
        }
        if (this.playing > 0) {
            --this.playing;
        }
    }

    public void draw(StdDraw stdDraw) {
        double d = this.pos.x();
        double d2 = this.pos.y();
        this.setDrawColor(stdDraw);
        stdDraw.filledCircle(d, d2, this.radius);
        if (this.is_mutator) {
            stdDraw.setPenColor(this.selectColor);
            stdDraw.circle(d, d2, this.radius * 0.75);
        }
        if (this.select == -1) {
            if (orrery.paused()) {
                this.drawSelectedControls(stdDraw, d, d2);
            } else {
                double d3 = Math.max(this.radius * 1.5, baseRadius * 2.0);
                stdDraw.circle(this.pos.x(), this.pos.y(), d3);
            }
        }
    }

    protected void drawSelectedControls(StdDraw stdDraw, double d, double d2) {
        double d3 = 1.5 * baseRadius;
        double d4 = this.getControlBoxWidth();
        stdDraw.setPenColor(this.selectColor);
        stdDraw.square(d, d2, d4);
        if (this.highlightControlBox) {
            stdDraw.setPenColor(Color.YELLOW);
        } else {
            stdDraw.setPenColor(Color.BLUE);
        }
        stdDraw.filledSquare(d + d4, d2 + d4, d3);
        stdDraw.filledSquare(d + d4, d2 - d4, d3);
        stdDraw.filledSquare(d - d4, d2 + d4, d3);
        stdDraw.filledSquare(d - d4, d2 - d4, d3);
        if (!(this instanceof Rock)) {
            Vect vect = this.v.times(Body.orrery.dt);
            if (Body.orrery.dragChangesVelocityOnSelectedBody) {
                stdDraw.setPenColor(Body.orrery.highlightVelocityColor);
            } else {
                stdDraw.setPenColor(Body.orrery.velocityColor);
            }
            double d5 = Body.orrery.ctlVelocityFactor;
            orrery.drawVectWithHandle(stdDraw, this.pos.x, this.pos.y, vect, d5, 1.3 * baseRadius);
        }
        orrery.drawBodyStats(this);
    }

    public double getControlBoxWidth() {
        return Math.max(this.radius * 1.5, baseRadius * 4.0);
    }

    public void highlightControlBox(boolean bl) {
        this.highlightControlBox = bl;
    }

    public String getInstrument() {
        return this.instrument;
    }

    public void setInstrument(String string) {
        this.instrument = string;
    }

    public void setChannel(int n) {
        this.channel = n;
    }

    public int getChannel() {
        return this.channel;
    }

    public void highlight(int n) {
        this.highlight = n;
    }

    public int getHighlight() {
        return this.highlight;
    }

    public void select(int n) {
        this.select = n;
    }

    public void unselect() {
        this.select(0);
    }

    public int getSelect() {
        return this.select;
    }

    public boolean isPlaying() {
        return this.playing > 0;
    }

    public int getPlaying() {
        return this.playing;
    }

    public void setPlaying(int n) {
        this.playing = n;
    }

    public static double getMaxMass() {
        return maxMass;
    }

    public static void setMaxMass(double d) {
        maxMass = d;
    }

    public static double getMinMass() {
        return minMass;
    }

    public static void setMinMass(double d) {
        minMass = d;
    }

    public void setMinMaxMasses(double d) {
        if (minMass < 0.0 || d < minMass) {
            minMass = d;
        }
        if (d > maxMass) {
            maxMass = d;
        }
    }

    public void setMass(double d) {
        if (d != this.mass) {
            this.mass = d;
            this.massToSize(drawer);
        }
    }

    public void massToSize(StdDraw stdDraw) {
        double d = (this.massType(this.mass) - this.massType(minMass)) / (this.massType(maxMass) - this.massType(minMass));
        double d2 = 1.3 * orreryRadius / 20.0;
        this.radius = baseRadius + d * d2;
        if (this.radius <= 0.0) {
            this.radius = baseRadius;
        } else if (this.radius > d2 * 3.0) {
            this.radius = d2 * 3.0;
        }
        this.penRadius = stdDraw.factorX(this.radius);
    }

    private double massType(double d) {
        if (massToSizeMethod == 0) {
            return d;
        }
        if (massToSizeMethod == 1) {
            double d2 = 0.3333333333333333;
            return Math.pow(d, d2);
        }
        return d;
    }

    public boolean intersects(double d, double d2) {
        double d3 = this.radius;
        return this.pointIsClose(d, d2, this.pos.x(), this.pos.y(), d3);
    }

    public boolean intersects(double d, double d2, double d3) {
        double d4 = this.radius * d3;
        return this.pointIsClose(d, d2, this.pos.x(), this.pos.y(), d4);
    }

    public boolean controlBoxHandleIntersects(double d, double d2, double d3) {
        double d4 = baseRadius * d3;
        double d5 = this.getControlBoxWidth();
        double d6 = this.pos.x();
        double d7 = this.pos.y();
        boolean bl = !this.intersects(d, d2, 1.0) && (this.pointIsClose(d, d2, d6 + d5, d7 + d5, d4) || this.pointIsClose(d, d2, d6 + d5, d7 - d5, d4) || this.pointIsClose(d, d2, d6 - d5, d7 + d5, d4) || this.pointIsClose(d, d2, d6 - d5, d7 - d5, d4));
        return bl;
    }

    public boolean pointIsClose(double d, double d2, double d3, double d4, double d5) {
        boolean bl = d > d3 - d5 && d < d3 + d5 && d2 > d4 - d5 && d2 < d4 + d5;
        return bl;
    }

    public void moveto(double d, double d2) {
        this.pos.setX(d);
        this.pos.setY(d2);
    }

    public void moveto(Vect vect) {
        this.pos.setX(vect.x());
        this.pos.setY(vect.y());
    }

    public void movetoPolar(double d, double d2) {
        Vect vect = Vect.createPolarDegrees(d, d2);
        this.moveto(vect.x(), vect.y());
    }

    public void moveto_constrainRadius(double d, double d2) {
        double d3 = this.pos.r();
        Vect vect = new Vect(d, d2).unitEquals();
        this.pos = vect.times(d3);
    }

    public void setV(double d, double d2) {
        this.v.setX(d);
        this.v.setY(d2);
    }

    public void setV(Vect vect) {
        this.setV(vect.x(), vect.y());
    }

    public void registerCollision(Body body) {
        Body.addCollision(this, body);
    }

    public static void setupCollisions(int n) {
        collisions = new Body[n][];
    }

    public static int getNumCollisions() {
        return numCollisions;
    }

    public static void resetCollisions() {
        numCollisions = 0;
    }

    public static Body[][] getCollisions() {
        return collisions;
    }

    public static Body[] getCollision(int n) {
        if (n < numCollisions) {
            return collisions[n];
        }
        return null;
    }

    public static boolean addCollision(Body body, Body body2) {
        for (int i = 0; i < numCollisions; ++i) {
            Body[] bodyArray = collisions[i];
            if (body2 != bodyArray[0] || body != bodyArray[1]) continue;
            return false;
        }
        Body.collisions[Body.numCollisions] = new Body[]{body, body2};
        ++numCollisions;
        return true;
    }

    public void die() {
        this.alive = false;
    }

    public void maybeMutate(Body body, int n) {
        double d;
        if (!this.is_mutator || body == null || body.mutating > 0) {
            return;
        }
        if (this.mutate_after > 0 && n < this.mutate_after) {
            return;
        }
        if (this.mutate_mass_type == 1) {
            if (Body.randomChance(this.mutate_mass_chance)) {
                body.mass = Body.randomRange(this.mutate_mass_lo, this.mutate_mass_hi);
                body.massToSize(drawer);
                body.mutating = 20;
            }
        } else if (this.mutate_mass_type == 2 && Body.randomChance(this.mutate_mass_chance)) {
            d = Body.randomRange(this.mutate_mass_lo, this.mutate_mass_hi) / 100.0;
            body.mass *= d;
            body.massToSize(drawer);
            body.mutating = 20;
        }
        if (this.mutate_velocity_type == 3 && !(body instanceof Rock) && Body.randomChance(this.mutate_velocity_chance)) {
            d = Body.randomRange(this.mutate_velocity_lo, this.mutate_velocity_hi) / 100.0;
            body.v.timesEquals(d);
            body.mutating = 20;
        }
        if (this.mutate_clone && Body.randomChance(this.mutate_clone_chance)) {
            d = Body.randomRange(this.mutate_clone_lo, this.mutate_velocity_hi) / 100.0;
            body.mass *= d;
            body.massToSize(drawer);
            Body body2 = body.duplicate();
            if (body2 instanceof Rock) {
                orrery.addRock((Rock)body2);
            } else {
                double d2;
                orrery.addBody(body2);
                body.v.thetaPlusEqualsDegrees(30.0);
                body2.v.thetaPlusEqualsDegrees(-30.0);
                double d3 = body.v.r();
                if (d3 > 60.0) {
                    body.v.setR(60.0);
                }
                if ((d2 = body2.v.r()) > 50.0) {
                    body2.v.setR(50.0);
                }
            }
            body.moveStep();
            body2.moveStep();
            body.moveStep();
            body2.moveStep();
            body.mutating = 30;
            body2.mutating = 30;
        }
        if (this.mutate_killa) {
            if (Body.randomChance(this.mutate_killa_chance)) {
                body.die();
                this.mutating = 20;
            } else {
                body.mutating = 40;
            }
        } else if (this.mutate_blackhole) {
            if (Body.randomChance(this.mutate_blackhole_chance)) {
                d = body.mass;
                this.mutating = 20;
                this.mass += d;
                this.massToSize(drawer);
                body.die();
            } else {
                body.mutating = 40;
            }
        }
    }

    public static boolean randomChance(int n) {
        double d = Math.random();
        return d * 100.0 < (double)n;
    }

    public static double randomRange(double d, double d2) {
        double d3 = d2 - d;
        return d + d3 * Math.random();
    }

    static {
        baseRadius = 512.0;
        massToSizeFactor = 1.234;
        friction = 0.99;
        minMass = -1.0;
        maxMass = 0.0;
        basePenRadius = 0.025;
        reboundMethod = 1;
        next_nth = 0;
        numCollisions = 0;
    }
}

